/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.units.ITickableUnit;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.blocks.PollutedWater;
import com.endertech.minecraft.mods.adpother.pollution.PointPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import org.apache.commons.lang3.ObjectUtils;

public class EntityPollution
extends PointPollution
implements ITickableUnit {
    protected final Entity entity;
    protected final GameTime updateInterval;
    protected boolean exist = true;
    private boolean explosionRisk;

    public EntityPollution(Entity entity, GameTime updateInterval, CommonTime.Interval lifeSpan) {
        super(entity.func_130014_f_(), entity.func_174824_e(1.0f), lifeSpan);
        this.entity = entity;
        this.updateInterval = updateInterval;
    }

    public static EntityPollution of(Entity entity) {
        EntityPollution pollution = new EntityPollution(entity, GameTime.second(), CommonTime.Interval.seconds((double)3.0));
        pollution.update();
        return pollution;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public boolean exists() {
        return this.exist;
    }

    public GameTime getUpdateInterval() {
        return this.updateInterval;
    }

    public void onUpdate() {
        Entity entity = this.getEntity();
        if (!entity.func_70089_S()) {
            this.kill();
            return;
        }
        World world = this.getWorld();
        if (world == null || !world.isAreaLoaded(this.getBlockPos(), 1)) {
            this.kill();
            return;
        }
        if (this.isOutdated()) {
            this.update();
        }
    }

    @Override
    public void update() {
        this.setPosition(this.getEntity().func_174824_e(1.0f));
        super.update();
    }

    public void kill() {
        this.exist = false;
    }

    public Optional<Pollutant<?>> getDominantPollutant(Predicate<Pollutant<?>> filter) {
        Percentage largestInfluence = Percentage.ZERO;
        Pollutant dominant = null;
        for (Pollutant pollutant : AdPother.getInstance().pollutants.getAll()) {
            Percentage influence;
            if (!filter.test(pollutant) || (influence = this.getInfluenceOf(pollutant)).compareTo(largestInfluence) <= 0) continue;
            largestInfluence = influence;
            dominant = pollutant;
        }
        return Optional.ofNullable(dominant);
    }

    public boolean isDirectContactWith(Pollutant<?> pollutant) {
        if (pollutant.isSamePollutant(this.getState())) {
            return true;
        }
        boolean isPollutedWater = PollutedWater.isPollutedWith(pollutant, (IBlockReader)this.getWorld(), this.getBlockPos(), this.getState());
        return isPollutedWater && this.entity.func_208600_a((ITag)FluidTags.field_206959_a);
    }

    public int getDamageFrom(Pollutant<?> pollutant) {
        Percentage influence = this.getInfluenceOf(pollutant);
        int damage = MathHelper.func_76141_d((float)(influence.toFraction() * (float)pollutant.getPollutionCapacity()));
        if (this.isDirectContactWith(pollutant)) {
            damage = Math.max(damage, 1);
        }
        return damage;
    }

    public Stream<Pollutant<?>> getPollutants() {
        return this.getInfos().map(info -> info.getPollutant());
    }

    public Percentage getInfluenceOf(Pollutant<?> pollutant) {
        Percentage influence = this.getInfoFor(pollutant).map(info -> info.getPercentageIn(this.getBiomeId())).orElse(Percentage.ZERO);
        if (this.isDirectContactWith(pollutant)) {
            int amount = pollutant.getCarriedPollutionAmount(this.getState());
            Percentage directInfluence = Percentage.from((int)amount, (int)pollutant.getPollutionCapacity());
            int air = this.entity.func_70086_ai();
            float airFactor = GameBounds.ENTITY_AIR.getIntBounds().approxFactor(Integer.valueOf(air));
            Percentage airDeficite = Percentage.from((float)(1.0f - airFactor));
            return (Percentage)ObjectUtils.max((Comparable[])new Percentage[]{influence, directInfluence, airDeficite});
        }
        return influence;
    }

    public boolean hasExplosionRisk() {
        return this.explosionRisk;
    }

    public void setExplosionRisk(boolean explosionRisk) {
        this.explosionRisk = explosionRisk;
    }

    @Override
    public void readFrom(CompoundNBT compound) {
        super.readFrom(compound);
        this.setExplosionRisk(compound.func_74767_n("explosionRisk"));
    }

    @Override
    public void writeTo(CompoundNBT compound) {
        super.writeTo(compound);
        compound.func_74757_a("explosionRisk", this.hasExplosionRisk());
    }

    public static class NetMsg
    extends ForgeNetMsg<NetMsg> {
        public int entityId;
        public CompoundNBT compound;

        public NetMsg() {
        }

        public NetMsg(EntityPollution pollution) {
            this.entityId = pollution.entity.func_145782_y();
            this.compound = new CompoundNBT();
            pollution.writeTo(this.compound);
        }

        public NetMsg create() {
            return new NetMsg();
        }

        public void handle(World world, PlayerEntity player) {
            Entity entity = world.func_73045_a(this.entityId);
            if (entity != null) {
                EntityPollution pollution = WorldData.getEntityPollution(entity);
                pollution.readFrom(this.compound);
                pollution.update();
            }
        }

        public void sendToAllAround(IServerWorld world, BlockPos pos, int radius) {
            AdPother.getInstance().getConnection().sendToAllAround((Object)this, world, pos, radius);
        }
    }
}

