/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.pollution.GasChain;
import com.endertech.minecraft.mods.adpother.sources.Torch;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class GasExplosion {
    public static int maxChainLength = 512;
    protected World world;
    protected Iterable<BlockPos> positions = Collections.emptyList();
    protected Consumer<? super GasChain> action = chain -> {};

    protected GasExplosion(World world) {
        this.world = world;
    }

    public static GasExplosion in(World world) {
        return new GasExplosion(world);
    }

    public GasExplosion position(BlockPos position) {
        return this.positions(Collections.singleton(position));
    }

    public GasExplosion positions(Iterable<BlockPos> positions) {
        this.positions = positions;
        return this;
    }

    public GasExplosion action(Consumer<? super GasChain> action) {
        this.action = action;
        return this;
    }

    public boolean tryTrigger() {
        for (BlockPos pos : this.positions) {
            AbstractGas gas;
            BlockState state = this.world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (!(block instanceof AbstractGas) || (gas = (AbstractGas)block).getLowerExplosiveLimit() <= 0 || gas.affectsPollutionLevel((IWorld)this.world, pos, state)) continue;
            GasChain chain = new GasChain((IWorld)this.world, pos, gas, gas.getLowerExplosiveLimit());
            chain.build();
            if (chain.getFound().size() < gas.getLowerExplosiveLimit()) continue;
            this.action.accept(chain);
            return true;
        }
        return false;
    }

    public boolean tryExplode() {
        return this.action(GasExplosion::explode).tryTrigger();
    }

    public static void explode(GasChain fuseChain) {
        IWorld world = fuseChain.getWorld();
        GasChain fullChain = new GasChain(world, fuseChain.getStartPos(), fuseChain.getGas(), maxChainLength);
        fullChain.build();
        int maxExplosions = (int)Math.max(1.0, CommonMath.raiseToPower((double)fullChain.length(), (double)0.3333333333333333));
        int maxExplosionSize = (int)Math.sqrt(fullChain.length());
        int step = Math.max(1, fullChain.length() / maxExplosions);
        HashMap<BlockPos, Float> explosions = new HashMap<BlockPos, Float>(maxExplosions + 1, 1.0f);
        for (int i = 0; i < fullChain.length(); i += step) {
            float explosionSize = 0.0f;
            BlockPos centerPos = (BlockPos)fullChain.getChain().get(i);
            for (BlockPos pos2 : GameWorld.Positions.getAroundHoriz((BlockPos)centerPos, (boolean)false, (BlockPos[])new BlockPos[]{centerPos.func_177984_a(), centerPos.func_177977_b(), centerPos})) {
                BlockState state = world.func_180495_p(pos2);
                if (!((explosionSize += (float)fullChain.getGas().getCarriedPollutionAmount(state)) >= (float)maxExplosionSize)) continue;
                explosionSize = maxExplosionSize;
                break;
            }
            if (!(explosionSize > 0.0f)) continue;
            explosions.put(centerPos, Float.valueOf(explosionSize));
        }
        if (world instanceof ServerWorld) {
            fullChain.getChain().forEach(pos -> world.func_217377_a(pos, false));
            explosions.forEach((pos, size) -> GameWorld.scheduleBlockExplosion((ServerWorld)((ServerWorld)world), (BlockPos)pos, (CommonTime.Interval)CommonTime.Interval.ZERO, (float)size.floatValue(), (boolean)true, (Explosion.Mode)Explosion.Mode.BREAK, (boolean)false, null));
        }
    }

    public static GasExplosion fromHeldTorch(PlayerEntity player) {
        GasExplosion explosion = GasExplosion.in(player.func_130014_f_());
        Set<Hand> hands = GasExplosion.getTorchHoldingHands(player);
        return hands.isEmpty() ? explosion : explosion.positions(GasExplosion.getIgnitablePositionsAround(player, hands));
    }

    public static List<BlockPos> getIgnitablePositionsAround(PlayerEntity player, Set<Hand> hands) {
        Direction face = player.func_174811_aO();
        BlockPos eyes = ForgeEntity.getPositionEyes((Entity)player);
        BlockPos body = eyes.func_177977_b();
        ArrayList positions = Lists.newArrayList((Object[])new BlockPos[]{eyes.func_177984_a(), eyes.func_177972_a(face), body.func_177972_a(face)});
        for (Hand hand : hands) {
            Direction facing = hand == Hand.MAIN_HAND ? face.func_176746_e() : face.func_176735_f();
            positions.add(eyes.func_177972_a(facing));
            positions.add(body.func_177972_a(facing));
        }
        positions.add(eyes);
        positions.add(body);
        return positions;
    }

    public static Set<Hand> getTorchHoldingHands(PlayerEntity player) {
        EnumSet<Hand> hands = EnumSet.noneOf(Hand.class);
        for (Hand hand : Hand.values()) {
            ItemStack stack = player.func_184586_b(hand);
            Torch torch = (Torch)AdPother.getInstance().torches.findBy(stack);
            if (torch == null) continue;
            hands.add(hand);
        }
        return hands;
    }
}

