/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.pollution.IFilterFrame;
import net.minecraft.block.Block;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public interface IPurifier {
    public boolean hasProperInput(IWorldReader var1, BlockPos var2);

    public boolean hasProperOutput(IWorldReader var1, BlockPos var2);

    public BlockPos getOutputPos(IWorldReader var1, BlockPos var2);

    public BlockPos getPumpPos(IWorldReader var1, BlockPos var2);

    default public boolean isActive(IWorldReader world, BlockPos filterPos) {
        BlockPos pumpPos = this.getPumpPos(world, filterPos);
        return this.hasActivePump(world, pumpPos) && this.hasProperInput(world, pumpPos) && this.hasActiveFilter(world, filterPos) && this.hasProperOutput(world, this.getOutputPos(world, filterPos));
    }

    default public boolean hasActiveFilter(IWorldReader world, BlockPos filterPos) {
        Block block = world.func_180495_p(filterPos).func_177230_c();
        return block instanceof IFilterFrame && block instanceof ISmokeContainer && ((ISmokeContainer)block).isActive((IBlockReader)world, filterPos);
    }

    default public boolean hasActivePump(IWorldReader world, BlockPos pumpPos) {
        return GameWorld.SmokeContainers.isActivePump((IWorldReader)world, (BlockPos)pumpPos);
    }

    default public void spawnParticle(World world, BlockPos filterPos, BasicParticleType type) {
        BlockPos pos = this.getOutputPos((IWorldReader)world, filterPos);
        world.func_195594_a((IParticleData)type, (double)pos.func_177958_n() + CommonMath.Random.between((double)0.4, (double)0.6), (double)pos.func_177956_o() + CommonMath.Random.between((double)0.0, (double)0.6), (double)pos.func_177952_p() + CommonMath.Random.between((double)0.4, (double)0.6), 0.0, 0.0, 0.0);
    }
}

