/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public interface IStorage<S> {
    public Content getContent(S var1);

    public int getInitialCapacity(S var1);

    public void onContentChanged(Content var1, S var2);

    default public void _handleChanges(Content content, S storage) {
        if (content.changed) {
            this.onContentChanged(content, storage);
            content.changed = false;
        }
    }

    default public void removeFiltersFor(S storage, Pollutant<?> ... pollutants) {
        Content content = this.getContent(storage).removeFiltersFor(pollutants);
        this._handleChanges(content, storage);
    }

    default public void installFiltersFor(S storage, Pollutant<?> ... pollutants) {
        Content content = this.getContent(storage);
        int capacity = this.getInitialCapacity(storage);
        content.installFiltersFor(capacity, pollutants);
        this._handleChanges(content, storage);
    }

    default public int fill(S storage, Pollutant<?> pollutant, int amount) {
        if (amount <= 0) {
            return 0;
        }
        Content content = this.getContent(storage);
        int count = content.fillWith(pollutant, amount);
        this._handleChanges(content, storage);
        return count;
    }

    default public int free(S storage, Pollutant<?> pollutant, int amount) {
        if (amount <= 0) {
            return 0;
        }
        Content content = this.getContent(storage);
        int count = content.freeFrom(pollutant, amount);
        this._handleChanges(content, storage);
        return count;
    }

    public static class Content {
        protected final Map<Pollutant<?>, Integer> fullnessMap = new HashMap();
        protected int capacity = 0;
        public boolean changed = false;

        public Content(int capacity) {
            this.capacity = capacity;
        }

        public static Content from(CompoundNBT compound) {
            Content content = new Content(0);
            content.readFromNBT(compound);
            return content;
        }

        public int getFullnessWith(Pollutant<?> pollutant) {
            return this.fullnessMap.getOrDefault(pollutant, 0);
        }

        public int getCapacity() {
            return this.capacity;
        }

        public int getFiltersAmount() {
            return this.fullnessMap.size();
        }

        public Percentage getFullnessPercentageFor(Pollutant<?> pollutant) {
            return Percentage.from((int)this.getFullnessWith(pollutant), (int)this.getCapacity());
        }

        public int getFreeSpaceFor(Pollutant<?> pollutant) {
            return this.hasFilterFor(pollutant) ? this.getCapacity() - this.getFullnessWith(pollutant) : 0;
        }

        public int getHighestFullness() {
            int maxFullness = 0;
            for (int fullness : this.fullnessMap.values()) {
                if (fullness <= maxFullness) continue;
                maxFullness = fullness;
            }
            return maxFullness;
        }

        public Percentage getHighestFullnessPercentage() {
            return Percentage.from((int)this.getHighestFullness(), (int)this.getCapacity());
        }

        public boolean hasFunctionalFilters() {
            for (Integer fullness : this.fullnessMap.values()) {
                if (fullness >= this.getCapacity()) continue;
                return true;
            }
            return false;
        }

        public Content setCapacity(int capacity) {
            int old = this.capacity;
            if (old != capacity) {
                this.capacity = capacity;
                this.changed = true;
            }
            return this;
        }

        public boolean hasFilterFor(Pollutant<?> pollutant) {
            return this.fullnessMap.containsKey(pollutant);
        }

        public Content setFullnessWith(Pollutant<?> pollutant, int fullness) {
            Integer old = this.fullnessMap.put(pollutant, fullness);
            if (old == null || old != fullness) {
                this.changed = true;
            }
            return this;
        }

        public int fillWith(Pollutant<?> pollutant, int amount) {
            if (amount <= 0 || !this.hasFilterFor(pollutant)) {
                return 0;
            }
            int count = Math.min(this.getFreeSpaceFor(pollutant), amount);
            if (count > 0) {
                int fullness = this.getFullnessWith(pollutant);
                this.setFullnessWith(pollutant, fullness += count);
            }
            return count;
        }

        public int freeFrom(Pollutant<?> pollutant, int amount) {
            if (amount <= 0 || !this.hasFilterFor(pollutant)) {
                return 0;
            }
            int fullness = this.getFullnessWith(pollutant);
            int count = Math.min(fullness, amount);
            if (count > 0) {
                this.setFullnessWith(pollutant, fullness -= count);
            }
            return count;
        }

        public Content installFiltersFor(int capacity, Pollutant<?> ... pollutants) {
            for (Pollutant<?> pollutant : pollutants) {
                this.setFullnessWith(pollutant, 0);
            }
            this.setCapacity(capacity);
            return this;
        }

        public Content removeFiltersFor(Pollutant<?> ... pollutants) {
            for (Pollutant<?> pollutant : pollutants) {
                if (this.fullnessMap.remove(pollutant) == null) continue;
                this.changed = true;
            }
            return this;
        }

        public Content removeAllFilters() {
            if (!this.fullnessMap.isEmpty()) {
                this.fullnessMap.clear();
                this.changed = true;
            }
            return this;
        }

        public void readFromNBT(CompoundNBT compound) {
            if (!compound.func_150297_b("Fullness", 10)) {
                return;
            }
            CompoundNBT fullnessTag = compound.func_74775_l("Fullness");
            for (Pollutant pollutant : AdPother.getInstance().pollutants.getAll()) {
                String key = pollutant.getRegistryName().func_110623_a();
                if (fullnessTag.func_150297_b(key, 3)) {
                    int fullness = fullnessTag.func_74762_e(key);
                    this.setFullnessWith(pollutant, fullness);
                    continue;
                }
                this.removeFiltersFor(pollutant);
            }
            this.setCapacity(fullnessTag.func_74762_e("capacity"));
        }

        public void writeToNBT(CompoundNBT compound) {
            CompoundNBT fullnessTag = new CompoundNBT();
            for (Map.Entry<Pollutant<?>, Integer> entry : this.fullnessMap.entrySet()) {
                Pollutant<?> pollutant = entry.getKey();
                int fullness = entry.getValue();
                String key = pollutant.getRegistryName().func_110623_a();
                fullnessTag.func_74768_a(key, fullness);
            }
            fullnessTag.func_74768_a("capacity", this.getCapacity());
            compound.func_218657_a("Fullness", (INBT)fullnessTag);
        }
    }
}

