/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.client.Tooltip;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.IStorage;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IStorageItem
extends IStorage<ItemStack> {
    @Override
    default public IStorage.Content getContent(ItemStack storage) {
        CompoundNBT compound = storage.func_77978_p();
        if (compound != null) {
            return IStorage.Content.from(compound);
        }
        return new IStorage.Content(0);
    }

    @Override
    default public void onContentChanged(IStorage.Content content, ItemStack storage) {
        CompoundNBT compound = storage.func_196082_o();
        if (compound != null) {
            content.writeToNBT(compound);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void addInformation(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag flag) {
        IStorage.Content content = this.getContent(stack);
        Tooltip tip = Tooltip.of((ForgeMod)AdPother.getInstance(), (String)"storage_item", lines);
        tip.add(TextFormatting.WHITE, "contents");
        for (Pollutant pollutant : AdPother.getInstance().pollutants.getAll()) {
            if (!content.hasFilterFor(pollutant)) continue;
            Percentage fullness = content.getFullnessPercentageFor(pollutant);
            tip.addRaw(pollutant.getTextColor() + pollutant.func_235333_g_().getString() + ": " + fullness.toColoredText());
        }
        if (ForgeEndertech.isDebugMode()) {
            tip.add(TextFormatting.WHITE, "capacity", (Object)content.getCapacity());
        }
    }
}

