/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.ForgeNBT;
import com.endertech.minecraft.forge.math.AABB;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.ChunkLoc;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.PurifiedAir;
import com.endertech.minecraft.mods.adpother.pollution.AbstractPollution;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class PointPollution
extends AbstractPollution {
    private final World world;
    private BiomeId biome;
    private Vector3d position;
    private BlockPos blockpos;
    private BlockState state;
    protected CommonTime.Interval lifeSpan;
    protected CommonTime.Stamp lastUpdate;

    public PointPollution(World world, Vector3d position, CommonTime.Interval lifeSpan) {
        this.world = world;
        this.lifeSpan = lifeSpan;
        this.setPosition(position);
    }

    protected void setPosition(Vector3d position) {
        if (position.equals((Object)this.position)) {
            return;
        }
        this.position = position;
        this.blockpos = new BlockPos(position);
        this.biome = BiomeId.from((IWorld)this.world, (BlockPos)this.blockpos);
        this.state = this.world.func_180495_p(this.blockpos);
    }

    public boolean isOutdated() {
        return this.lastUpdate == null || CommonTime.Interval.passedFrom((CommonTime.Stamp)this.lastUpdate).moreThan(this.lifeSpan);
    }

    public BlockState getState() {
        return this.state;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public BlockPos getBlockPos() {
        return this.blockpos;
    }

    public World getWorld() {
        return this.world;
    }

    public BiomeId getBiomeId() {
        return this.biome;
    }

    public void update() {
        World world = this.getWorld();
        BlockPos blockPos = this.getBlockPos();
        this.lastUpdate = CommonTime.Stamp.now();
        if (!GameWorld.isServerSide((IWorldReader)world)) {
            return;
        }
        ChunkPos center = new ChunkPos(blockPos);
        FloatBounds distanceBounds = FloatBounds.from((Float)Float.valueOf(0.0f), (Float)Float.valueOf(24.0f));
        ArrayList<ChunkPollution> chunksPollution = new ArrayList<ChunkPollution>();
        for (ChunkPos chunkPos : GameWorld.Positions.getAroundHoriz((ChunkPos)center, (boolean)true, (ChunkPos[])new ChunkPos[]{center})) {
            if (!GameWorld.isBlockLoaded((IWorldReader)world, (BlockPos)chunkPos.func_206849_h())) continue;
            ChunkPollution pollution = WorldData.getChunkPollution(world, ChunkLoc.from((World)world, (ChunkPos)chunkPos));
            chunksPollution.add(pollution);
        }
        List cleanAirSources = world.func_217357_a(PurifiedAir.class, AABB.BLOCK.func_191194_a(this.position).func_186662_g(32.0));
        this.infoForPollutant.clear();
        for (Pollutant pollutant : AdPother.getInstance().pollutants.getAll()) {
            float cleanAirFactor;
            int cumulativeAmount = chunksPollution.stream().mapToInt(chunkPollution -> {
                int amount = chunkPollution.getInfoFor(pollutant).map(info -> info.getQuantity()).orElse(0);
                ChunkBounds chunkBounds = chunkPollution.getLocation().getBounds();
                Vector3d chunkCenter = GameWorld.getBlockCenter((BlockPos)new BlockPos(chunkBounds.getX().center().intValue(), 0, chunkBounds.getZ().center().intValue()).func_177963_a(0.0, this.position.field_72448_b, 0.0)).toVector3d();
                float distance = (float)this.position.func_72438_d(chunkCenter);
                float factor = distanceBounds.approxFactor(Float.valueOf(distance));
                amount = IntBounds.from((Integer)0, (Integer)amount).approxDown(factor);
                return amount;
            }).sum();
            if (cumulativeAmount > 0 && (cleanAirFactor = (float)cleanAirSources.stream().filter(air -> air.func_70089_S() && air.getPollutant().isPresent() && air.getPollutant().get() == pollutant).mapToDouble(air -> air.getConcentrationAt(this.position).toFraction()).sum()) > 0.0f) {
                cumulativeAmount -= Math.round((float)cumulativeAmount * cleanAirFactor);
            }
            if (cumulativeAmount <= 0 && !pollutant.isSamePollutant(this.state)) continue;
            this.getOrCreateInfoFor(pollutant).setQuantity(cumulativeAmount);
        }
    }

    @Override
    public void readFrom(CompoundNBT compound) {
        super.readFrom(compound);
        this.lifeSpan = CommonTime.Interval.seconds((double)compound.func_74769_h("lifeSpan"));
        this.setPosition(ForgeNBT.getVect3d((CompoundNBT)compound, (String)"Position").toVector3d());
    }

    @Override
    public void writeTo(CompoundNBT compound) {
        super.writeTo(compound);
        ForgeNBT.putVect3d((CompoundNBT)compound, (String)"Position", (Vect3d)Vect3d.from((Vector3d)this.position));
        compound.func_74780_a("lifeSpan", this.lifeSpan.inSeconds());
    }
}

