/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.data.INBTSerializable;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;

public class PollutionInfo
implements INBTSerializable<PollutionInfo> {
    private Pollutant<?> pollutant;
    private int quantity = 0;
    private double fraction = 0.0;
    private boolean dirty = false;
    public static final String FLOAT_VALUE_FORMAT = "%.4f";

    public PollutionInfo(Pollutant<?> pollutant) {
        this.pollutant = pollutant;
    }

    public float getFactorIn(BiomeId biome) {
        int criticalAmount = this.getCriticalAmountIn(biome);
        if (criticalAmount == 0) {
            return 0.0f;
        }
        return (float)this.getQuantity() / (float)criticalAmount;
    }

    public Percentage getPercentageIn(BiomeId biome) {
        return Percentage.from((float)this.getFactorIn(biome));
    }

    public Pollutant<?> getPollutant() {
        return this.pollutant;
    }

    public int getCriticalAmountIn(BiomeId biome) {
        return this.pollutant.getCriticalAmountIn(biome);
    }

    public int getQuantity() {
        return this.quantity;
    }

    public double getFraction() {
        return this.fraction;
    }

    public String getFormatedQuantity() {
        return String.format(FLOAT_VALUE_FORMAT, (double)this.getQuantity() + this.getFraction());
    }

    public String toChatString(BiomeId biome) {
        return Args.get((String)(this.getPollutant().getTextColor() + this.getPollutant().getRegistryName().func_110623_a()), (Object)this.getFormatedQuantity()) + " " + this.getPercentageIn(biome).toColoredText();
    }

    public String toString() {
        return this.getClass().getSimpleName() + Args.group((Object[])new Object[]{Args.get((String)"pollutant", (Object)this.getPollutant().getRegistryName().func_110623_a()), Args.get((String)"amount", (Object)this.getFormatedQuantity())});
    }

    public void setFraction(double fractAmount) {
        if (this.fraction != fractAmount) {
            this.fraction = fractAmount;
            this.setDirty(true);
        }
    }

    public void setQuantity(int amount) {
        if (this.quantity != amount) {
            this.quantity = amount;
            this.setDirty(true);
        }
    }

    protected void setPollutant(Pollutant<?> pollutant) {
        if (this.pollutant != pollutant) {
            this.pollutant = pollutant;
            this.setDirty(true);
        }
    }

    public void increaseQuantity(int number) {
        this.setQuantity(this.getQuantity() + number);
    }

    public boolean isEmpty() {
        return this.getPollutant() == null || this.getQuantity() == 0 && CommonMath.isAlmostZero((double)this.getFraction());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void markDirty() {
        this.setDirty(true);
    }

    public PollutionInfo readFrom(CompoundNBT compound) {
        int id = compound.func_74762_e("pollutantID");
        Block block = Block.func_196257_b((int)id).func_177230_c();
        if (block instanceof Pollutant) {
            Pollutant pollutant = (Pollutant)block;
            this.setPollutant(pollutant);
            this.setQuantity(compound.func_74762_e("quantity"));
            this.setFraction(compound.func_74769_h("fraction"));
        }
        return this;
    }

    public CompoundNBT writeTo(CompoundNBT compound) {
        compound.func_74768_a("pollutantID", Block.func_196246_j((BlockState)this.pollutant.func_176223_P()));
        compound.func_74768_a("quantity", this.getQuantity());
        compound.func_74780_a("fraction", this.getFraction());
        return compound;
    }
}

