/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonTime;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.Biomes;
import com.endertech.minecraft.forge.world.ChunkLoc;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.emissions.AbstractEntityEmission;
import com.endertech.minecraft.mods.adpother.emissions.DelayedTileEmission;
import com.endertech.minecraft.mods.adpother.emissions.PeriodicEntityEmission;
import com.endertech.minecraft.mods.adpother.emissions.PeriodicTileEmission;
import com.endertech.minecraft.mods.adpother.pollution.CarrierSpawnLimiter;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.sources.DroppedTorch;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.Torch;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerTickList;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class WorldData {
    public static IntBounds altitudeBounds = GameBounds.HEIGHT.getIntBounds();
    private static final Map<World, WorldData> DATA_FOR_WORLD = new ConcurrentHashMap<World, WorldData>();
    protected final Map<ChunkLoc, ChunkPollution> pollutionForChunk = new ConcurrentHashMap<ChunkLoc, ChunkPollution>();
    protected final Map<Entity, EntityPollution> pollutionForEntity = new ConcurrentHashMap<Entity, EntityPollution>();
    protected final Map<TileEntity, DelayedTileEmission> delayedTileEmissions = new ConcurrentHashMap<TileEntity, DelayedTileEmission>();
    protected final Map<TileEntity, PeriodicTileEmission> periodicTileEmissions = new ConcurrentHashMap<TileEntity, PeriodicTileEmission>();
    protected final Map<Entity, PeriodicEntityEmission> periodicEntityEmissions = new ConcurrentHashMap<Entity, PeriodicEntityEmission>();
    protected final Map<ItemEntity, DroppedTorch> droppedTorches = new ConcurrentHashMap<ItemEntity, DroppedTorch>();
    private final CarrierSpawnLimiter pollutantEntityLimiter = new CarrierSpawnLimiter();
    public final World world;
    private CommonTime.Stamp lastEmptyInfoCleanup = CommonTime.Stamp.now();

    protected WorldData(World world) {
        this.world = world;
    }

    @Nonnull
    public static WorldData getData(World world) {
        return DATA_FOR_WORLD.computeIfAbsent(world, WorldData::new);
    }

    @Nonnull
    public static ChunkPollution getChunkPollution(World world, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkLoc location = ChunkLoc.from((World)world, (ChunkPos)chunkPos);
        return WorldData.getChunkPollution(world, location);
    }

    @Nonnull
    public static ChunkPollution getChunkPollution(World world, ChunkLoc location) {
        WorldData data = WorldData.getData(world);
        ChunkPollution pollution = data.pollutionForChunk.computeIfAbsent(location, ChunkPollution::new);
        return pollution;
    }

    @Nonnull
    public static EntityPollution getEntityPollution(Entity entity) {
        World world = entity.func_130014_f_();
        WorldData data = WorldData.getData(world);
        EntityPollution pollution = data.pollutionForEntity.computeIfAbsent(entity, EntityPollution::of);
        return pollution;
    }

    public CarrierSpawnLimiter getPollutantCarrierLimiter() {
        return this.pollutantEntityLimiter;
    }

    public static void initBiomeConfigs() {
        AdPother mod = AdPother.getInstance();
        ForgeRegistries.BIOMES.getEntries().stream().map(entry -> BiomeId.from((RegistryKey)((RegistryKey)entry.getKey()))).forEach(biomeId -> Biomes.createConfigFor((ForgeMod)mod, (BiomeId)biomeId, (boolean)false).save());
        for (Path path : UnitConfig.listCustomConfigs((Path)Biomes.getConfigsBaseDir((ForgeMod)mod), null)) {
            UnitConfig config = new UnitConfig(path.toFile());
            BiomeId biomeId2 = Biomes.readBiomeId((UnitConfig)config);
            boolean enabled = Biomes.isConfigEnabled((UnitConfig)config);
            if (!biomeId2.isEmpty()) {
                for (Pollutant pollutant : AdPother.getInstance().pollutants.getAll()) {
                    pollutant.getBiomeProperties().forEach(prop -> prop.putValueFrom(config, (Object)biomeId2, enabled));
                }
            }
            config.save();
        }
    }

    public static void removeDataFor(IWorld world) {
        DATA_FOR_WORLD.remove(world);
    }

    public static void scheduleEmissionFor(TileEntity tile, Emitter emitter, Pollutant<?> pollutant, int amount) {
        World world = tile.func_145831_w();
        if (GameWorld.isServerSide((IWorldReader)world)) {
            WorldData data = WorldData.getData(world);
            DelayedTileEmission emission = data.delayedTileEmissions.get(tile);
            if (emission != null && emission.exists()) {
                emission.add(pollutant, amount);
            } else {
                emission = DelayedTileEmission.of(tile, emitter, pollutant, amount);
                data.delayedTileEmissions.put(tile, emission);
            }
        }
    }

    public void addIfEmitter(ServerWorld world, BlockPos pos, BlockState state, TileEntity tile) {
        Emitter emitter = (Emitter)AdPother.getInstance().emitters.findBy(state);
        if (emitter != null && emitter.getType().isTile() && emitter.isIdentified((INBTSerializable)tile)) {
            this.periodicTileEmissions.put(tile, PeriodicTileEmission.of(tile, emitter));
        }
    }

    public void addIfEmitter(ServerWorld world, Entity entity) {
        Emitter emitter = (Emitter)AdPother.getInstance().emitters.findBy(entity);
        if (emitter != null && emitter.getType().isEntity() && emitter.isIdentified((INBTSerializable)entity)) {
            this.periodicEntityEmissions.put(entity, PeriodicEntityEmission.of(entity, emitter));
        }
    }

    public void addIfDroppedTorch(ServerWorld world, Entity entity) {
        ItemEntity itemEntity;
        Torch torch;
        if (entity instanceof ItemEntity && (torch = (Torch)AdPother.getInstance().torches.findBy((itemEntity = (ItemEntity)entity).func_92059_d())) != null) {
            this.droppedTorches.put(itemEntity, DroppedTorch.of(itemEntity, torch));
        }
    }

    public static boolean isIgnitionSource(World world, BlockPos pos) {
        AdPother mod = AdPother.getInstance();
        Torch torch = (Torch)mod.torches.findBy(world.func_180495_p(pos));
        if (torch != null) {
            return true;
        }
        Emitter emitter = (Emitter)mod.emitters.findBy((IWorldReader)world, pos);
        return emitter != null && emitter.isActive((IWorldReader)world, pos);
    }

    public void removePeriodicEmissionFor(Entity entity) {
        this.periodicEntityEmissions.remove(entity);
    }

    public void tick() {
        AbstractEntityEmission emission;
        Iterator<Object> iterator = this.delayedTileEmissions.values().iterator();
        while (iterator.hasNext()) {
            emission = iterator.next();
            if (emission.exists()) {
                emission.tick();
                continue;
            }
            iterator.remove();
        }
        iterator = this.periodicTileEmissions.values().iterator();
        while (iterator.hasNext()) {
            emission = (PeriodicTileEmission)iterator.next();
            if (emission.exists()) {
                emission.tick();
                continue;
            }
            iterator.remove();
        }
        iterator = this.periodicEntityEmissions.values().iterator();
        while (iterator.hasNext()) {
            emission = (PeriodicEntityEmission)iterator.next();
            if (emission.exists()) {
                emission.tick();
                continue;
            }
            iterator.remove();
        }
        iterator = this.droppedTorches.values().iterator();
        while (iterator.hasNext()) {
            DroppedTorch torch = (DroppedTorch)iterator.next();
            if (torch.exists()) {
                torch.tick();
                continue;
            }
            iterator.remove();
        }
        iterator = this.pollutionForEntity.values().iterator();
        while (iterator.hasNext()) {
            EntityPollution pollution = (EntityPollution)iterator.next();
            if (pollution.exists()) {
                pollution.tick();
                continue;
            }
            iterator.remove();
        }
    }

    public void reloadEmitters() {
        ArrayList<PeriodicTileEmission> savedTileEmissions = new ArrayList<PeriodicTileEmission>(this.periodicTileEmissions.values());
        ArrayList<PeriodicEntityEmission> savedEntityEmissions = new ArrayList<PeriodicEntityEmission>(this.periodicEntityEmissions.values());
        this.periodicTileEmissions.clear();
        this.periodicEntityEmissions.clear();
        AdPother.getInstance().emitters.reloadConfigs();
        for (PeriodicTileEmission periodicTileEmission : savedTileEmissions) {
            TileEntity tile = (TileEntity)periodicTileEmission.getEntity();
            if (this.world != tile.func_145831_w() || !(this.world instanceof ServerWorld)) continue;
            this.addIfEmitter((ServerWorld)this.world, tile.func_174877_v(), tile.func_195044_w(), tile);
        }
        for (PeriodicEntityEmission periodicEntityEmission : savedEntityEmissions) {
            Entity entity = (Entity)periodicEntityEmission.getEntity();
            if (this.world != entity.func_130014_f_() || !(this.world instanceof ServerWorld)) continue;
            this.addIfEmitter((ServerWorld)this.world, entity);
        }
    }

    public void reloadTorches() {
        ArrayList<DroppedTorch> savedTorches = new ArrayList<DroppedTorch>(this.droppedTorches.values());
        this.droppedTorches.clear();
        AdPother.getInstance().torches.reloadConfigs();
        for (DroppedTorch torch : savedTorches) {
            ItemEntity entity = (ItemEntity)torch.getEntity();
            if (this.world != entity.func_130014_f_() || !(this.world instanceof ServerWorld)) continue;
            this.addIfDroppedTorch((ServerWorld)this.world, (Entity)entity);
        }
    }

    public void removeIfDroppedTorch(Entity entity) {
        if (entity instanceof ItemEntity) {
            this.droppedTorches.remove(entity);
        }
    }

    public void removePollutionInfoAt(ChunkLoc location) {
        this.pollutionForChunk.remove(location);
        if (CommonTime.Interval.passedFrom((CommonTime.Stamp)this.lastEmptyInfoCleanup).moreThan(CommonTime.Interval.minutes((double)3.0))) {
            this.lastEmptyInfoCleanup = CommonTime.Stamp.now();
            this.pollutionForChunk.values().removeIf(pollution -> pollution.isEmpty());
        }
    }

    public void removePollutionInfoFor(Entity entity) {
        this.pollutionForEntity.remove(entity);
    }

    public List<Pair<String, Integer>> getStats() {
        ArrayList<Pair<String, Integer>> stats = new ArrayList<Pair<String, Integer>>();
        stats.add(Pair.of((Object)"droppedTorches", (Object)this.droppedTorches.size()));
        stats.add(Pair.of((Object)"flyingEmissions", (Object)this.getPollutantCarrierLimiter().getQuantity()));
        stats.add(Pair.of((Object)"delayedTileEmissions", (Object)this.delayedTileEmissions.size()));
        stats.add(Pair.of((Object)"periodicEntityEmissions", (Object)this.periodicEntityEmissions.size()));
        stats.add(Pair.of((Object)"periodicTileEmissions", (Object)this.periodicTileEmissions.size()));
        stats.add(Pair.of((Object)"pollutionChunkEntries", (Object)this.pollutionForChunk.size()));
        stats.add(Pair.of((Object)"pollutionEntityEntries", (Object)this.pollutionForEntity.size()));
        if (this.world.func_205220_G_() instanceof ServerTickList) {
            stats.add((Pair<String, Integer>)Pair.of((Object)"scheduledBlockUpdates", (Object)((ServerTickList)this.world.func_205220_G_()).func_225420_a()));
        }
        if (this.world.func_205219_F_() instanceof ServerTickList) {
            stats.add((Pair<String, Integer>)Pair.of((Object)"scheduledFluidUpdates", (Object)((ServerTickList)this.world.func_205219_F_()).func_225420_a()));
        }
        return stats;
    }
}

