/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.renderers;

import com.endertech.common.CachedValue;
import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.data.GamePath;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.mods.adpother.blocks.Sulfur;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public final class AcidRain {
    public static final ResourceLocation TEXTURE = GamePath.environmentTexture((ResourceLocation)new ResourceLocation((String)"adpother", (String)"acid_rain"), (String[])new String[0]).location;
    static final CachedValue<Boolean> ACID_RAIN = CachedValue.of(() -> {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Sulfur sulfur = (Sulfur)Pollutants.BuiltIn.SULFUR.get();
        EntityPollution pollution = WorldData.getEntityPollution((Entity)player);
        BiomeId biome = BiomeId.from((IWorld)player.func_130014_f_(), (BlockPos)player.func_233580_cy_());
        float threshold = sulfur.getAcidRainThresholdIn(biome);
        Percentage influence = pollution.getInfluenceOf(sulfur);
        return influence.getValue() >= threshold;
    }, (CommonTime.Interval)GameTime.second().getInterval());

    static boolean isAcidRain() {
        return (Boolean)ACID_RAIN.get();
    }

    public static final void onVanillaTextureBinding() {
        if (AcidRain.isAcidRain()) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        }
    }
}

