/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.renderers;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.client.renderer.GlassMeterRenderer;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.items.Aerometer;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AerometerRenderer
extends GlassMeterRenderer {
    static final ColorARGB COLOR_RED = ColorARGB.from((Color)Color.RED);

    protected void renderIndicators(ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer) {
        if (ForgeItem.isBroken((ItemStack)stack)) {
            return;
        }
        Optional<Entity> carrier = Aerometer.getCarrierFor(stack);
        if (!carrier.isPresent()) {
            return;
        }
        EntityPollution pollution = WorldData.getEntityPollution(carrier.get());
        IVertexBuilder builder = buffer.getBuffer(RENDER_TYPE);
        double needleOffset = 0.001;
        double offset = 0.001;
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 0.5, 0.5);
        matrix.func_227861_a_(0.0, 0.0, (double)-0.04f);
        matrix.func_227861_a_(0.0, 0.0, offset);
        for (Pollutant pollutant : pollution.getPollutants().collect(Collectors.toList())) {
            float factor = pollution.getInfluenceOf(pollutant).toFraction();
            ColorARGB color = pollutant.getColor();
            matrix.func_227861_a_(0.0, 0.0, offset);
            this.renderNeedle(builder, matrix, color, factor);
            matrix.func_227861_a_(0.0, 0.0, -offset);
            offset += 0.001;
        }
        if (pollution.hasExplosionRisk()) {
            this.renderExplosionRiskIndicator(builder, matrix, COLOR_RED);
        }
        matrix.func_227865_b_();
    }

    protected void renderExplosionRiskIndicator(IVertexBuilder builder, MatrixStack matrix, ColorARGB color) {
        float size = 0.3f;
        AerometerRenderer.addVertex((IVertexBuilder)builder, (MatrixStack)matrix, (ColorARGB)color, (float)0.0f, (float)0.3f, (float)0.5f, (float)0.0f);
        AerometerRenderer.addVertex((IVertexBuilder)builder, (MatrixStack)matrix, (ColorARGB)color, (float)-0.3f, (float)0.15f, (float)0.0f, (float)1.0f);
        AerometerRenderer.addVertex((IVertexBuilder)builder, (MatrixStack)matrix, (ColorARGB)color, (float)0.3f, (float)0.15f, (float)1.0f, (float)1.0f);
        AerometerRenderer.addVertex((IVertexBuilder)builder, (MatrixStack)matrix, (ColorARGB)color, (float)0.3f, (float)0.15f, (float)1.0f, (float)1.0f);
    }

    protected void renderNeedle(IVertexBuilder builder, MatrixStack matrix, ColorARGB color, float factor) {
        FloatBounds angle = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(180.0f));
        float degrees = angle.approxDown(factor).floatValue() - 90.0f;
        matrix.func_227860_a_();
        matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(degrees));
        float sW = 0.05f;
        float sL = 0.35f;
        AerometerRenderer.addVertex((IVertexBuilder)builder, (MatrixStack)matrix, (ColorARGB)color, (float)-0.05f, (float)-0.07f, (float)0.0f, (float)0.0f);
        AerometerRenderer.addVertex((IVertexBuilder)builder, (MatrixStack)matrix, (ColorARGB)color, (float)0.05f, (float)-0.07f, (float)1.0f, (float)0.0f);
        AerometerRenderer.addVertex((IVertexBuilder)builder, (MatrixStack)matrix, (ColorARGB)color, (float)0.05f, (float)0.35f, (float)1.0f, (float)1.0f);
        AerometerRenderer.addVertex((IVertexBuilder)builder, (MatrixStack)matrix, (ColorARGB)color, (float)-0.05f, (float)0.35f, (float)0.0f, (float)1.0f);
        matrix.func_227865_b_();
    }
}

