/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.renderers;

import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public class GasRenderer
extends EntityRenderer<GasEntity> {
    public GasRenderer(EntityRendererManager manager) {
        super(manager);
        this.field_76989_e = 0.5f;
    }

    @Nullable
    public ResourceLocation getEntityTexture(GasEntity entity) {
        return AtlasTexture.field_110575_b;
    }

    public void render(GasEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        World world;
        BlockState state = entity.getCarriedBlockState().orElse(null);
        if (state == null) {
            return;
        }
        if (state.func_185901_i() == BlockRenderType.MODEL && state != (world = entity.func_130014_f_()).func_180495_p(entity.func_233580_cy_()) && state.func_185901_i() != BlockRenderType.INVISIBLE) {
            matrixStack.func_227860_a_();
            BlockPos blockpos = new BlockPos(entity.func_226277_ct_(), entity.func_174813_aQ().field_72337_e, entity.func_226281_cx_());
            float offset = 0.01f;
            matrixStack.func_227861_a_(-0.5 + (double)offset, 0.0 + (double)offset, -0.5 + (double)offset);
            float scale = 1.0f - 1.0f * offset * 1.01f;
            matrixStack.func_227862_a_(scale, scale, scale);
            BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
            RenderType type = RenderType.func_239269_g_();
            ForgeHooksClient.setRenderLayer((RenderType)type);
            dispatcher.func_175019_b().func_228802_a_((IBlockDisplayReader)world, dispatcher.func_184389_a(state), state, blockpos, matrixStack, buffer.getBuffer(type), false, new Random(), state.func_209533_a(entity.func_233580_cy_()), OverlayTexture.field_229196_a_);
            ForgeHooksClient.setRenderLayer(null);
            matrixStack.func_227865_b_();
            super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        }
    }
}

