/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.renderers;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class Smog {
    public static boolean renderSmog = true;
    public static boolean colorSmog = false;
    private static ColorARGB color;
    private static CommonTime.Stamp lastUpdate;
    private static CommonTime.Interval updateInterval;
    private static float currentDensity;
    private static float targetDensity;
    private static float minDensity;
    private static float minDensityToColorSmog;
    private static float changingStep;

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public static void onFogRender(EntityViewRenderEvent.RenderFogEvent event) {
        float delta;
        if (CommonTime.Interval.passedFrom((CommonTime.Stamp)lastUpdate).moreThan(updateInterval)) {
            Entity entity = event.getInfo().func_216773_g();
            EntityPollution pollution = WorldData.getEntityPollution(entity);
            Optional<Pollutant<?>> dominant = pollution.getDominantPollutant(pollutant -> true);
            if (dominant.isPresent()) {
                float factor = pollution.getInfluenceOf(dominant.get()).toFraction();
                targetDensity = GameBounds.FOG_DENSITY.getFloatBounds().approxUp(factor).floatValue();
            } else {
                color = null;
                targetDensity = 0.0f;
            }
            lastUpdate = CommonTime.Stamp.now();
        }
        currentDensity = Math.abs(delta = targetDensity - currentDensity) >= Math.abs(changingStep) ? (currentDensity += changingStep * Math.signum(delta)) : targetDensity;
        if (renderSmog && Smog.enoughDensity()) {
            RenderSystem.fogDensity((float)currentDensity);
            RenderSystem.fogStart((float)0.0f);
            RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            RenderSystem.setupNvFogDistance();
        }
    }

    @SubscribeEvent
    public static void onFogColors(EntityViewRenderEvent.FogColors event) {
        if (renderSmog && colorSmog && color != null && currentDensity >= minDensityToColorSmog) {
            event.setRed(color.getRed().toFloat());
            event.setGreen(color.getGreen().toFloat());
            event.setBlue(color.getBlue().toFloat());
        }
    }

    static boolean enoughDensity() {
        return targetDensity >= minDensity;
    }

    static {
        lastUpdate = CommonTime.Stamp.now();
        updateInterval = GameTime.quaterSecond().getInterval();
        currentDensity = 0.0f;
        targetDensity = 0.0f;
        minDensity = 0.03f;
        minDensityToColorSmog = 0.05f;
        changingStep = 3.0E-5f;
    }
}

