/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.sources;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.mods.adpother.emissions.AbstractEntityEmission;
import com.endertech.minecraft.mods.adpother.pollution.GasExplosion;
import com.endertech.minecraft.mods.adpother.sources.Torch;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public class DroppedTorch
extends AbstractEntityEmission<ItemEntity, Torch> {
    public static float rate = 1.0f;
    protected final CommonTime.Stamp creationTime = CommonTime.Stamp.now();
    protected final CommonTime.Interval lifeSpan;

    protected DroppedTorch(ItemEntity entity, Torch emitter, GameTime updateInterval, CommonTime.Interval lifeSpan) {
        super(entity, emitter, updateInterval);
        this.lifeSpan = lifeSpan;
    }

    public static DroppedTorch of(ItemEntity entity, Torch torch) {
        return new DroppedTorch(entity, torch, GameTime.second(), CommonTime.Interval.minutes((double)5.0));
    }

    public World getWorld() {
        return ((ItemEntity)this.entity).func_130014_f_();
    }

    public void onUpdate() {
        if (CommonTime.Interval.passedFrom((CommonTime.Stamp)this.creationTime).moreThan(this.lifeSpan)) {
            this.kill();
            return;
        }
        ItemEntity entity = (ItemEntity)this.getEntity();
        if (!entity.func_70089_S()) {
            this.kill();
            return;
        }
        World world = this.getWorld();
        BlockPos pos = ForgeEntity.getCenterPosition((Entity)entity).toBlockPos();
        if (world == null || !world.isAreaLoaded(pos, 1)) {
            this.kill();
            return;
        }
        if (GasExplosion.in(world).position(pos).tryExplode()) {
            this.kill();
            return;
        }
        if (((Torch)((Object)this.getEmitter())).isActive((INBTSerializable)entity)) {
            ((Torch)((Object)this.getEmitter())).emitAt(world, pos, rate);
        }
    }
}

