/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.sources;

import com.endertech.common.Args;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.RelatedUnit;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.emissions.Emission;
import com.endertech.minecraft.mods.adpother.emissions.Emissions;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.Pair;

public class SourceBase
extends RelatedUnit {
    protected final Map<Pollutant<?>, Float> emissionMap = new HashMap();
    private boolean enabled = true;

    public SourceBase(UnitConfig config, Properties<?> props) {
        super(config, props.id);
        if (config != null && !((String)props.comment.getKey()).isEmpty() && !((String)props.comment.getValue()).isEmpty()) {
            config.setCategoryComment((String)props.comment.getKey(), (String)props.comment.getValue());
        }
        for (Pollutant pollutant : AdPother.getInstance().pollutants.getAll()) {
            float amount = 0.0f;
            for (Emission emission : props.emissions.get()) {
                if (pollutant != emission.getPollutant()) continue;
                amount = emission.getAmount();
                break;
            }
            if ((amount = UnitConfig.getFloat((UnitConfig)config, (String)Emission.CATEGORY, (String)pollutant.getRegistryName().func_110623_a(), (float)amount, (FloatBounds)new FloatBounds(Float.valueOf(0.0f), Float.valueOf(16.0f)), (String)"")) == 0.0f) continue;
            this.emissionMap.put(pollutant, Float.valueOf(amount));
        }
        this.saveConfig();
    }

    public float getEmissionOf(Pollutant<?> pollutant) {
        return this.emissionMap.getOrDefault(pollutant, Float.valueOf(0.0f)).floatValue();
    }

    public Set<Pollutant<?>> getPollutants() {
        return Collections.unmodifiableSet(this.emissionMap.keySet());
    }

    public void emitAt(World world, BlockPos pos) {
        this.emitAt(world, pos, 1.0f);
    }

    public void emitAt(World world, BlockPos pos, float factor) {
        if (this.isEnabled() && world instanceof ServerWorld) {
            ChunkPollution pollution = WorldData.getChunkPollution(world, pos);
            pollution.increaseBy(this, factor, (ServerWorld)world, pos);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + Args.group((Object[])new Object[]{Args.get((String)"enabled", (Object)this.isEnabled()), Args.get((String)"id", (Object)this.getRelatedId()), Args.get((String)"emissionMap", this.emissionMap)});
    }

    public static class Properties<T extends Properties<T>>
    extends RelatedUnit.Properties<T> {
        public float factor = 1.0f;
        public Emissions emissions = Emissions.of();
        public Pair<String, String> comment = Pair.of((Object)"", (Object)"");

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public static Properties<?> with() {
            return new Properties<Properties>(Properties.class);
        }

        public T emissions(Emissions emissions) {
            this.emissions = emissions;
            return (T)((Object)((Properties)this.self));
        }

        public T comment(String category, String comment) {
            this.comment = Pair.of((Object)category, (Object)comment);
            return (T)((Object)((Properties)this.self));
        }

        public T factor(float factor) {
            this.factor = factor;
            return (T)((Object)((Properties)this.self));
        }

        public T carbon(float amount) {
            this.emissions.carbon(amount * this.factor);
            return (T)((Object)((Properties)this.self));
        }

        public T sulfur(float amount) {
            this.emissions.sulfur(amount * this.factor);
            return (T)((Object)((Properties)this.self));
        }

        public T dust(float amount) {
            this.emissions.dust(amount * this.factor);
            return (T)((Object)((Properties)this.self));
        }
    }
}

