/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.sources;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class SourceLiving<E extends LivingEntity>
extends SourceBase {
    public SourceLiving(UnitConfig config, SourceBase.Properties<?> props) {
        super(config, props);
    }

    public void emitFrom(E living, float factor) {
        float weight = ForgeEntity.getWeight(living, (boolean)false);
        float amount = factor * weight;
        if (CommonMath.isAlmostZero((double)amount)) {
            return;
        }
        this.emitAt(((LivingEntity)living).field_70170_p, this.getOutletPosition(living), amount);
    }

    public BlockPos getOutletPosition(E living) {
        Direction facing = living.func_174811_aO().func_176734_d();
        World world = ((LivingEntity)living).field_70170_p;
        BlockPos livingPos = living.func_233580_cy_();
        BlockPos behindPos = livingPos.func_177972_a(facing);
        if (GameWorld.isBlockLoaded((IWorldReader)world, (BlockPos)behindPos) && GameWorld.isAirBlock((IWorldReader)world, (BlockPos)behindPos)) {
            return behindPos;
        }
        return livingPos;
    }
}

