/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.entities;

import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.network.TileSharedDataMsg;
import com.endertech.minecraft.forge.world.GameWorld;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class ForgeTileEntity
extends TileEntity {
    public static <T extends TileEntity> TileEntityType.Builder<T> builder(Supplier<? extends T> factory, Collection<? extends Block> validBlocks) {
        return ForgeTileEntity.builder(factory, validBlocks.toArray(new Block[0]));
    }

    public static <T extends TileEntity> TileEntityType.Builder<T> builder(Supplier<? extends T> factory, Block ... validBlocks) {
        return TileEntityType.Builder.func_223042_a(factory, (Block[])validBlocks);
    }

    public ForgeTileEntity(TileEntityType<?> type) {
        super(type);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT compound = this.writeSharedData(new CompoundNBT());
        return compound.isEmpty() ? null : new SUpdateTileEntityPacket(this.func_174877_v(), 0, compound);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readSharedData(pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.readSharedData(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeSharedData(compound);
        return super.func_189515_b(compound);
    }

    public CompoundNBT getSharedData() {
        return this.writeSharedData(new CompoundNBT());
    }

    public void syncWithClients() {
        World world = this.func_145831_w();
        if (world != null && GameWorld.isServerSide((IWorldReader)world)) {
            TileSharedDataMsg message = new TileSharedDataMsg(this.getSharedData(), this.func_174877_v());
            ForgeEndertech.getInstance().getConnection().sendToAllObservingChunk(message, world.func_175726_f(this.field_174879_c));
            this.func_70296_d();
        }
    }

    public abstract void readSharedData(CompoundNBT var1);

    public abstract CompoundNBT writeSharedData(CompoundNBT var1);
}

