/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.events;

import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@Cancelable
public abstract class RandomTickEvent<T>
extends Event {
    private final ServerWorld world;
    private final BlockPos pos;
    private final T state;

    public RandomTickEvent(ServerWorld world, BlockPos pos, T state) {
        this.world = world;
        this.pos = pos;
        this.state = state;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public T getState() {
        return this.state;
    }

    public static final boolean onRandomTickBlock(ServerWorld world, BlockPos pos, BlockState state) {
        return MinecraftForge.EVENT_BUS.post((Event)new Block(world, pos, state));
    }

    public static final boolean onRandomTickFluid(World world, BlockPos pos, FluidState state) {
        return world instanceof ServerWorld ? MinecraftForge.EVENT_BUS.post((Event)new Fluid((ServerWorld)world, pos, state)) : false;
    }

    @Cancelable
    public static class Fluid
    extends RandomTickEvent<FluidState> {
        public Fluid(ServerWorld world, BlockPos pos, FluidState state) {
            super(world, pos, state);
        }
    }

    @Cancelable
    public static class Block
    extends RandomTickEvent<BlockState> {
        public Block(ServerWorld world, BlockPos pos, BlockState state) {
            super(world, pos, state);
        }
    }
}

