/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.common.CommonPath;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.units.UnitsInit;
import java.nio.file.Path;

public abstract class UnitsInitWithEnum<T, E extends Enum<?>>
extends UnitsInit<T> {
    protected final Class<E> builtInEnum;

    public UnitsInitWithEnum(ForgeMod mod, Class<E> builtInEnum) {
        super(mod);
        this.builtInEnum = builtInEnum;
        this.initDefaultConfigs();
        this.initCustomConfigs();
    }

    protected void initDefaultConfigs() {
        for (Enum enumValue : (Enum[])this.builtInEnum.getEnumConstants()) {
            UnitConfig config = UnitConfig.in(this.getConfigsDir(), ((IForgeEnum)((Object)enumValue)).getName());
            T unit = this.createDefaultUnitFrom(config, enumValue);
            this.add(unit);
            config.save();
        }
    }

    protected void initCustomConfigs() {
        for (Path path : UnitConfig.listCustomConfigs(this.getConfigsDir(), this.builtInEnum)) {
            UnitConfig config = new UnitConfig(path.toFile());
            String name = CommonPath.getFileNameOnly(path);
            T unit = this.createCustomUnitFrom(config, name);
            this.add(unit);
            config.save();
        }
    }

    public void reloadConfigs() {
        this.removeAll();
        this.initDefaultConfigs();
        this.initCustomConfigs();
        this.onPostInit();
    }

    public abstract T createDefaultUnitFrom(UnitConfig var1, E var2);

    public abstract T createCustomUnitFrom(UnitConfig var1, String var2);
}

