function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var targetBlock = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/block/AbstractBlock$AbstractBlockState',
		'methodName' : resolveName('func_227034_b_'), // randomTick
		'methodDesc' : '(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;)V'
	}

	var handlerBlock = {
		'class' : 'com/endertech/minecraft/forge/events/RandomTickEvent',
		'methodName' : 'onRandomTickBlock',
		'methodDesc' : '(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)Z'
	}

	var getBlockState = {
		'class' : 'net/minecraft/block/AbstractBlock$AbstractBlockState',
		'methodName' : resolveName('func_230340_p_'), // getSelf
		'methodDesc' : '()Lnet/minecraft/block/BlockState;'
	}

	var targetFluid = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/fluid/FluidState',
		'methodName' : resolveName('func_206891_b'), // randomTick
		'methodDesc' : '(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;)V'
	}

	var handlerFluid = {
		'class' : 'com/endertech/minecraft/forge/events/RandomTickEvent',
		'methodName' : 'onRandomTickFluid',
		'methodDesc' : '(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/fluid/FluidState;)Z'
	}
	
	var instructions = [ 
		insnLoadObj(1, "world"), 
		insnLoadObj(2, "pos"),
		insnLoadObj(0, "state")
	];

	return {
		'randomTickBlock' : {
			'target' : targetBlock,
			'transformer' : function(method) {
				insertInstructionsBeforeAll(method, instructions.concat(insnInvokeVirtual(getBlockState), insnCallHandler(handlerBlock), instructionsIfTrueReturn()));
				return method;
			}
		},
		'randomTickFluid' : {
			'target' : targetFluid,
			'transformer' : function(method) {
				insertInstructionsBeforeAll(method, instructions.concat(insnCallHandler(handlerFluid), instructionsIfTrueReturn()));
				return method;
			}
		}
	}
}