function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'blusunrize/immersiveengineering/common/blocks/stone/AlloySmelterTileEntity',
		'methodName' : resolveName('func_73660_a'), // tick
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'net/minecraft/item/ItemStack',
		'methodName' : resolveName('func_190918_g'), // shrink
		'methodDesc' : '(I)V'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/minecraft/item/ItemStack;ILnet/minecraft/tileentity/TileEntity;)V'
	}

	var instructions = [ 
		insnDup2("dup fuel stack and shrink count"),
		insnLoadThis("alloy smelter tile"), 
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructions(method, node, instructions, true);
				return method;
			}
		}
	}
}