function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'blusunrize/immersiveengineering/common/blocks/stone/BlastFurnaceTileEntity',
		'methodName' : resolveName('func_73660_a'), // tick
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'blusunrize/immersiveengineering/api/crafting/BlastFurnaceFuel',
		'methodName' : resolveName('getBlastFuelTime'), // getBlastFuelTime
		'methodDesc' : '(Lnet/minecraft/item/ItemStack;)I'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/minecraft/item/ItemStack;ILnet/minecraft/tileentity/TileEntity;)V'
	}

	var instructions = [ 
		insnDup("dup fuel stack"),
		insnPushValue(1, "set fuel amount"),
		insnLoadThis("blast furnace tile"), 
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructions(method, node, instructions, true);
				return method;
			}
		}
	}
}