function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'blusunrize/immersiveengineering/common/blocks/stone/CokeOvenTileEntity',
		'methodName' : resolveName('func_73660_a'), // tick
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'blusunrize/immersiveengineering/common/util/Utils',
		'methodName' : 'modifyInvStackSize',
		'methodDesc' : '(Lnet/minecraft/util/NonNullList;II)V'
	}
	
	var inventory = {
		'class' : 'blusunrize/immersiveengineering/common/blocks/stone/CokeOvenTileEntity',
		'fieldName' : 'inventory',
		'fieldDesc' : 'Lnet/minecraft/util/NonNullList;'
	}

	var listGet = {
		'class' : 'net/minecraft/util/NonNullList',
		'methodName' : resolveName('get'), // get
		'methodDesc' : '(I)Ljava/lang/Object;'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/minecraft/item/ItemStack;ILnet/minecraft/tileentity/TileEntity;)V'
	}

	var instructions = [
		insnLoadThis("tile"),
		insnGetField(inventory),
		insnPushInt(0, "INPUT_SLOT"),
		insnInvokeVirtual(listGet),
		insnCheckCast("net/minecraft/item/ItemStack"),
		insnPushValue(1, "set fuel amount"),
		insnLoadThis("coke oven tile"), 
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructions(method, node, instructions, true);
				return method;
			}
		}
	}
}