function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'mekanism/common/tile/machine/TileEntityFuelwoodHeater',
		'methodName' : 'onUpdateServer',
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'mekanism/common/inventory/slot/FuelInventorySlot',
		'methodName' : 'burn',
		'methodDesc' : '()I'
	}
	
	var fuelSlot = {
		'class' : 'mekanism/common/tile/machine/TileEntityFuelwoodHeater',
		'fieldName' : 'fuelSlot',
		'fieldDesc' : 'Lmekanism/common/inventory/slot/FuelInventorySlot;'
	}
	
	var getFuelStack = {
		'class' : 'mekanism/common/inventory/slot/FuelInventorySlot',
		'methodName' : 'getStack',
		'methodDesc' : '()Lnet/minecraft/item/ItemStack;'
	}
	
	var copyStack = {
		'class' : 'net/minecraft/item/ItemStack',
		'methodName' : 'getStack', // copy
		'methodDesc' : '()Lnet/minecraft/item/ItemStack;'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/minecraft/item/ItemStack;ILnet/minecraft/tileentity/TileEntity;)V'
	}

	var labelSkip = newLabel();
	var labelEnd = newLabel();

	var instructionsA = [
		insnDup("fuelSlot"),
		insnInvokeVirtual(getFuelStack),
		insnInvokeVirtual(copyStack),
		insnSwap("fuelSlot with fuelStack")
	];
	
	var instructionsB = [ 
		insnDup("dup burnTime"),
		insnIfLE_JumpTo(labelSkip),
		insnSwap("burnTime with saved fuelStack copy"),
		insnPushInt(1, "fuel amount"),
		insnLoadThis("fuelwood generator tile"), 
		insnCallHandler(handler),
		insnJumpTo(labelEnd),
		labelSkip,
		insnSwap("burnTime with saved fuelStack copy"),
		insnPop("remove fuelStack"),
		labelEnd
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructions(method, node, instructionsA, true);
				insertInstructions(method, node, instructionsB, false);
				return method;
			}
		}
	}
}