function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/tileentity/AbstractFurnaceTileEntity',
		'methodName' : resolveName('func_73660_a'), // tick   
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'net/minecraft/item/ItemStack',
		'methodName' : resolveName('func_190918_g'), // shrink 
		'methodDesc' : '(I)V'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFurnaceFuelBurned',
		'methodDesc' : '(Lnet/minecraft/tileentity/TileEntity;Lnet/minecraft/item/ItemStack;)V'
	}

	var instructions = [ 
		insnLoadObj(0, "furnace_tile"), 
		insnLoadObj(3, "fuel_stack"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructions(method, node, instructions, true);
				return method;
			}
		}
	}
}