function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/entity/passive/AnimalEntity',
		'methodName' : resolveName('func_175505_a'), // consumeItemFromStack
		'methodDesc' : '(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/item/ItemStack;)V'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFoodConsumed',
		'methodDesc' : '(Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/passive/AnimalEntity;)V'
	}

	var instructions = [ 
		insnLoadObj(2, "food stack"),
		insnLoadThis("animal"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBeforeAll(method, instructions);
				return method;
			}
		}
	}
}