function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraftforge/common/extensions/IForgeBlockState',
		'methodName' : resolveName('catchFire'), // catchFire
		'methodDesc' : '(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/Direction;Lnet/minecraft/entity/LivingEntity;)V'
	}

	var getBlockState = {
		'class' : 'net/minecraftforge/common/extensions/IForgeBlockState',
		'methodName' : 'getBlockState',
		'methodDesc' : '()Lnet/minecraft/block/BlockState;'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onBlockBurned',
		'methodDesc' : '(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)V'
	}

	var instructions = [ 
		insnLoadObj(1, "world"), 
		insnLoadObj(2, "pos"),
		insnLoadThis("IForgeBlockState"), insnInvokeInterface(getBlockState), 
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBeforeAll(method, instructions);
				return method;
			}
		}
	}
}