function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/client/renderer/WorldRenderer',
		'methodName' : resolveName('func_228438_a_'), // renderRainSnow
		'methodDesc' : '(Lnet/minecraft/client/renderer/LightTexture;FDDD)V'
	}

	var node = {
		'class' : 'net/minecraft/client/renderer/texture/TextureManager',
		'methodName' : resolveName('func_110577_a'), // bindTexture
		'methodDesc' : '(Lnet/minecraft/util/ResourceLocation;)V'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/renderers/AcidRain',
		'methodName' : 'onVanillaTextureBinding',
		'methodDesc' : '()V'
	}

	var instructions = [ 
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructions(method, node, instructions, false);
				return method;
			}
		}
	}
}