/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.mods.adpother.Command;
import com.endertech.minecraft.mods.adpother.Config;
import com.endertech.minecraft.mods.adpother.blocks.Filter;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.PollutantFreeAir;
import com.endertech.minecraft.mods.adpother.init.Armors;
import com.endertech.minecraft.mods.adpother.init.Blocks;
import com.endertech.minecraft.mods.adpother.init.Breakables;
import com.endertech.minecraft.mods.adpother.init.Emitters;
import com.endertech.minecraft.mods.adpother.init.Fluids;
import com.endertech.minecraft.mods.adpother.init.Fuels;
import com.endertech.minecraft.mods.adpother.init.Items;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import com.endertech.minecraft.mods.adpother.init.Respirators;
import com.endertech.minecraft.mods.adpother.init.Sources;
import com.endertech.minecraft.mods.adpother.init.Torches;
import com.endertech.minecraft.mods.adpother.items.VacuumTube;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.renders.FilterRender;
import com.endertech.minecraft.mods.adpother.renders.PollutantFreeAirRender;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="adpother", name="Pollution of the Realms", version="1.12.2-1.2.13.0", guiFactory="com.endertech.minecraft.mods.adpother.Config$Factory", acceptedMinecraftVersions="[1.12.2]", dependencies="required-after:forgeendertech@[1.12.2-4.5.5.0,)")
public class Main
extends ForgeMod {
    public static final String ID = "adpother";
    public static final String NAME = "Pollution of the Realms";
    public static final String GUI_FACTORY = "com.endertech.minecraft.mods.adpother.Config$Factory";
    @Mod.Instance(value="adpother")
    public static Main instance;
    private static Armors armors;
    private static Blocks blocks;
    private static Emitters emitters;
    private static Fluids fluids;
    private static Fuels fuels;
    private static Items items;
    private static Pollutants pollutants;
    private static Respirators respirators;
    private static Sources sources;
    private static Torches torches;
    private static Breakables breakables;

    public String getId() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    public ForgeMod getInstance() {
        return instance;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        this.setConfig(new Config(ID, event));
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
        this.getRegistrator().registerNetMessageHandledOnServer(VacuumTube.ExhaustMsg.class, VacuumTube.ExhaustMsg.Handler.class);
        this.getRegistrator().registerNetMessageHandledOnClient(EntityPollution.NetMsg.class, EntityPollution.NetMsg.Handler.class);
        this.getRegistrator().registerTileEntity(Filter.BlockTile.class, "filter");
        this.getRegistrator().registerEntity(PollutantFreeAir.class, 64, 20, false);
        new Filter.GuiHandler(this);
        armors = new Armors(this);
        blocks = new Blocks(this);
        items = new Items(this);
        pollutants = new Pollutants(this);
        emitters = new Emitters(this);
        fuels = new Fuels(this);
        fluids = new Fluids(this);
        sources = new Sources(this);
        respirators = new Respirators(this);
        torches = new Torches(this);
        breakables = new Breakables(this);
        WorldData.initBiomeConfigs();
        super.preInit(event);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        ClientRegistry.bindTileEntitySpecialRenderer(Filter.BlockTile.class, (TileEntitySpecialRenderer)new FilterRender());
        this.getRegistrator().registerRenderingHandler(PollutantFreeAir.class, PollutantFreeAirRender::new);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        this.getConfig().init();
        super.init(event);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        super.initClient(event);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new Command());
        Pollutant.globalImmuneEntities.loadData();
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
    }

    public void onMissingMappings(RegistryEvent.MissingMappings<Item> event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        super.postInit(event);
    }

    public static Armors getArmors() {
        return armors;
    }

    public static Blocks getBlocks() {
        return blocks;
    }

    public static Pollutants getPollutants() {
        return pollutants;
    }

    public static Items getItems() {
        return items;
    }

    public static Emitters getEmitters() {
        return emitters;
    }

    public static Fluids getFluids() {
        return fluids;
    }

    public static Fuels getFuels() {
        return fuels;
    }

    public static Sources getSources() {
        return sources;
    }

    public static Respirators getRespirators() {
        return respirators;
    }

    public static Torches getTorches() {
        return torches;
    }

    public static Breakables getBreakables() {
        return breakables;
    }

    static {
        FluidRegistry.enableUniversalBucket();
    }
}

