/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeGui;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.api.ISmokeContainer;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.ForgeEnergyStorage;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.data.TileInventory;
import com.endertech.minecraft.forge.items.ForgeBlockItem;
import com.endertech.minecraft.forge.math.AABB;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.ForgeTileEntity;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adpother.Main;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.blocks.PollutedWater;
import com.endertech.minecraft.mods.adpother.entities.PollutantFreeAir;
import com.endertech.minecraft.mods.adpother.init.Fluids;
import com.endertech.minecraft.mods.adpother.init.Materials;
import com.endertech.minecraft.mods.adpother.pollution.IFilter;
import com.endertech.minecraft.mods.adpother.pollution.IPurifier;
import com.endertech.minecraft.mods.adpother.pollution.IStorage;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class Filter
extends ForgeBlock
implements IFilter<BlockTile>,
ISmokeContainer {
    public static final PropertyEnum<Saturation> SATURATION = Filter.createPropertyEnum(Saturation.class);
    static final float THICKNESS = 0.125f;
    static final AxisAlignedBB AABB_CORE = AABB.BLOCK.func_186664_h(0.25);
    static final List<AxisAlignedBB> AABB_WALLS = AABB.getWalls((float)0.125f);
    protected final int slotLimit;
    protected final ForgeEnergyStorage.Properties energyProps;
    protected final AirPurifier airPurifier;
    protected final WaterPurifier waterPurifier;

    public Filter(ForgeMod mod, UnitConfig config, Materials material) {
        this(mod, config, material.func_176610_l(), material.multiplier);
        this.addCraftingRecipe("212 101 212", 1, new String[]{"paneGlass", material.getDictName()});
    }

    public Filter(ForgeMod mod, UnitConfig config, String name, int multiplier) {
        super(mod, config, name, Material.field_151592_s, CreativeTabs.field_78030_b);
        multiplier = IntBounds.from((Integer)1, (Integer)4).enclose(Integer.valueOf(multiplier));
        this.slotLimit = 16 * multiplier;
        this.energyProps = new ForgeEnergyStorage.Properties(config, this.getUnitCategory(), false, this.slotLimit * 100, 50);
        this.airPurifier = new AirPurifier(config, this.getUnitCategory(), 1, 8 * multiplier);
        this.waterPurifier = new WaterPurifier(config, this.getUnitCategory(), 1 + 2 * multiplier, Percentage.value((float)(12 * multiplier)));
        this.func_149711_c(1.5f);
        this.setResistance(30.0f);
        this.func_149713_g(16);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SATURATION, (Comparable)((Object)Saturation.NORMAL)));
        this.setUnitVariants(Saturation.class);
        this.func_149675_a(true);
    }

    public AirPurifier getAirPurifier() {
        return this.airPurifier;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean isActualState) {
        if (this.hasFilterMaterialInstalled((IBlockAccess)world, pos)) {
            Filter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_CORE);
        }
        for (AxisAlignedBB aabb : AABB_WALLS) {
            Filter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)aabb);
        }
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return !this.hasFilterMaterialInstalled(world, pos);
    }

    public boolean hasFilterMaterialInstalled(IBlockAccess world, BlockPos pos) {
        BlockTile tile = this.getBlockTile(world, pos);
        return tile != null && !tile.getFilterMaterial().func_190926_b();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BlockTile();
    }

    public ItemBlock createBlockItem() {
        return new BlockItem(this);
    }

    @Override
    public int fill(BlockTile storage, Pollutant<?> pollutant, int amount) {
        if (amount <= 0) {
            return 0;
        }
        if (!storage.isActive()) {
            return 0;
        }
        IStorage.Content content = this.getContent(storage);
        ItemStack filterMaterial = storage.getFilterMaterial();
        int fullnessOld = content.getFullnessWith(pollutant);
        int count = content.fillWith(pollutant, amount);
        int fullnessNew = content.getFullnessWith(pollutant);
        int materialCapacity = pollutant.getFilterMaterials().getCapacityFor(filterMaterial);
        int materialUsed = materialCapacity != 0 ? fullnessNew / materialCapacity - fullnessOld / materialCapacity : 0;
        int energyUsed = this.energyProps.consumption * count;
        storage.energyStorage.extractEnergy(energyUsed, false);
        TileInventory inventory = storage.getTileInventory();
        inventory.extractItem(0, materialUsed, false);
        ItemStack byproduct = pollutant.getFilterMaterials().getByproductFor(filterMaterial, materialUsed);
        inventory.insertItem(1, byproduct, false);
        this._handleChanges(content, (Object)storage);
        return count;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        BlockTile tile = this.getBlockTile((IBlockAccess)world, pos);
        if (ForgeWorld.isServerSide((World)world) && tile != null) {
            int capacity = tile.getEnergyProps().capacity;
            tile.energyStorage = ForgeEnergyStorage.of((int)capacity);
            tile.syncWithClients();
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        BlockTile tile = this.getBlockTile(world, pos);
        if (tile == null) {
            return;
        }
        drops.add((Object)tile.getFilterMaterial());
        drops.add((Object)tile.getByproduct());
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return this.isSideSolid(state, world, pos, facing) ? BlockFaceShape.SOLID : BlockFaceShape.BOWL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 0;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.hasFilterMaterialInstalled(world, pos) ? 2 : 1;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        switch (side) {
            case DOWN: 
            case UP: {
                return false;
            }
        }
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    @Override
    public IStorage.Content getContent(BlockTile tile) {
        return tile.content;
    }

    @Override
    public void onContentChanged(IStorage.Content content, BlockTile tile) {
        World world = tile.func_145831_w();
        if (this.isServerSide(world)) {
            world.func_175684_a(tile.func_174877_v(), (Block)this, 1);
        }
    }

    @Nullable
    public BlockTile getBlockTile(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof BlockTile ? (BlockTile)te : null;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SATURATION});
    }

    public int func_176201_c(IBlockState state) {
        return ((Saturation)((Object)state.func_177229_b(SATURATION))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SATURATION, (Comparable)((Object)Saturation.values()[meta]));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        BlockTile storage = this.getBlockTile((IBlockAccess)world, pos);
        if (storage == null) {
            return;
        }
        IStorage.Content content = this.getContent(storage);
        ItemStack filterMaterial = storage.getFilterMaterial();
        List<Pollutant<?>> targetPollutants = storage.getTargetPollutants();
        for (Pollutant<?> pollutant : targetPollutants) {
            ItemStack byproduct;
            int capacity = this.getInitialCapacity(storage);
            int materialCapacity = pollutant.getFilterMaterials().getCapacityFor(filterMaterial);
            int fullness = Math.max(storage.partialFullness, content.getFullnessWith(pollutant));
            if (materialCapacity != 0) {
                storage.partialFullness = fullness %= materialCapacity;
            }
            if ((byproduct = storage.getByproduct()).func_77969_a(pollutant.getFilterMaterials().getByproductFor(filterMaterial, 1))) {
                fullness += materialCapacity * byproduct.func_190916_E();
            } else if (!byproduct.func_190926_b()) {
                fullness = capacity;
            }
            content.installFiltersFor(capacity, pollutant);
            content.setFullnessWith(pollutant, fullness);
        }
        Main.getPollutants().getAll().forEach(p -> {
            if (!targetPollutants.contains(p)) {
                content.removeFiltersFor((Pollutant<?>)((Object)p));
            }
        });
        storage.getTileInventory().setStackInSlot(2, new ItemStack((Block)CommonCollect.getRandomElementFrom(targetPollutants)));
        this.dropByProductToBottomHopper(storage.getTileInventory());
        this.updateBlockState(world, pos, state, content.getHighestFullnessPercentage());
        ForgeWorld.Position.getAroundCube((BlockPos)pos.func_177977_b()).forEach(p -> world.func_175685_c(p, (Block)this, false));
        storage.renderMaterial = storage.getFilterMaterial();
        storage.isActive();
        content.changed = false;
        storage.syncWithClients();
    }

    protected boolean dropByProductToBottomHopper(TileInventory tileInventory) {
        ItemStack extractItem;
        World world = tileInventory.tile.func_145831_w();
        IHopper hopper = this.findBottomHopper(world, tileInventory.tile.func_174877_v());
        if (hopper != null && !(extractItem = tileInventory.extractItem(1, 1, true)).func_190926_b()) {
            for (int j = 0; j < hopper.func_70302_i_(); ++j) {
                ItemStack destStack = hopper.func_70301_a(j);
                if (!hopper.func_94041_b(j, extractItem) || !destStack.func_190926_b() && (destStack.func_190916_E() >= destStack.func_77976_d() || destStack.func_190916_E() >= hopper.func_70297_j_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)extractItem, (ItemStack)destStack))) continue;
                extractItem = tileInventory.extractItem(1, 1, false);
                if (destStack.func_190926_b()) {
                    hopper.func_70299_a(j, extractItem);
                } else {
                    destStack.func_190917_f(1);
                    hopper.func_70299_a(j, destStack);
                }
                hopper.func_70296_d();
                return true;
            }
        }
        return false;
    }

    private boolean isChimneyOrPump(World world, BlockPos pos) {
        return ForgeWorld.SmokeContainers.isChimney((World)world, (BlockPos)pos) || ForgeWorld.SmokeContainers.isPump((World)world, (BlockPos)pos);
    }

    @Nullable
    protected IHopper findBottomHopper(World world, BlockPos startPos) {
        BlockPos pos = ForgeWorld.Position.getLastInLine((World)world, (BlockPos)startPos, this::isChimneyOrPump, (EnumFacing)EnumFacing.DOWN).func_177977_b();
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof IHopper ? (IHopper)tile : null;
    }

    protected void updateBlockState(World world, BlockPos pos, IBlockState state, Percentage fullness) {
        IBlockState newState = this.func_176223_P();
        if (fullness.getGrade() == Percentage.Grade.HIGH) {
            newState = this.func_176223_P().func_177226_a(SATURATION, (Comparable)((Object)Saturation.HIGH));
        }
        if (state != newState) {
            world.func_175656_a(pos, newState);
        }
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        BlockTile tile = this.getBlockTile(blockAccess, pos);
        if (tile != null && !tile.getFilterMaterial().func_190926_b()) {
            Percentage percentage = this.getContent(tile).getHighestFullnessPercentage();
            float factor = percentage.toFraction();
            int power = ForgeBounds.REDSTONE_POWER.getIntBounds().approxDown(factor);
            return power;
        }
        return 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @Override
    public int getInitialCapacity(BlockTile storage) {
        int capacity = 0;
        ItemStack filterMaterial = storage.getFilterMaterial();
        for (Pollutant<?> pollutant : storage.getTargetPollutants()) {
            int materialCapacity = pollutant.getFilterMaterials().getCapacityFor(filterMaterial);
            capacity = Math.max(capacity, materialCapacity * storage.getTileInventory().getSlotLimit(0));
        }
        return capacity;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        GuiHandler.openContainerFor((ForgeMod)Main.instance, (World)world, (BlockPos)pos, (EntityPlayer)player);
        return true;
    }

    public UnitId getRelatedId() {
        return this.getId();
    }

    public ColorARGB getColor() {
        return ColorARGB.DEFAULT;
    }

    public boolean isChimney(IBlockState state) {
        return true;
    }

    public boolean isVent(IBlockState state) {
        return false;
    }

    public boolean isPump(IBlockState state) {
        return false;
    }

    public boolean isActive(World world, BlockPos pos) {
        BlockTile tile = this.getBlockTile((IBlockAccess)world, pos);
        return tile != null ? tile.isActive() : false;
    }

    static class PollutantSlot
    extends TileInventory.ItemSlot {
        public static final int INDEX = 2;

        public PollutantSlot(TileInventory tileInventory, int xPosition, int yPosition) {
            super(tileInventory, 2, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public boolean func_82869_a(EntityPlayer player) {
            return false;
        }
    }

    static class ByproductSlot
    extends TileInventory.ItemSlot {
        public static final int INDEX = 1;

        public ByproductSlot(TileInventory tileInventory, int xPosition, int yPosition) {
            super(tileInventory, 1, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }
    }

    static class MaterialSlot
    extends TileInventory.ItemSlot {
        public static final int INDEX = 0;

        public MaterialSlot(TileInventory tileInventory, int xPosition, int yPosition) {
            super(tileInventory, 0, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return MaterialSlot.isItemValid(this.tileInventory, stack);
        }

        public static boolean isItemValid(TileInventory tileInventory, ItemStack stack) {
            if (tileInventory.tile instanceof BlockTile) {
                return ((BlockTile)tileInventory.tile).isValidFilterMaterial(stack);
            }
            return false;
        }
    }

    public static class GuiHandler
    extends TileInventory.GuiHandler {
        final ForgeGui.GuiTexture texture;

        public GuiHandler(ForgeMod mod) {
            super(mod);
            this.texture = new ForgeGui.GuiTexture(mod, "filter", 176, 166);
        }

        public boolean isValidTile(TileEntity tile) {
            return tile instanceof BlockTile;
        }

        public TileInventory.ServerContainer createServerContainer(World world, BlockPos pos, TileEntity tile, EntityPlayer player) {
            TileInventory tileInventory = ((BlockTile)tile).getTileInventory();
            TileInventory.ServerContainer container = new TileInventory.ServerContainer(tileInventory).addPlayerSlots(player.field_71071_by, 8, 84);
            container.addSlot((TileInventory.ItemSlot)new MaterialSlot(tileInventory, 56, 17));
            container.addSlot((TileInventory.ItemSlot)new ByproductSlot(tileInventory, 116, 35));
            container.addSlot((TileInventory.ItemSlot)new PollutantSlot(tileInventory, 56, 53));
            return container;
        }

        @SideOnly(value=Side.CLIENT)
        public GuiContainer createClientContainer(World world, BlockPos pos, TileEntity tile, EntityPlayer player) {
            TileInventory.ServerContainer container = this.createServerContainer(world, pos, tile, player);
            return new TileInventory.ClientContainer(container, this.texture){

                protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
                    super.func_146976_a(partialTicks, mouseX, mouseY);
                    TileEntity te = this.serverContainer.tileInventory.tile;
                    if (te instanceof BlockTile && ((BlockTile)te).isActive()) {
                        this.func_73729_b(this.field_147003_i + 57, this.field_147009_r + 36, 176, 0, 14, 14);
                    }
                }
            };
        }
    }

    public static class WaterPurifier
    implements IPurifier {
        public static final CommonTime.Interval DEFAULT_UPDATE_INTERVAL = CommonTime.Interval.seconds((double)10.0);
        public static final int MAX_RADIUS = 16;
        public final int maximumRadius;
        public final Percentage efficiency;
        public CommonTime.Interval updateInterval;

        public WaterPurifier(UnitConfig config, String headCategory, int maximumRadius, Percentage efficiency) {
            this(config, headCategory, maximumRadius, efficiency, DEFAULT_UPDATE_INTERVAL);
        }

        public WaterPurifier(UnitConfig config, String headCategory, int maximumRadius, Percentage efficiency, CommonTime.Interval updateInterval) {
            String category = Names.dotted().join(new String[]{headCategory, "WaterPurifier"});
            this.maximumRadius = ForgeConfig.getInt((ForgeConfig)config, (String)category, (String)"maximumRadius", (int)maximumRadius, (IntBounds)IntBounds.from((Integer)0, (Integer)16), (String)"Defines the maximum cleaning radius of the purifier (in blocks).");
            this.efficiency = ForgeConfig.getPercentage((ForgeConfig)config, (String)category, (String)"efficiency", (Percentage)efficiency, (FloatBounds)ForgeBounds.PERCENTAGE.getFloatBounds(), (String)"Defines the efficiency of the purifier (in percent).\nThe lower the efficiency, the more filter material will be used up and the longer the cleaning process will take.");
            this.updateInterval = CommonTime.Interval.seconds((double)ForgeConfig.getInt((ForgeConfig)config, (String)category, (String)"updateInterval", (int)((int)updateInterval.inSeconds()), (IntBounds)IntBounds.from((Integer)1, (Integer)120), (String)"Defines the update interval (in seconds).\nThe smaller the interval, the higher the cleaning speed."));
        }

        @Override
        public BlockPos getOutputPos(World world, BlockPos filterPos) {
            return filterPos.func_177984_a();
        }

        @Override
        public BlockPos getPumpPos(World world, BlockPos filterPos) {
            return filterPos.func_177977_b();
        }

        @Override
        public boolean hasProperInput(World world, BlockPos pumpPos) {
            return ForgeWorld.Position.getAroundHoriz((BlockPos)pumpPos, (boolean)false, (BlockPos[])new BlockPos[0]).stream().anyMatch(pos -> world.func_180495_p(pos).func_185904_a() == Material.field_151586_h);
        }

        @Override
        public boolean hasProperOutput(World world, BlockPos outputPos) {
            return ForgeWorld.isAirBlock((World)world, (BlockPos)outputPos);
        }

        public Optional<BlockPos> findPollutedWater(World world, BlockPos filterPos, final List<Pollutant<?>> targetPollutants) {
            Fluids.WaterChain chain = new Fluids.WaterChain(world, this.getPumpPos(world, filterPos), this.maximumRadius){

                protected boolean onValidFound(BlockPos pos) {
                    return false;
                }

                protected boolean isValidBlock(BlockPos pos) {
                    return this.isWithinMaxRadius(pos) && PollutedWater.isSource(this.world, pos) && PollutedWater.findPollutant(this.world, pos, targetPollutants).isPresent();
                }
            };
            chain.build();
            return chain.getFound().stream().findFirst();
        }
    }

    public static class AirPurifier
    implements IPurifier {
        public static final int MAX_RADIUS = 32;
        public final int effectiveRadius;
        public final int maximumRadius;

        public AirPurifier(UnitConfig config, String headCategory, int effectiveRadius, int maximumRadius) {
            String category = Names.dotted().join(new String[]{headCategory, "AirPurifier"});
            this.effectiveRadius = ForgeConfig.getInt((ForgeConfig)config, (String)category, (String)"effectiveRadius", (int)effectiveRadius, (IntBounds)IntBounds.from((Integer)0, (Integer)32), (String)"Defines the radius of the area in which the purified air created by this purifier has the maximum effect");
            this.maximumRadius = ForgeConfig.getInt((ForgeConfig)config, (String)category, (String)"maximumRadius", (int)maximumRadius, (IntBounds)IntBounds.from((Integer)0, (Integer)32), (String)"Defines the maximum radius of the purified air effect.\nThe effect will fade between effectiveRadius and maxRadius");
        }

        @Override
        public BlockPos getOutputPos(World world, BlockPos filterPos) {
            while (ForgeWorld.SmokeContainers.isChimney((World)world, (BlockPos)(filterPos = filterPos.func_177984_a()))) {
            }
            return filterPos;
        }

        @Override
        public BlockPos getPumpPos(World world, BlockPos filterPos) {
            BlockPos pumpPos = filterPos;
            while (ForgeWorld.SmokeContainers.isChimney((World)world, (BlockPos)(pumpPos = pumpPos.func_177977_b()))) {
            }
            return pumpPos;
        }

        @Override
        public boolean hasProperInput(World world, BlockPos pumpPos) {
            return ForgeWorld.Position.getAroundHoriz((BlockPos)pumpPos, (boolean)false, (BlockPos[])new BlockPos[0]).stream().anyMatch(pos -> !world.func_180495_p(pos).func_185904_a().func_76224_d() && !world.func_180495_p(pos).func_185917_h() && !ForgeWorld.isHorizOpaque((World)world, (BlockPos)pos) || ForgeWorld.SmokeContainers.isVent((World)world, (BlockPos)pos));
        }

        @Override
        public boolean hasProperOutput(World world, BlockPos outputPos) {
            while (WorldData.altitudeBounds.encloses(Integer.valueOf(outputPos.func_177956_o()))) {
                if (ForgeWorld.isAirBlock((World)world, (BlockPos)outputPos)) {
                    return true;
                }
                if (world.func_180495_p(outputPos).func_185917_h()) {
                    return false;
                }
                if (ForgeWorld.isVerticalOpaque((World)world, (BlockPos)outputPos)) {
                    return false;
                }
                outputPos = outputPos.func_177984_a();
            }
            return false;
        }
    }

    public static class BlockItem
    extends ForgeBlockItem
    implements IStorageItem {
        public BlockItem(ForgeBlock block) {
            super(block);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
            this.addInformation(stack, world, tooltip);
            super.func_77624_a(stack, world, tooltip, flag);
        }

        @Override
        public int getInitialCapacity(ItemStack storage) {
            return 0;
        }
    }

    public static class BlockTile
    extends ForgeTileEntity.WithInventory
    implements ITickable {
        protected ItemStack renderMaterial = ItemStack.field_190927_a;
        protected boolean active = false;
        protected boolean purifyingAir = false;
        protected boolean purifyingWater = false;
        protected IStorage.Content content = new IStorage.Content(0);
        protected int partialFullness = 0;
        protected final TileInventory inventory = new Inventory((TileEntity)this, 3);
        protected final RangedWrapper input = new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 1){

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                if (MaterialSlot.isItemValid(inventory, stack)) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }
        };
        protected final RangedWrapper output = new RangedWrapper((IItemHandlerModifiable)this.inventory, 1, 2);
        protected ForgeEnergyStorage energyStorage = ForgeEnergyStorage.of((int)0);
        protected final GameTime airPurifierUpdateInterval = GameTime.second();
        protected GameTime waterPurifierUpdateInterval = null;

        public void func_73660_a() {
            if (ForgeWorld.isServerSide((World)this.func_145831_w())) {
                this.onServerTick();
            } else {
                this.onClientTick();
            }
        }

        protected void onServerTick() {
            IPurifier purifier;
            boolean needSync = false;
            if (this.airPurifierUpdateInterval.pastIn(this.field_145850_b)) {
                purifier = this.getAirPurifier().orElse(null);
                if (purifier != null && purifier.isActive(this.func_145831_w(), this.func_174877_v())) {
                    if (!this.purifyingAir) {
                        this.purifyingAir = true;
                        needSync = true;
                    }
                    BlockPos outputPos = ((AirPurifier)purifier).getOutputPos(this.func_145831_w(), this.func_174877_v());
                    List<PollutantFreeAir> entities = PollutantFreeAir.getAllAt(this.field_145850_b, outputPos);
                    for (Pollutant<?> pollutant : this.getTargetPollutants()) {
                        boolean exists = false;
                        for (PollutantFreeAir entity : entities) {
                            if (!entity.getPollutant().filter(p -> p == pollutant).isPresent()) continue;
                            exists = true;
                            break;
                        }
                        if (exists) continue;
                        this.field_145850_b.func_72838_d((Entity)new PollutantFreeAir(this.field_145850_b, outputPos, pollutant, this.func_174877_v()));
                    }
                } else if (this.purifyingAir) {
                    this.purifyingAir = false;
                    needSync = true;
                }
            }
            if (this.waterPurifierUpdateInterval == null) {
                this.waterPurifierUpdateInterval = GameTime.time((CommonTime.Interval)this.getFilter().map(filter -> filter.waterPurifier.updateInterval).orElse(WaterPurifier.DEFAULT_UPDATE_INTERVAL));
            }
            if (this.waterPurifierUpdateInterval.pastIn(this.field_145850_b)) {
                purifier = this.getWaterPurifier().orElse(null);
                if (purifier != null && purifier.isActive(this.func_145831_w(), this.func_174877_v())) {
                    Optional<BlockPos> waterPos;
                    boolean filled;
                    if (!this.purifyingWater) {
                        this.purifyingWater = true;
                        needSync = true;
                    }
                    Filter filter2 = this.getFilter().orElse(null);
                    List<Pollutant<?>> targetPollutants = this.getTargetPollutants();
                    if (filter2 != null && !targetPollutants.isEmpty() && (filled = (waterPos = ((WaterPurifier)purifier).findPollutedWater(this.field_145850_b, this.func_174877_v(), targetPollutants)).flatMap(pos -> PollutedWater.findPollutant(this.field_145850_b, pos, targetPollutants)).map(waterPollutant -> filter2.fill(this, (Pollutant<?>)((Object)waterPollutant), 1) > 0).orElse(false).booleanValue()) && ((WaterPurifier)purifier).efficiency.takeChance()) {
                        this.field_145850_b.func_175656_a(waterPos.get(), Blocks.field_150355_j.func_176223_P());
                    }
                } else if (this.purifyingWater) {
                    this.purifyingWater = false;
                    needSync = true;
                }
            }
            if (needSync) {
                this.syncWithClients();
            }
        }

        protected void onClientTick() {
            if (this.purifyingAir && GameTime.seconds((int)CommonMath.Random.between((int)1, (int)3)).pastIn(this.field_145850_b)) {
                this.getAirPurifier().ifPresent(purifier -> purifier.spawnParticle(this.field_145850_b, this.func_174877_v(), EnumParticleTypes.CLOUD));
            }
            if (this.purifyingWater && GameTime.seconds((float)0.5f).pastIn(this.field_145850_b)) {
                this.getWaterPurifier().ifPresent(purifier -> purifier.spawnParticle(this.field_145850_b, this.func_174877_v(), EnumParticleTypes.WATER_SPLASH));
            }
        }

        public TileInventory getTileInventory() {
            return this.inventory;
        }

        public ItemStack getFilterMaterial() {
            return this.getTileInventory().getStackInSlot(0);
        }

        public ItemStack getRenderMaterial() {
            return this.renderMaterial;
        }

        public ItemStack getByproduct() {
            return this.getTileInventory().getStackInSlot(1);
        }

        public boolean isValidFilterMaterial(ItemStack stack) {
            for (Pollutant pollutant : Main.getPollutants().getAll()) {
                if (!pollutant.getFilterMaterials().contains(stack)) continue;
                return true;
            }
            return false;
        }

        public boolean isActive() {
            if (ForgeWorld.isServerSide((World)this.func_145831_w())) {
                boolean newValue = false;
                ForgeEnergyStorage.Properties energy = this.getEnergyProps();
                if (this.content.hasFunctionalFilters() && (!energy.enabled || this.energyStorage.hasEnoughEnergy(energy.consumption))) {
                    for (Pollutant<?> pollutant : this.getTargetPollutants()) {
                        if (this.content.getFreeSpaceFor(pollutant) <= 0) continue;
                        newValue = true;
                    }
                }
                if (this.active != newValue) {
                    this.active = newValue;
                }
            }
            return this.active;
        }

        public List<Pollutant<?>> getTargetPollutants() {
            ItemStack material = this.getFilterMaterial();
            if (material.func_190926_b()) {
                return Collections.emptyList();
            }
            return Main.getPollutants().getAll().stream().filter(pollutant -> pollutant.getFilterMaterials().contains(material)).collect(Collectors.toList());
        }

        protected ForgeEnergyStorage.Properties getEnergyProps() {
            return this.getFilter().map(filter -> filter.energyProps).orElse(ForgeEnergyStorage.Properties.EMPTY);
        }

        protected Optional<AirPurifier> getAirPurifier() {
            return this.getFilter().map(filter -> filter.airPurifier);
        }

        protected Optional<WaterPurifier> getWaterPurifier() {
            return this.getFilter().map(filter -> filter.waterPurifier);
        }

        protected Optional<Filter> getFilter() {
            Block block = this.func_145838_q();
            return block instanceof Filter ? Optional.of((Filter)block) : Optional.empty();
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            if (capability == CapabilityEnergy.ENERGY && this.getEnergyProps().enabled) {
                return true;
            }
            return super.hasCapability(capability, facing);
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                RangedWrapper handler = facing == EnumFacing.DOWN ? this.output : this.input;
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)handler);
            }
            if (capability == CapabilityEnergy.ENERGY && this.getEnergyProps().enabled) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyStorage);
            }
            return (T)super.getCapability(capability, facing);
        }

        public void readSharedData(NBTTagCompound compound) {
            this.active = compound.func_74767_n("active");
            this.purifyingAir = compound.func_74767_n("purifyingAir");
            this.purifyingWater = compound.func_74767_n("purifyingWater");
            this.content.readFromNBT(compound);
            NBTTagCompound tag = compound.func_74775_l("renderMaterial");
            this.renderMaterial = new ItemStack(tag);
            this.energyStorage.readFromNBT(compound);
        }

        public void writeSharedData(NBTTagCompound compound) {
            compound.func_74757_a("active", this.active);
            compound.func_74757_a("purifyingAir", this.purifyingAir);
            compound.func_74757_a("purifyingWater", this.purifyingWater);
            this.content.writeToNBT(compound);
            NBTTagCompound tag = this.renderMaterial.serializeNBT();
            compound.func_74782_a("renderMaterial", (NBTBase)tag);
            this.energyStorage.writeToNBT(compound);
        }
    }

    public static class Inventory
    extends TileInventory {
        public Inventory(TileEntity tile, int size) {
            super(tile, size);
        }

        public int getSlotLimit(int slot) {
            Block block = this.tile.func_145838_q();
            return block instanceof Filter ? ((Filter)block).slotLimit : super.getSlotLimit(slot);
        }

        protected void onContentsChanged(int slot) {
            if (slot != 2) {
                this.tile.func_145831_w().func_175684_a(this.tile.func_174877_v(), this.tile.func_145838_q(), 1);
            }
            super.onContentsChanged(slot);
        }
    }

    public static enum Saturation implements IForgeEnum
    {
        NORMAL,
        HIGH;


        public String func_176610_l() {
            return this.getLowerCase(this.name());
        }
    }
}

