/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.common.CommonMath;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.api.IPollutant;
import com.endertech.minecraft.forge.api.ISmokeContainer;
import com.endertech.minecraft.forge.api.IWind;
import com.endertech.minecraft.forge.blocks.BlockState;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.MultiConfigProperty;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.ForgeBlockItem;
import com.endertech.minecraft.forge.math.AABB;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.forge.world.Wind;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.Main;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.EntityPollutant;
import com.endertech.minecraft.mods.adpother.init.Respirators;
import com.endertech.minecraft.mods.adpother.materials.MaterialGas;
import com.endertech.minecraft.mods.adpother.pollution.IFilter;
import com.endertech.minecraft.mods.adpother.pollution.IStorage;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import com.endertech.minecraft.mods.adpother.pollution.PollutionInfo;
import com.endertech.minecraft.mods.adpother.pollution.Spread;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockPane;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GasEmission
extends Pollutant<EntityPollutant> {
    public static GameTime spreadIntoWorldInterval = GameTime.seconds((int)3);
    private final MultiConfigProperty.BoolProperty<Biome> walkableClouds;
    private final MultiConfigProperty.IntProperty<Biome> absorbtionChance;
    private final MultiConfigProperty.IntProperty<Biome> cloudHeight;
    private final MultiConfigProperty.BoolProperty<Biome> affectedByWind;
    private final int lowerExplosiveLimit;

    public GasEmission(ForgeMod mod, UnitConfig config, Properties<?> props) {
        super(mod, config, EntityPollutant.class, props);
        String category = this.getUnitCategory();
        this.absorbtionChance = MultiConfigProperty.IntProperty.from((ForgeConfig)config, (String)category, (String)"absorbtionChance", (int)props.absorbtionChance, (IntBounds)ForgeBounds.PERCENTAGE.getIntBounds(), (String)"Defines the chance (in percents) of this pollutant being absorbed by the affected block.");
        this.cloudHeight = MultiConfigProperty.IntProperty.from((ForgeConfig)config, (String)category, (String)"cloudHeight", (int)props.cloudHeight, (IntBounds)ForgeBounds.HEIGHT.getIntBounds(), (String)"Only pollutant blocks within this height around concentration altitude will affect the level of pollution in the current chunk.\nRequired for pollutants capture and storage.");
        this.lowerExplosiveLimit = UnitConfig.getInt((ForgeConfig)config, (String)category, (String)"lowerExplosiveLimit", (int)props.lowerExplosiveLimit, (IntBounds)IntBounds.from((Integer)0, (Integer)512), (String)"The lowest number of adjacent gas blocks capable of producing an explosion in the presence of an ignition source.\nSet to zero to disable explosions.");
        this.walkableClouds = MultiConfigProperty.BoolProperty.from((ForgeConfig)config, (String)category, (String)"walkableClouds", (boolean)props.walkableClouds, (String)"Defines the ability for the player to walk along the heavily polluted clouds.");
        this.affectedByWind = MultiConfigProperty.BoolProperty.from((ForgeConfig)config, (String)category, (String)"affectedByWind", (boolean)props.affectedByWind, (String)"Defines whether wind affects this pollutant or not.");
        this.addBiomeProperties(new MultiConfigProperty.BaseProperty[]{this.absorbtionChance, this.cloudHeight, this.walkableClouds, this.affectedByWind});
        this.func_149722_s();
        this.setResistance(0.0f);
        this.func_149675_a(true);
        this.negativeEffects.addDirect(MobEffects.field_76440_q);
    }

    public static boolean isGasBlock(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block instanceof GasEmission;
    }

    @Override
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        World world;
        Biome biome;
        if (worldIn instanceof World && this.isWalkableCloudsIn(biome = (world = (World)worldIn).func_180494_b(pos)) && this.getConcentrationAltitudeIn(biome) == pos.func_177956_o() && !this.canStateBePumped(blockState)) {
            return field_185505_j;
        }
        return super.func_180646_a(blockState, worldIn, pos);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected IBlockState affectUnderlyingBlock(World world, BlockPos sourcePos, IBlockState sourceState) {
        if (this.isUnderRainOrStorm(world, sourcePos)) {
            BlockPos targetPos = this.getFirstUnderlyingBlock(world, sourcePos);
            boolean directContact = Math.abs(targetPos.func_177956_o() - sourcePos.func_177956_o()) <= 1;
            return this.affectBlockAt(world, targetPos, Optional.of(EnumFacing.UP), directContact, sourceState);
        }
        return sourceState;
    }

    public boolean affectsPollutionLevel(World world, BlockPos pos, IBlockState state) {
        return this.getCloudVertBounds(world, pos).encloses(Integer.valueOf(pos.func_177956_o()));
    }

    public IntBounds getCloudVertBounds(World world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        return IntBounds.from((Integer)this.getConcentrationAltitudeIn(biome)).extend(Integer.valueOf(this.getCloudHeightIn(biome)));
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    protected int pumpThroughVents(World world, List<BlockPos> vents, int amount) {
        int count = 0;
        if ((count += WorldSearch.VentPipe.pump((World)world, vents, (int)(amount - count), (WorldSearch.BlockChain.BlockFunc)WorldSearch.VentPipe.VALID_CHIMNEY_BLOCK, (worldIn, posIn, maxAmount) -> this.pumpEntitiesAt(worldIn, posIn, maxAmount))) >= amount) {
            return count;
        }
        if ((count += WorldSearch.VentPipe.pump((World)world, vents, (int)(amount - count), (worldIn, posIn) -> worldIn.func_175623_d(posIn), (worldIn, posIn, maxAmount) -> this.pump(worldIn, posIn, 1))) >= amount) {
            return count;
        }
        if ((count += WorldSearch.VentPipe.pump((World)world, vents, (int)(amount - count), (worldIn, posIn) -> true, (worldIn, posIn, maxAmount) -> this.pump(worldIn, posIn, maxAmount))) >= amount) {
            return count;
        }
        count += WorldSearch.VentPipe.pump((World)world, vents, (int)(amount - count), (worldIn, posIn) -> this.canPassThrough(worldIn, posIn, EnumFacing.DOWN, EnumFacing.UP), (worldIn, posIn, maxAmount) -> this.pumpEntitiesAt(worldIn, posIn, maxAmount));
        return count;
    }

    @Override
    public int emitFrom(TileEntity tile, Set<BlockState> relatedBlocks, int amount) {
        Optional<EnumFacing> motionFacing;
        boolean hasTileEntity;
        int count = 0;
        World world = tile.func_145831_w();
        if (count >= amount || !this.isServerSide(world)) {
            return count;
        }
        BlockPos sourcePos = tile.func_174877_v();
        WorldSearch.TileNeighbors neighbors = WorldSearch.TileNeighbors.from((TileEntity)tile, relatedBlocks);
        boolean bl = hasTileEntity = world.func_175625_s(sourcePos) != null;
        if (!hasTileEntity && (motionFacing = this.getMotionFacing(world, sourcePos)).isPresent() && this.canPassThrough(world, sourcePos, motionFacing.get(), motionFacing.get())) {
            neighbors.getFound().add(sourcePos);
        }
        Collections.shuffle(neighbors.getAboveBlocks());
        Collections.shuffle(neighbors.getUnderBlocks());
        Collections.shuffle(neighbors.getFound());
        count += this.pumpThroughVents(world, neighbors.getActiveVents(), amount - count);
        if (count >= amount) {
            return count;
        }
        for (BlockPos pos : neighbors.getTopChimneys()) {
            if ((count += this.pumpEntitiesAt(world, pos, amount - count)) < amount) continue;
            return count;
        }
        for (BlockPos pos : neighbors.getSideChimneys()) {
            if ((count += this.pumpEntitiesAt(world, pos, amount - count)) < amount) continue;
            return count;
        }
        if ((count += this.pumpThroughVents(world, neighbors.getPassiveVents(), amount - count)) >= amount) {
            return count;
        }
        for (BlockPos pos : neighbors.getFound()) {
            if (!world.func_175623_d(pos) || neighbors.isMultiblockHollow(pos) || (count += this.pumpEntitiesAt(world, pos, amount - count)) < amount) continue;
            return count;
        }
        for (BlockPos pos : neighbors.getFound()) {
            Optional<EnumFacing> motionFacing2 = this.getMotionFacing(world, pos);
            if (!motionFacing2.isPresent() || !this.canPassThrough(world, pos, motionFacing2.get(), motionFacing2.get()) || neighbors.isMultiblockHollow(pos) || (count += this.pumpEntitiesAt(world, pos, amount - count)) < amount) continue;
            return count;
        }
        return count;
    }

    @Deprecated
    public boolean canPassThrough(World world, BlockPos pos) {
        return this.canPassThrough(world, pos, EnumFacing.DOWN, EnumFacing.UP);
    }

    public boolean canPassThrough(World world, BlockPos pos, EnumFacing input, EnumFacing output) {
        EnumFacing[] facings;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof GasEmission || this.isSamePollutant(state)) {
            return false;
        }
        if (block == Blocks.field_150350_a || block == Blocks.field_150480_ab) {
            return true;
        }
        if (block instanceof BlockFence || block instanceof BlockFenceGate) {
            return true;
        }
        if (block instanceof BlockPane && state.func_185904_a() == Material.field_151573_f) {
            return true;
        }
        if (block instanceof ISmokeContainer && ((ISmokeContainer)block).isVent(state) && input.func_176740_k().func_176722_c() && output.func_176740_k().func_176722_c()) {
            return true;
        }
        Material material = state.func_185904_a();
        if (material == Material.field_151584_j || material == Material.field_151579_a || material == Material.field_151586_h || material == Material.field_151587_i) {
            return true;
        }
        if (this.getPassableBlocks().contains(BlockState.from((IBlockState)state))) {
            return true;
        }
        AxisAlignedBB aabb = state.func_185890_d((IBlockAccess)world, pos);
        for (EnumFacing facing : facings = new EnumFacing[]{input, output}) {
            boolean isBlockingFace;
            boolean bl = isBlockingFace = aabb != null ? AABB.isFullBlockingFace((AxisAlignedBB)aabb, (EnumFacing)facing) : false;
            if (state.isSideSolid((IBlockAccess)world, pos, facing) && isBlockingFace) {
                return false;
            }
            BlockFaceShape shape = state.func_193401_d((IBlockAccess)world, pos, facing);
            if (shape != BlockFaceShape.SOLID || !isBlockingFace) continue;
            return false;
        }
        return aabb == null || aabb.equals((Object)AABB.BLOCK) || !(input.func_176740_k() == output.func_176740_k() ? AABB.isFullBlockingPane((AxisAlignedBB)aabb, (EnumFacing.Axis)input.func_176740_k()) : AABB.isFullBlockingFace((AxisAlignedBB)aabb, (EnumFacing)input) || AABB.isFullBlockingFace((AxisAlignedBB)aabb, (EnumFacing)output));
    }

    @Override
    public Map<ItemStack, IStorageItem> getProtectiveItems(EntityLivingBase living) {
        HashMap<ItemStack, IStorageItem> items = new HashMap<ItemStack, IStorageItem>();
        for (ItemStack stack : ForgeEntity.getEquipmentOn((Entity)living)) {
            IStorage.Content content;
            Respirators.Respirator respirator = (Respirators.Respirator)Main.getRespirators().findBy(stack);
            if (respirator == null || !respirator.isFunctional(stack) || (content = respirator.getContent(stack)).getFreeSpaceFor(this) <= 0) continue;
            items.put(stack, respirator);
        }
        return items;
    }

    @Nullable
    public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos blockpos, IBlockState iblockstate, Entity entity, double yToTest, Material materialIn, boolean testingHead) {
        if (testingHead && this.canAffectEntity(entity, true)) {
            EntityLivingBase living;
            if (ForgeEntity.isServerSide((Entity)entity) && entity instanceof EntityLivingBase && !this.getProtectiveItems(living = (EntityLivingBase)entity).isEmpty()) {
                return null;
            }
            return true;
        }
        return null;
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public Spread createSpread(final World world, final BlockPos pos, final IBlockState state) {
        return new Spread(world, pos, state, this){

            @Override
            public Spread around(int minDensityDelta) {
                block1: {
                    EnumFacing dir;
                    if (this.completed() || !GasEmission.this.canSpreadAround() || this.getPollutant().getCarriedPollutionAmount(state) < minDensityDelta) break block1;
                    IWind wind = ForgeWorld.getWindAt((World)world, (BlockPos)pos);
                    ArrayList directions = new ArrayList(ForgeWorld.Direction.getShuffledHorizontals());
                    wind.sortDirections(directions);
                    Iterator iterator = directions.iterator();
                    while (iterator.hasNext() && !this.in(dir = (EnumFacing)iterator.next(), minDensityDelta).completed()) {
                    }
                }
                return this;
            }
        };
    }

    public boolean pushedBy(World world, BlockPos pos, EntityPlayer player, EnumFacing face) {
        if (!ForgeWorld.isServerSide((World)world)) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        float probability = 0.2f;
        if (!CommonMath.Random.result((float)probability)) {
            return false;
        }
        GasEmission pollutant = (GasEmission)block;
        ArrayList<EnumFacing> directions = new ArrayList<EnumFacing>(){
            private static final long serialVersionUID = -3415775606148431593L;

            @Override
            public boolean add(EnumFacing e) {
                if (this.contains(e)) {
                    return false;
                }
                return super.add(e);
            }
        };
        directions.add(face.func_176734_d());
        EnumFacing sourceDir = EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)player);
        EnumFacing pushDir = sourceDir.func_176734_d();
        directions.add(pushDir);
        Optional<EnumFacing> motionFacing = pollutant.getMotionFacing(world, pos);
        if (motionFacing.isPresent()) {
            directions.add(motionFacing.get());
        }
        for (EnumFacing dir : ForgeWorld.Direction.getShuffledAll()) {
            directions.add(dir);
        }
        if (motionFacing.isPresent()) {
            EnumFacing opposite = motionFacing.get().func_176734_d();
            directions.remove(opposite);
            directions.add(opposite);
        }
        directions.remove(sourceDir);
        directions.add(sourceDir);
        for (EnumFacing dir : directions) {
            if (!pollutant.push(world, pos, dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected EntityPollutant createEntityPollutant(World world, BlockPos pos, IBlockState carriedState) {
        return new EntityPollutant(world, pos, carriedState);
    }

    @Override
    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public int generateFrom(ItemStack stack, World world, BlockPos pos) {
        GasEmission pollutant;
        Item item = stack.func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        if (block instanceof GasEmission && (pollutant = (GasEmission)block).inAllowableDimension(world)) {
            IBlockState state = pollutant.func_176203_a(stack.func_77960_j());
            int amount = pollutant.getCarriedPollutionAmount(state);
            int generated = pollutant.generateAt(world, pos, amount, 1);
            if (generated == amount) {
                stack.func_190918_g(1);
            }
            return generated;
        }
        return 0;
    }

    public ItemBlock createBlockItem() {
        ForgeBlockItem blockItem = new ForgeBlockItem((ForgeBlock)this){

            public boolean onEntityItemUpdate(EntityItem entityItem) {
                World world = entityItem.func_130014_f_();
                if (GasEmission.this.isServerSide(world) && spreadIntoWorldInterval.pastIn(world)) {
                    ItemStack stack = entityItem.func_92059_d();
                    GasEmission.this.generateFrom(stack, world, entityItem.func_180425_c());
                }
                entityItem.func_184224_h(true);
                return super.onEntityItemUpdate(entityItem);
            }

            public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
                if (GasEmission.this.isServerSide(world) && spreadIntoWorldInterval.pastIn(world) && entity instanceof EntityPlayer && !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                    GasEmission.this.generateFrom(stack, world, entity.func_180425_c());
                }
                super.func_77663_a(stack, world, entity, itemSlot, isSelected);
            }
        };
        return blockItem;
    }

    @Override
    protected boolean spread(World world, BlockPos pos, IBlockState state) {
        boolean spreaded = super.spread(world, pos, state);
        return spreaded;
    }

    protected BlockPos getFirstUnderlyingBlock(World world, BlockPos startPos) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(startPos.func_177977_b());
        int minY = WorldData.altitudeBounds.getMin();
        for (int y = pos.func_177956_o(); y >= minY; --y) {
            pos.func_185336_p(y);
            if (!ForgeWorld.isAirBlock((World)world, (BlockPos)pos)) break;
        }
        return pos.func_185334_h();
    }

    public Percentage getPercentageAt(World world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        PollutionInfo info = WorldData.getChunkPollution(world, pos).getOrCreateInfoFor(this);
        return info.getPercentageIn(biome);
    }

    public void func_180645_a(World world, BlockPos sourcePos, IBlockState sourceState, Random random) {
        if (!this.isServerSide(world) || !this.inAllowableDimension(world)) {
            return;
        }
        IBlockState newSourceState = this.affectUnderlyingBlock(world, sourcePos, sourceState);
        if (newSourceState != sourceState) {
            world.func_175656_a(sourcePos, newSourceState);
            return;
        }
        if (this.pushedByWind(world, sourcePos, sourceState)) {
            return;
        }
    }

    protected boolean pushedByWind(World world, BlockPos sourcePos, IBlockState sourceState) {
        if (!this.isAffectedByWindIn(world.func_180494_b(sourcePos))) {
            return false;
        }
        IWind wind = ForgeWorld.getWindAt((World)world, (BlockPos)sourcePos);
        ArrayList directions = new ArrayList(ForgeWorld.Direction.getShuffledHorizontals());
        wind.sortDirections(directions);
        for (EnumFacing direction : directions) {
            BlockPos pos;
            float strength = wind.getStrengthIn(direction);
            if (!(strength > 0.0f)) continue;
            float factor = Wind.STRENGTH_BOUNDS.approxFactor(Float.valueOf(strength));
            int maxDistance = CommonMath.Approx.up((float)factor, (IntBounds)IntBounds.from((Integer)0, (Integer)this.getPollutionCapacity()));
            BlockPos destPos = null;
            for (int offset = 1; offset <= maxDistance && world.func_175667_e(pos = sourcePos.func_177967_a(direction, offset)) && ForgeWorld.isAirBlock((World)world, (BlockPos)pos); ++offset) {
                destPos = pos;
            }
            if (destPos == null || !this.pump(world, destPos)) continue;
            return this.spend(world, sourcePos);
        }
        return false;
    }

    public IPollutant.Type getPollutantType() {
        return IPollutant.Type.AIR;
    }

    public boolean isWalkableCloudsIn(Biome biome) {
        return (Boolean)this.walkableClouds.get((Object)biome);
    }

    public int getCloudHeightIn(Biome biome) {
        return (Integer)this.cloudHeight.get((Object)biome);
    }

    public float getAbsorbtionChanceIn(Biome biome) {
        return ((Integer)this.absorbtionChance.get((Object)biome)).intValue();
    }

    public int getLowerExplosiveLimit() {
        return this.lowerExplosiveLimit;
    }

    public boolean isAbsorbedIn(Biome biome) {
        float probability = this.getAbsorbtionChanceIn(biome) / 100.0f;
        return CommonMath.Random.result((float)probability);
    }

    public boolean isAffectedByWindIn(Biome biome) {
        return (Boolean)this.affectedByWind.get((Object)biome);
    }

    protected boolean isFilteredAt(World world, BlockPos pos, Optional<EnumFacing> side) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof IFilter) {
            if (side.isPresent() && state.isSideSolid((IBlockAccess)world, pos, side.get())) {
                return false;
            }
            IFilter filter = (IFilter)block;
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null) {
                return filter.fill(tile, this, 1) > 0;
            }
        }
        return false;
    }

    protected boolean isUnderRainOrStorm(World world, BlockPos pos) {
        if (world.func_72896_J() || world.func_72911_I()) {
            BlockPos checkPos = pos.func_177984_a();
            return world.func_175725_q(checkPos).func_177956_o() <= checkPos.func_177956_o();
        }
        return false;
    }

    public static class Properties<T extends Properties<T>>
    extends Pollutant.Properties<T> {
        public int absorbtionChance = 0;
        public int lowerExplosiveLimit = 0;
        public int cloudHeight = 16;
        public boolean walkableClouds = false;
        public boolean affectedByWind = true;

        public static Properties<?> of(String name, MapColor mapColor) {
            return new Properties<Properties>(Properties.class, name, new MaterialGas(mapColor));
        }

        protected Properties(Class<T> selfClass, String name, Material material) {
            super(selfClass, name, material);
        }

        public T absorbtionChance(int percentage) {
            this.absorbtionChance = percentage;
            return (T)((Properties)this.self);
        }

        public T lowerExplosiveLimit(int limit) {
            this.lowerExplosiveLimit = limit;
            return (T)((Properties)this.self);
        }

        public T cloudHeight(int height) {
            this.cloudHeight = height;
            return (T)((Properties)this.self);
        }

        public T walkableClouds() {
            this.walkableClouds = true;
            return (T)((Properties)this.self);
        }

        public T ignoreWind() {
            this.affectedByWind = false;
            return (T)((Properties)this.self);
        }
    }
}

