/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.api.IPollutant;
import com.endertech.minecraft.forge.blocks.BlockState;
import com.endertech.minecraft.forge.blocks.ForgeEntityBlock;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.MultiConfigProperty;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.regs.IPostInit;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adpother.Main;
import com.endertech.minecraft.mods.adpother.blocks.Filter;
import com.endertech.minecraft.mods.adpother.config.BlockStates;
import com.endertech.minecraft.mods.adpother.config.FilterMaterials;
import com.endertech.minecraft.mods.adpother.config.ImmuneEntities;
import com.endertech.minecraft.mods.adpother.config.NegativeEffects;
import com.endertech.minecraft.mods.adpother.entities.EntityPollutant;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import com.endertech.minecraft.mods.adpother.pollution.Spread;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.renders.PollutantRender;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Pollutant<E extends EntityPollutant>
extends ForgeEntityBlock<E>
implements IPollutant,
IPostInit {
    public static ImmuneEntities globalImmuneEntities;
    public static final PropertyEnum<Density> DENSITY;
    public static final IntBounds INITIAL_AMOUNT_BOUNDS;
    protected static final int MIN_HORIZ_SPREAD_DENSITY_DELTA = 2;
    private final List<MultiConfigProperty.BaseProperty<Biome, ?>> biomeProperties = new ArrayList();
    protected final NegativeEffects negativeEffects;
    protected final FilterMaterials filterMaterials;
    private final MultiConfigProperty.IntProperty<Biome> criticalAmount;
    private final MultiConfigProperty.IntProperty<Biome> concentrationAltitude;
    private final MultiConfigProperty.FloatProperty<Biome> motionVelocity;
    private final MultiConfigProperty.FloatProperty<Biome> emissionRate;
    private final MultiConfigProperty.BoolProperty<Biome> canAffectGrass;
    private final MultiConfigProperty.BoolProperty<Biome> canAffectLeaves;
    private final MultiConfigProperty.BoolProperty<Biome> canAffectPlants;
    private final boolean canSpreadAround = true;
    private final boolean canSpreadOverLedge = true;
    private final ColorARGB color;
    private final TextFormatting textColor;
    private final CommonCollect.BlackWhiteList<Integer> dimensions;
    protected final BlockStates passableBlocks;
    protected final BlockStates immuneBlocks;
    protected final ImmuneEntities immuneEntities;

    public Pollutant(ForgeMod mod, UnitConfig config, Class<E> entityClass, Properties<?> props) {
        super(mod, config, entityClass, props.name, props.material, CreativeTabs.field_78031_c);
        String category = this.getUnitCategory();
        this.filterMaterials = new FilterMaterials(config, category);
        this.negativeEffects = new NegativeEffects(config, category);
        this.criticalAmount = MultiConfigProperty.IntProperty.from((ForgeConfig)config, (String)category, (String)"criticalAmount", (int)props.criticalAmount, (IntBounds)ForgeBounds.POLLUTION.getIntBounds(), (String)"Defines pollutant amount at which all negative effects will be maximized.");
        this.concentrationAltitude = MultiConfigProperty.IntProperty.from((ForgeConfig)config, (String)category, (String)"concentrationAltitude", (int)props.concentrationAltitude, (IntBounds)WorldData.altitudeBounds.extend(Integer.valueOf(1)), (String)"Defines the altitude which pollutant blocks will concentrate at.");
        this.motionVelocity = MultiConfigProperty.FloatProperty.from((ForgeConfig)config, (String)category, (String)"motionVelocity", (float)props.motionVelocity, (FloatBounds)ForgeBounds.FACTOR.getFloatBounds(), (String)"Defines motion velocity of the pollutant.");
        this.emissionRate = MultiConfigProperty.FloatProperty.from((ForgeConfig)config, (String)category, (String)"emissionRate", (float)1.0f, (FloatBounds)ForgeBounds.FACTOR.getFloatBounds(), (String)"Defines emission rate for this pollutant.");
        this.canAffectGrass = MultiConfigProperty.BoolProperty.from((ForgeConfig)config, (String)category, (String)"canAffectGrass", (boolean)true, (String)"Defines the ability to influence grass.");
        this.canAffectLeaves = MultiConfigProperty.BoolProperty.from((ForgeConfig)config, (String)category, (String)"canAffectLeaves", (boolean)true, (String)"Defines the ability to influence leaves.");
        this.canAffectPlants = MultiConfigProperty.BoolProperty.from((ForgeConfig)config, (String)category, (String)"canAffectPlants", (boolean)true, (String)"Defines the ability to influence plants.");
        this.addBiomeProperties(new MultiConfigProperty.BaseProperty[]{this.criticalAmount, this.concentrationAltitude, this.motionVelocity, this.emissionRate, this.canAffectPlants, this.canAffectGrass, this.canAffectLeaves});
        ColorARGB colorARGB = ColorARGB.from((int)props.material.func_151565_r().field_76291_p).maxOpaque();
        this.color = ForgeConfig.getColorARGB((ForgeConfig)config, (String)category, (String)"color", (ColorARGB)colorARGB, (String)"Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)\n Affects smog and sky colors.");
        this.textColor = Optional.ofNullable(TextFormatting.func_96300_b((String)ForgeConfig.getStr((ForgeConfig)config, (String)category, (String)"textColor", (String)props.textColor.func_96297_d(), (String)"Defines the text color for the name of this pollutant."))).orElse(TextFormatting.WHITE);
        List black = Dimensions.readFrom((ForgeConfig)config, (String)category, (String)"dimensionBlackList", (String)"Defines a list of dimensions in which this pollutant will not be generated.");
        List white = Dimensions.readFrom((ForgeConfig)config, (String)category, (String)"dimensionWhiteList", (String)"If this list is set, the pollutant will be generated ONLY in listed dimensions, others will be ignored.");
        this.dimensions = new CommonCollect.BlackWhiteList(black, white);
        this.immuneEntities = new ImmuneEntities((ForgeConfig)config, category, "List of entities immune to this pollutant.");
        this.passableBlocks = new BlockStates(config, category, "passableBlocks", new String[]{"minecraft:carpet:*", "minecraft:trapdoor:*", "minecraft:iron_trapdoor:*"}, "List of blocks which this pollutant can pass through.");
        this.immuneBlocks = new BlockStates(config, category, "immuneBlocks", new String[]{"ic2:te:*"}, "List of blocks completely immune to this pollutant.");
        this.setUnitVariants(Density.class);
        this.field_149786_r = 0;
        this.getMod().getRegistrator().addPostInit((IPostInit)this);
    }

    public String getClassRegName() {
        return "";
    }

    public void onInit() {
        super.onInit();
    }

    public void onPostInit(FMLPostInitializationEvent event) {
        this.passableBlocks.loadData();
        this.immuneBlocks.loadData();
        this.immuneEntities.loadData();
        this.filterMaterials.loadData();
        this.negativeEffects.loadData();
        ForgeConfig.save((ForgeConfig)this.getConfig());
    }

    public boolean inAllowableDimension(World world) {
        return this.dimensions.isEmpty() || this.dimensions.isAllowed((Object)world.field_73011_w.getDimension());
    }

    public Optional<EnumFacing> getMotionFacing(World world, BlockPos pos) {
        int altitude = this.getConcentrationAltitudeIn(world.func_180494_b(pos));
        if (pos.func_177956_o() == altitude) {
            return Optional.empty();
        }
        return Optional.of(pos.func_177956_o() < altitude ? EnumFacing.UP : EnumFacing.DOWN);
    }

    public IntBounds getAltitudeBounds() {
        return WorldData.altitudeBounds;
    }

    public NegativeEffects getNegativeEffects() {
        return this.negativeEffects;
    }

    public Set<BlockState> getPassableBlocks() {
        return this.passableBlocks.getValues();
    }

    public boolean push(World world, BlockPos pos, EnumFacing facing) {
        return this.pump(world, pos.func_177972_a(facing)) && this.spend(world, pos);
    }

    public boolean pump(World world, BlockPos pos) {
        return this.pump(world, pos, 1) == 1;
    }

    public int pump(World world, BlockPos pos, int amount) {
        int count;
        IBlockState state = world.func_180495_p(pos);
        for (count = 0; count < amount && this.canStateBePumped(state); ++count) {
            state = this.getPumpedState(state);
        }
        if (count > 0) {
            world.func_175656_a(pos, state);
        }
        return count;
    }

    public int spend(World world, BlockPos pos, int amount) {
        int count;
        IBlockState state = world.func_180495_p(pos);
        for (count = 0; count < amount && this.canStateBeSpreaded(state); ++count) {
            state = this.getSpreadedState(state);
        }
        if (count > 0) {
            world.func_175656_a(pos, state);
        }
        return count;
    }

    public boolean spend(World world, BlockPos pos) {
        return this.spend(world, pos, 1) == 1;
    }

    public int pumpEntitiesAt(World world, BlockPos pos, int amount) {
        E entity;
        int count = 0;
        if (count >= amount || !this.isServerSide(world)) {
            return count;
        }
        List<E> foundEntities = this.getPollutantEntitiesAt(world, pos);
        if (foundEntities.isEmpty() && (entity = this.spawnEntity(world, pos)) != null && entity.func_70089_S()) {
            if (++count >= amount) {
                return count;
            }
            foundEntities.add(entity);
        }
        for (EntityPollutant entity2 : foundEntities) {
            if (!entity2.carriesSamePollutant(this)) continue;
            while (entity2.pump()) {
                if (++count < amount) continue;
                return count;
            }
        }
        return count;
    }

    public void scheduleUpdate(World world, BlockPos pos) {
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    public void explodeBlock(World world, BlockPos pos, float explosionSize) {
        IBlockState state = world.func_180495_p(pos);
        boolean dropAsItem = !state.func_185917_h();
        ForgeWorld.scheduleBlockExplosion((World)world, (BlockPos)pos, (CommonTime.Interval)CommonTime.Interval.ZERO, (float)explosionSize, (boolean)true, (boolean)dropAsItem, null);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.isServerSide(world) && world.func_175697_a(pos, 1) && this.getCarriedPollutionAmount(state) > 0) {
            boolean spreaded = false;
            Optional<EnumFacing> motionFacing = this.getMotionFacing(world, pos);
            if (motionFacing.isPresent()) {
                EnumFacing output;
                BlockPos nextPos = pos.func_177972_a(motionFacing.get());
                BlockPos nextPos2 = pos.func_177967_a(motionFacing.get(), 2);
                EnumFacing input = motionFacing.get().func_176734_d();
                if (this.canPassThrough(world, nextPos, input, output = motionFacing.get()) && this.canPassThrough(world, nextPos2, input, output)) {
                    if (WorldData.getData(world).getPollutantEntityLimiter().canSpawnAt(world, nextPos)) {
                        int count = this.pumpEntitiesAt(world, nextPos, this.getCarriedPollutionAmount(state));
                        spreaded = count > 0 && this.spend(world, pos, count) == count;
                    } else {
                        this.scheduleUpdate(world, pos);
                        return;
                    }
                }
            }
            if (!spreaded) {
                world.field_72984_F.func_76320_a("pollutantSpreading");
                spreaded = this.spread(world, pos, state);
                world.field_72984_F.func_76319_b();
            }
            if (!spreaded) {
                for (EnumFacing direction : ForgeWorld.Direction.getShuffledAll()) {
                    IBlockState newState = this.affectBlockAt(world, pos.func_177972_a(direction), Optional.of(direction.func_176734_d()), true, state);
                    if (newState == state) continue;
                    world.func_175656_a(pos, newState);
                    state = newState;
                    if (!ForgeWorld.isAirBlock((IBlockState)newState)) {
                        this.scheduleUpdate(world, pos);
                    }
                    return;
                }
            }
        }
    }

    protected boolean spread(World world, BlockPos pos, IBlockState state) {
        Spread spread = this.createSpread(world, pos, state);
        spread.inMotionFacing().overLedge().around(2).apply();
        return spread.completed();
    }

    public Spread createSpread(World world, BlockPos pos, IBlockState state) {
        return Spread.from(world, pos, state, this);
    }

    public boolean canStateBePumped(IBlockState state) {
        return ForgeWorld.isAirBlock((IBlockState)state) || this.isSamePollutant(state) && ((Density)((Object)state.func_177229_b(DENSITY))).canAbsorb();
    }

    public boolean canStateBeSpreaded(IBlockState state) {
        return this.getCarriedPollutionAmount(state) > 0;
    }

    public IBlockState getPumpedState(IBlockState state) {
        if (ForgeWorld.isAirBlock((IBlockState)state)) {
            return this.func_176223_P();
        }
        Density density = (Density)((Object)state.func_177229_b(DENSITY));
        return state.func_177226_a(DENSITY, (Comparable)((Object)density.getPumped()));
    }

    public IBlockState getSpreadedState(IBlockState state) {
        Density density = (Density)((Object)state.func_177229_b(DENSITY));
        return density.canSpread() ? state.func_177226_a(DENSITY, (Comparable)((Object)density.getSpreaded())) : Blocks.field_150350_a.func_176223_P();
    }

    public abstract int emitFrom(TileEntity var1, Set<BlockState> var2, int var3);

    public int generateAt(World world, BlockPos startPos, int amount, int maximumRadius) {
        int count = 0;
        int capacity = this.getPollutionCapacity();
        for (int maxRadius = 0; maxRadius <= maximumRadius && count < amount; ++maxRadius) {
            for (int vertOffset = 0; vertOffset <= maxRadius; ++vertOffset) {
                for (BlockPos planePos : new BlockPos[]{startPos.func_177981_b(vertOffset), startPos.func_177979_c(vertOffset)}) {
                    int rmax = maxRadius - vertOffset;
                    int rmin = rmax - capacity + 1;
                    if (rmin < 0) {
                        rmin = 0;
                    }
                    if (rmax < 0 || !this.getAltitudeBounds().encloses(Integer.valueOf(planePos.func_177956_o()))) continue;
                    for (int radius = rmin; radius <= rmax; ++radius) {
                        List posList = ForgeWorld.Position.getAroundHoriz((BlockPos)planePos, (int)radius, (boolean)false);
                        Collections.shuffle(posList);
                        for (BlockPos pos : posList) {
                            if (world.func_180495_p(pos).func_185904_a() == Material.field_151581_o) {
                                pos = pos.func_177984_a();
                            }
                            count += this.pump(world, pos, amount - count);
                        }
                        if (count < amount) continue;
                        return count;
                    }
                }
            }
        }
        return count;
    }

    protected boolean setPollutantBlock(World world, BlockPos pos) {
        return world.func_175656_a(pos, this.func_176223_P());
    }

    protected abstract E createEntityPollutant(World var1, BlockPos var2, IBlockState var3);

    @Nullable
    protected E spawnEntity(World world, BlockPos pos) {
        return this.spawnEntity(world, pos, this.func_176223_P());
    }

    @Nullable
    protected E spawnEntity(World world, BlockPos pos, IBlockState carriedState) {
        if (this.isServerSide(world)) {
            E entity = this.createEntityPollutant(world, pos, carriedState);
            if (!world.func_72838_d(entity)) {
                ((EntityPollutant)((Object)entity)).func_70106_y();
            }
            return entity;
        }
        this.getMod().getLogger().error("Attempt to spawn pollutant on client!");
        return null;
    }

    public boolean isSamePollutant(IBlockState state) {
        return state.func_177230_c() == this;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DENSITY});
    }

    public int func_176201_c(IBlockState state) {
        return ((Density)((Object)state.func_177229_b(DENSITY))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(DENSITY, (Comparable)((Object)Density.values()[meta]));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (Density density : Density.values()) {
            list.add((Object)new ItemStack((Block)this, 1, density.ordinal()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState nearState = world.func_180495_p(pos.func_177972_a(face));
        if (this.isSamePollutant(nearState) && this.getCarriedPollutionAmount(state) == this.getCarriedPollutionAmount(nearState)) {
            return false;
        }
        return super.func_176225_a(state, world, pos, face);
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return super.doesSideBlockRendering(state, world, pos, face);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.scheduleUpdate(world, pos);
        super.func_176213_c(world, pos, state);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
    }

    public int func_149738_a(World world) {
        return CommonMath.Random.between((int)20, (int)120);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.scheduleUpdate(world, pos);
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        Density density = (Density)((Object)worldIn.func_180495_p(pos).func_177229_b(DENSITY));
        return density != Density.HEAVY;
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return true;
    }

    public boolean func_149698_L() {
        return false;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        int opacity = super.getLightOpacity(state, world, pos);
        if (opacity > 0) {
            opacity *= this.getCarriedPollutionAmount(state) - 1;
            opacity = ForgeBounds.LIGHT_OPACITY.getIntBounds().enclose(Integer.valueOf(opacity));
        }
        return opacity;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public int getCarriedPollutionAmount(IBlockState state) {
        if (this.isSamePollutant(state)) {
            Density density = (Density)((Object)state.func_177229_b(DENSITY));
            return density.ordinal() + 1;
        }
        return 0;
    }

    public int getPollutionCapacity() {
        return Density.values().length;
    }

    public ColorARGB getColor() {
        return this.color;
    }

    public boolean canAffectEntity(Entity entity, boolean directContact) {
        if (globalImmuneEntities.contain(entity)) {
            return !globalImmuneEntities.isImmune(entity);
        }
        if (this.immuneEntities.contain(entity)) {
            return !this.immuneEntities.isImmune(entity);
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            return !player.func_175149_v() && !player.func_184812_l_();
        }
        if (entity instanceof EntityCreature) {
            return true;
        }
        if (entity instanceof EntityLiving) {
            return true;
        }
        return entity instanceof IAnimals;
    }

    public abstract IBlockState affectBlockAt(World var1, BlockPos var2, Optional<EnumFacing> var3, boolean var4, IBlockState var5);

    public List<E> getPollutantEntitiesAt(World world, BlockPos pos) {
        return world.func_72872_a(this.getEntityClass(), field_185505_j.func_186670_a(pos));
    }

    public Map<ItemStack, IStorageItem> getProtectiveItems(EntityLivingBase living) {
        return Collections.emptyMap();
    }

    protected void registerEntity() {
        this.getMod().getRegistrator().registerEntity(this.getEntityClass(), 255, 20, true);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRender() {
        this.getMod().getRegistrator().registerRenderingHandler(this.getEntityClass(), (IRenderFactory)new PollutantRender.Factory());
    }

    public TextFormatting getTextColor() {
        return this.textColor;
    }

    public int getCriticalAmountIn(Biome biome) {
        return (Integer)this.criticalAmount.get((Object)biome);
    }

    public int getConcentrationAltitudeIn(Biome biome) {
        return (Integer)this.concentrationAltitude.get((Object)biome);
    }

    public float getMotionVelocityIn(Biome biome) {
        return ((Float)this.motionVelocity.get((Object)biome)).floatValue();
    }

    public List<MultiConfigProperty.BaseProperty<Biome, ?>> getBiomeProperties() {
        return Collections.unmodifiableList(this.biomeProperties);
    }

    public float getEmissionRateIn(Biome biome) {
        return ((Float)this.emissionRate.get((Object)biome)).floatValue();
    }

    public FilterMaterials getFilterMaterials() {
        return this.filterMaterials;
    }

    public boolean canAffectGrassIn(Biome biome) {
        return (Boolean)this.canAffectGrass.get((Object)biome);
    }

    public boolean canAffectLeavesIn(Biome biome) {
        return (Boolean)this.canAffectLeaves.get((Object)biome);
    }

    public boolean canAffectPlantsIn(Biome biome) {
        return (Boolean)this.canAffectPlants.get((Object)biome);
    }

    public boolean canSpreadOverLedge() {
        return true;
    }

    public boolean canSpreadAround() {
        return true;
    }

    @SafeVarargs
    protected final void addBiomeProperties(MultiConfigProperty.BaseProperty<Biome, ?> ... properties) {
        for (MultiConfigProperty.BaseProperty<Biome, ?> prop : properties) {
            this.biomeProperties.add(prop);
        }
    }

    public BlockType getBlockType(IBlockAccess world, BlockPos pos, IBlockState state) {
        BlockDoublePlant.EnumPlantType type;
        if (this.immuneBlocks.getValues().contains(BlockState.from((IBlockState)state))) {
            return BlockType.IMMUNE;
        }
        Block block = state.func_177230_c();
        if (block instanceof Filter) {
            return BlockType.FILTER;
        }
        if (block instanceof BlockGrass) {
            return BlockType.GRASS;
        }
        if (block instanceof BlockTallGrass) {
            return BlockType.TALLGRASS;
        }
        if (block instanceof BlockDoublePlant && (type = (BlockDoublePlant.EnumPlantType)(state = state.func_185899_b(world, pos)).func_177229_b((IProperty)BlockDoublePlant.field_176493_a)) == BlockDoublePlant.EnumPlantType.GRASS) {
            return BlockType.TALLGRASS;
        }
        if (block instanceof BlockLeaves) {
            return BlockType.LEAVES;
        }
        if (block instanceof BlockFarmland || block instanceof BlockDirt || block instanceof BlockGrassPath) {
            return BlockType.SOIL;
        }
        if (state == Blocks.field_150355_j.func_176223_P() || state == Main.getFluids().pollutedWater.func_176223_P()) {
            return BlockType.WATER;
        }
        if (block instanceof IGrowable || block instanceof IPlantable) {
            return BlockType.PLANT;
        }
        return BlockType.UNKNOWN;
    }

    protected boolean doBonemealEffect(World world, BlockPos pos, IBlockState state) {
        IGrowable growable;
        Block block;
        if (ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (boolean)true) && (block = (state = world.func_180495_p(pos)).func_177230_c()) instanceof IGrowable && (growable = (IGrowable)block).func_176473_a(world, pos, state, world.field_72995_K)) {
            growable.func_176474_b(world, world.field_73012_v, pos, state);
            return true;
        }
        return false;
    }

    static {
        DENSITY = Pollutant.createPropertyEnum(Density.class);
        INITIAL_AMOUNT_BOUNDS = new IntBounds(Integer.valueOf(0), Integer.valueOf(256));
    }

    public static enum BlockType {
        CUSTOM,
        FILTER,
        GRASS,
        IMMUNE,
        LEAVES,
        PLANT,
        SOIL,
        TALLGRASS,
        WATER,
        UNKNOWN;

    }

    public static enum Density implements IForgeEnum
    {
        LIGHT,
        MEDIUM,
        HEAVY;


        public boolean canSpread() {
            return this.ordinal() > 0;
        }

        public boolean canAbsorb() {
            return this.ordinal() < Density.values().length - 1;
        }

        public Density getSpreaded() {
            return Density.values()[this.ordinal() - 1];
        }

        public Density getPumped() {
            return Density.values()[this.ordinal() + 1];
        }

        public String func_176610_l() {
            return this.getLowerCase(this.name());
        }

        public String toString() {
            return this.func_176610_l();
        }
    }

    public static class Properties<T extends Properties<T>> {
        public String name;
        public Material material;
        public TextFormatting textColor = TextFormatting.WHITE;
        public int criticalAmount = 0;
        public int concentrationAltitude = 0;
        public float motionVelocity = 0.0f;
        protected final T self;

        public static Properties<?> of(String name, Material material) {
            return new Properties<Properties>(Properties.class, name, material);
        }

        protected Properties(Class<T> selfClass, String name, Material material) {
            this.name = name;
            this.material = material;
            this.self = (Properties)selfClass.cast(this);
        }

        public T textColor(TextFormatting color) {
            this.textColor = color;
            return this.self;
        }

        public T criticalAmount(int amount) {
            this.criticalAmount = amount;
            return this.self;
        }

        public T concentrationAltitude(int altitude) {
            this.concentrationAltitude = altitude;
            return this.self;
        }

        public T motionVelocity(float velocity) {
            this.motionVelocity = velocity;
            return this.self;
        }
    }
}

