/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.blocks.FluidBlock;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;

public class PollutedWater
extends FluidBlock {
    public PollutedWater(ForgeMod mod, UnitConfig config) {
        super(mod, config, PollutedWater.createFluidFor((ForgeMod)mod, PollutedWater.class), Material.field_151586_h);
        this.func_149711_c(100.0f);
        this.func_149713_g(3);
    }

    public static boolean isPollutedWith(Pollutant<?> pollutant, World world, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        return block instanceof PollutedWater && ((PollutedWater)block).isPollutedWith(pollutant, state);
    }

    public static boolean isSource(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block instanceof PollutedWater && ((PollutedWater)block).isSourceBlock((IBlockAccess)world, pos);
    }

    public static Optional<Pollutant<?>> findPollutant(World world, BlockPos pos, Collection<Pollutant<?>> pollutants) {
        IBlockState state = world.func_180495_p(pos);
        for (Pollutant<?> pollutant : pollutants) {
            if (!PollutedWater.isPollutedWith(pollutant, world, pos, state)) continue;
            return Optional.of(pollutant);
        }
        return Optional.empty();
    }

    public boolean isPollutedWith(Pollutant<?> pollutant, IBlockState state) {
        return pollutant == Pollutants.BuiltIn.SULFUR.get();
    }

    public boolean spreadFrom(World world, BlockPos startPos) {
        if (!this.isEnabled()) {
            return false;
        }
        IBlockState state = world.func_180495_p(startPos);
        if (state == Blocks.field_150355_j.func_176223_P()) {
            return world.func_175656_a(startPos, this.func_176223_P());
        }
        return false;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        super.func_180634_a(worldIn, pos, state, entityIn);
    }

    protected void flowIntoBlock(World world, BlockPos pos, int level) {
        if (level < 0) {
            return;
        }
        if (this.displaceIfPossible(world, pos, level)) {
            world.func_180501_a(pos, this.func_176194_O().func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(level)), 3);
        }
    }

    public boolean displaceIfPossible(World world, BlockPos pos, int level) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185904_a().func_76224_d()) {
            if (level <= 0) {
                return false;
            }
            Block block = state.func_177230_c();
            int currentLevel = -1;
            if (block == Blocks.field_150358_i) {
                currentLevel = (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
            }
            if (block instanceof BlockFluidBase) {
                if (this.density < PollutedWater.getDensity((IBlockAccess)world, (BlockPos)pos)) {
                    return false;
                }
                currentLevel = (Integer)state.func_177229_b((IProperty)BlockFluidBase.LEVEL);
            }
            return level == currentLevel;
        }
        return this.displaceIfPossible(world, pos);
    }

    protected boolean isBlockLiquid(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a().func_76224_d();
    }

    protected boolean isBlockSolid(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return world.func_180495_p(pos).func_193401_d(world, pos, face) == BlockFaceShape.SOLID;
    }
}

