/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.MultiConfigProperty;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adpother.blocks.GasEmission;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.compat.DynamicTrees;
import com.endertech.minecraft.mods.adpother.config.CustomReplacements;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;

public class UserGasEmission
extends GasEmission {
    protected final CustomReplacements customReplacements;
    protected final MultiConfigProperty.BoolProperty<Biome> doesBonemealEffect;

    public UserGasEmission(ForgeMod mod, UnitConfig config, GasEmission.Properties<?> props) {
        super(mod, config, props);
        String category = this.getUnitCategory();
        this.customReplacements = new CustomReplacements(config, category);
        this.doesBonemealEffect = MultiConfigProperty.BoolProperty.from((ForgeConfig)config, (String)category, (String)"doesBonemealEffect", (boolean)false, (String)"Defines the ability to do the bone meal effect on plants and crops.");
        this.addBiomeProperties(new MultiConfigProperty.BaseProperty[]{this.doesBonemealEffect});
    }

    @Override
    public Pollutant.BlockType getBlockType(IBlockAccess world, BlockPos pos, IBlockState state) {
        Pollutant.BlockType type = super.getBlockType(world, pos, state);
        if (type == Pollutant.BlockType.UNKNOWN && this.customReplacements.containReplacementFor(state)) {
            return Pollutant.BlockType.CUSTOM;
        }
        return type;
    }

    public boolean canAffectBlock(World world, BlockPos pos, Optional<EnumFacing> side, boolean directContact) {
        IBlockState state = world.func_180495_p(pos);
        Pollutant.BlockType type = this.getBlockType((IBlockAccess)world, pos, state);
        switch (type) {
            case IMMUNE: 
            case UNKNOWN: {
                return false;
            }
            case GRASS: 
            case TALLGRASS: {
                if (this.canAffectGrassIn(world.func_180494_b(pos))) break;
                return false;
            }
            case LEAVES: {
                if (this.canAffectLeavesIn(world.func_180494_b(pos))) break;
                return false;
            }
            case PLANT: {
                if (this.canAffectPlantsIn(world.func_180494_b(pos))) break;
                return false;
            }
        }
        switch (type) {
            case FILTER: {
                return true;
            }
            case GRASS: 
            case TALLGRASS: 
            case LEAVES: 
            case PLANT: {
                if (!((Boolean)this.doesBonemealEffect.get((Object)world.func_180494_b(pos))).booleanValue()) break;
                return true;
            }
        }
        if (directContact) {
            return true;
        }
        if (this.isUnderRainOrStorm(world, pos)) {
            Percentage percent = this.getPercentageAt(world, pos);
            return percent.getValue() >= this.customReplacements.getThresholdFor(state).getValue();
        }
        return false;
    }

    @Override
    public IBlockState affectBlockAt(World world, BlockPos pos, Optional<EnumFacing> side, boolean directContact, IBlockState sourceState) {
        if (this.isSamePollutant(sourceState) && this.canAffectBlock(world, pos, side, directContact)) {
            IBlockState state = world.func_180495_p(pos);
            IBlockState replacement = this.customReplacements.findReplacementFor(state);
            if (replacement != null && world.func_175656_a(pos, replacement) && this.isAbsorbedIn(world.func_180494_b(pos))) {
                return this.getSpreadedState(sourceState);
            }
            Pollutant.BlockType type = this.getBlockType((IBlockAccess)world, pos, state);
            switch (type) {
                case FILTER: {
                    if (!this.isFilteredAt(world, pos, side)) break;
                    return this.getSpreadedState(sourceState);
                }
                case LEAVES: {
                    if (((Boolean)this.doesBonemealEffect.get((Object)world.func_180494_b(pos))).booleanValue()) {
                        DynamicTrees.pulseGrow(world, pos, state);
                        if (!this.isAbsorbedIn(world.func_180494_b(pos))) break;
                        return this.getSpreadedState(sourceState);
                    }
                    BlockPos targetPos = DynamicTrees.findBranchUnderLeaves(world, pos).orElse(pos);
                    world.func_175698_g(targetPos);
                    break;
                }
                case GRASS: {
                    if (!((Boolean)this.doesBonemealEffect.get((Object)world.func_180494_b(pos))).booleanValue() || !this.doBonemealEffect(world, pos, state)) break;
                    return this.getSpreadedState(sourceState);
                }
                case TALLGRASS: 
                case PLANT: {
                    if (((Boolean)this.doesBonemealEffect.get((Object)world.func_180494_b(pos))).booleanValue()) {
                        if (!this.doBonemealEffect(world, pos, state)) break;
                        return this.getSpreadedState(sourceState);
                    }
                    world.func_175698_g(pos);
                    break;
                }
            }
        }
        return sourceState;
    }

    @Override
    protected IBlockState affectUnderlyingBlock(World world, BlockPos sourcePos, IBlockState sourceState) {
        if (((Boolean)this.doesBonemealEffect.get((Object)world.func_180494_b(sourcePos))).booleanValue()) {
            BlockPos targetPos = this.getFirstUnderlyingBlock(world, sourcePos);
            return this.affectBlockAt(world, targetPos, Optional.of(EnumFacing.UP), false, sourceState);
        }
        return super.affectUnderlyingBlock(world, sourcePos, sourceState);
    }

    @Override
    public void onPostInit(FMLPostInitializationEvent event) {
        this.customReplacements.loadData();
        super.onPostInit(event);
    }
}

