/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class DynamicTrees {
    private static Boolean isLoaded = null;

    public static String getId() {
        return "dynamictrees";
    }

    public static boolean isLoaded() {
        if (isLoaded == null) {
            isLoaded = Loader.isModLoaded((String)DynamicTrees.getId());
        }
        return isLoaded;
    }

    public static void pulseGrow(World world, BlockPos startPos, IBlockState state) {
        if (!DynamicTrees.isLoaded()) {
            return;
        }
        if (!(state.func_177230_c() instanceof ITreePart)) {
            return;
        }
        BlockPos branchPos = DynamicTrees.findBranchUnderLeaves(world, startPos).orElse(null);
        if (branchPos != null) {
            BlockPos rootPos = TreeHelper.findRootNode((IBlockState)world.func_180495_p(branchPos), (World)world, (BlockPos)branchPos);
            if (rootPos != BlockPos.field_177992_a) {
                TreeHelper.growPulse((World)world, (BlockPos)rootPos);
            }
        } else {
            BlockDynamicLeaves leaves = TreeHelper.getLeaves((IBlockState)state);
            if (leaves != null) {
                leaves.age(world, startPos, state, world.field_73012_v, SafeChunkBounds.ANY);
            }
        }
    }

    public static Optional<BlockPos> findBranchUnderLeaves(World world, BlockPos startPos) {
        if (DynamicTrees.isLoaded()) {
            int offset = 0;
            while (true) {
                BlockPos pos;
                IBlockState state;
                if (TreeHelper.getBranch((IBlockState)(state = world.func_180495_p(pos = startPos.func_177967_a(EnumFacing.DOWN, offset)))) != null) {
                    return Optional.of(pos);
                }
                if (TreeHelper.getLeaves((IBlockState)state) == null) break;
                ++offset;
            }
        }
        return Optional.empty();
    }
}

