/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.emissions.Emissions;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Minecraft {

    public static class Fire
    extends Emitter {
        private final boolean infiniteSourceOnly;

        public Fire(UnitConfig config, UnitId id, String[] relatedBlocks, Emissions emissions) {
            super(config, id, KeyValuePair.EMPTY, false, "#hardcoded", false, relatedBlocks, emissions);
            this.infiniteSourceOnly = UnitConfig.getBool((ForgeConfig)config, (String)this.getClassCategory(), (String)"infiniteSourceOnly", (boolean)false, (String)"Produce emissions only from a burning infinite source such as netherrack, magma block, etc.");
            this.saveConfig();
        }

        public boolean infiniteSourceOnly() {
            return this.infiniteSourceOnly;
        }

        public boolean isActive(World world, BlockPos pos) {
            BlockPos sourcePos;
            Block block;
            boolean infiniteSource;
            if (this.infiniteSourceOnly() && !(infiniteSource = (block = world.func_180495_p(sourcePos = pos.func_177977_b()).func_177230_c()).isFireSource(world, sourcePos, EnumFacing.UP))) {
                return false;
            }
            return super.isActive(world, pos);
        }
    }
}

