/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.emissions;

import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.mods.adpother.emissions.IScheduledEmission;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public class EntityEmission
implements IScheduledEmission {
    public static float rate = 1.0f;
    private final Entity entity;
    private final Emitter emitter;
    private final GameTime updateInterval;
    protected boolean exists = true;

    public EntityEmission(Entity entity, Emitter emitter) {
        this.entity = entity;
        this.emitter = emitter;
        this.updateInterval = GameTime.second();
    }

    public static EntityEmission from(Entity entity, Emitter emitter) {
        return new EntityEmission(entity, emitter);
    }

    @Override
    public void update() {
        Emitter emitter;
        BlockPos pos;
        if (this.getEntity().field_70128_L) {
            this.kill();
        }
        if (!this.exists()) {
            return;
        }
        Entity entity = this.getEntity();
        World world = entity.func_130014_f_();
        if (this.getUpdateInterval().pastIn(world) && world.func_175697_a(pos = entity.func_180425_c(), 1) && (emitter = this.getEmitter()).isIdentified((INBTSerializable)entity) && emitter.isActive((INBTSerializable)entity)) {
            float factor = 0.01f;
            if (!emitter.hasSeparateRateControl()) {
                factor *= rate;
            }
            emitter.emitAt(world, pos, factor);
        }
    }

    public void kill() {
        this.exists = false;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public GameTime getUpdateInterval() {
        return this.updateInterval;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Emitter getEmitter() {
        return this.emitter;
    }
}

