/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adpother.Main;
import com.endertech.minecraft.mods.adpother.blocks.GasEmission;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.init.Respirators;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.GasExplosion;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class PlayerEvents {
    private static final GameTime PLAYER_UPDATE_INTERVAL = GameTime.quaterSecond();

    @Nullable
    static EntityPlayer getServerPlayer(LivingEvent event) {
        Entity entity = event.getEntity();
        if (!event.isCanceled() && entity instanceof EntityPlayer && ForgeEntity.isServerSide((Entity)entity)) {
            return (EntityPlayer)entity;
        }
        return null;
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void OnLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_71075_bZ.field_75098_d || !GasEmission.isGasBlock(world, pos)) {
            return;
        }
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_190926_b()) {
            Block block;
            if (ForgeWorld.isServerSide((World)world) && (block = world.func_180495_p(pos).func_177230_c()) instanceof GasEmission) {
                ((GasEmission)block).pushedBy(world, pos, player, event.getFace());
            }
        } else {
            ForgeWorld.hitThroughBlock((PlayerInteractEvent.LeftClickBlock)event, GasEmission::isGasBlock);
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
        if (block == Blocks.field_150414_aQ) {
            ItemStack respirator = Main.getRespirators().findOn(event.getEntityLiving(), false);
            if (!respirator.func_190926_b()) {
                event.setUseBlock(Event.Result.DENY);
            } else {
                EntityPlayer player = PlayerEvents.getServerPlayer((LivingEvent)event);
                if (player != null && player.func_71043_e(false)) {
                    Main.getSources().playerEating.emitFrom(player, 2.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack;
        EntityLivingBase living = event.getEntityLiving();
        ItemStack respirator = Main.getRespirators().findOn(living, false);
        if (!(respirator.func_190926_b() || (stack = event.getItemStack()).func_77975_n() != EnumAction.DRINK && stack.func_77975_n() != EnumAction.EAT)) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.FAIL);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onFinishUsing(LivingEntityUseItemEvent.Finish event) {
        EntityPlayer player;
        ItemStack stack = event.getItem();
        if (stack.func_77975_n() == EnumAction.EAT && (player = PlayerEvents.getServerPlayer((LivingEvent)event)) != null) {
            Main.getSources().playerEating.emitFrom(player, stack);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDeath(LivingDeathEvent event) {
        EntityPlayer player = PlayerEvents.getServerPlayer((LivingEvent)event);
        if (player != null) {
            Main.getSources().playerDeath.emitFrom(player, 1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @SideOnly(value=Side.CLIENT)
    public static void onInventoryTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        EntityPlayer player = event.getEntityPlayer();
        if (player == null || stack.func_190926_b()) {
            return;
        }
        Respirators.Respirator respirator = (Respirators.Respirator)Main.getRespirators().findBy(stack);
        if (respirator != null) {
            respirator.addInformation(stack, player.func_130014_f_(), event.getToolTip());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerBreaksBlock(BlockEvent.BreakEvent event) {
        if (event.isCanceled()) {
            return;
        }
        World world = event.getWorld();
        if (!ForgeWorld.isServerSide((World)world)) {
            return;
        }
        if (event.getPlayer().func_184812_l_()) {
            return;
        }
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        WorldData.onBlockBroken(world, pos, state);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.side.isServer()) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        EntityPlayer player = event.player;
        if (WorldEvents.IGNITION_FROM_TORCH_CHECK_INTERVAL.pastIn(player.field_70170_p)) {
            GasExplosion.fromHeldTorch(player).tryExplode();
        }
        if (!PLAYER_UPDATE_INTERVAL.pastIn(player.field_70170_p)) {
            return;
        }
        World world = player.func_130014_f_();
        EntityPollution pollution = WorldData.getEntityPollution((Entity)player);
        pollution.update();
        boolean explosionRisk = GasExplosion.in(world).positions(GasExplosion.getIgnitablePositionsAround(player, EnumSet.allOf(EnumHand.class))).tryTrigger();
        pollution.setExplosionRisk(explosionRisk);
        EntityPollution.NetMsg message = new EntityPollution.NetMsg(pollution);
        Main.instance.getConnection().sendToAllAround((IMessage)message, world, player.func_180425_c(), 64);
    }

    @Mod.EventBusSubscriber
    public static class Smog {
        public static boolean renderSmog = true;
        public static boolean colorSky = true;
        public static ColorARGB color;
        private static CommonTime.Stamp lastUpdate;
        private static CommonTime.Interval updateInterval;
        private static float currentDensity;
        private static float targetDensity;
        private static float minDensity;
        private static float minDensityToColorSky;
        private static float changingStep;

        @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
        @SideOnly(value=Side.CLIENT)
        public static void onFogRender(EntityViewRenderEvent.RenderFogEvent event) {
            float delta;
            if (CommonTime.Interval.passedFrom((CommonTime.Stamp)lastUpdate).moreThan(updateInterval)) {
                Entity entity = event.getEntity();
                EntityPollution pollution = WorldData.getEntityPollution(entity);
                Optional<Pollutant<?>> dominant = pollution.getDominantPollutant(pollutant -> true);
                if (dominant.isPresent()) {
                    float factor = pollution.getInfluenceOf(dominant.get()).toFraction();
                    color = dominant.get().getColor();
                    targetDensity = ForgeBounds.FOG_DENSITY.getFloatBounds().approxUp(factor).floatValue();
                } else {
                    color = null;
                    targetDensity = 0.0f;
                }
                lastUpdate = CommonTime.Stamp.now();
            }
            currentDensity = Math.abs(delta = targetDensity - currentDensity) >= Math.abs(changingStep) ? (currentDensity += changingStep * Math.signum(delta)) : targetDensity;
            if (renderSmog && Smog.enoughDensity()) {
                GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
                GlStateManager.func_179102_b((float)0.0f);
                GlStateManager.func_179095_a((float)currentDensity);
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public static void onFogColors(EntityViewRenderEvent.FogColors event) {
            if (renderSmog && color != null && currentDensity >= minDensityToColorSky) {
                event.setRed(color.getRed().toFloat());
                event.setGreen(color.getGreen().toFloat());
                event.setBlue(color.getBlue().toFloat());
            }
        }

        public static boolean enoughDensity() {
            return targetDensity >= minDensity;
        }

        static {
            lastUpdate = CommonTime.Stamp.now();
            updateInterval = GameTime.quaterSecond().getInterval();
            currentDensity = 0.0f;
            targetDensity = 0.0f;
            minDensity = 0.03f;
            minDensityToColorSky = 0.05f;
            changingStep = 3.0E-5f;
        }
    }
}

