/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.items;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.DamageableItem;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.messages.ForgeNetMsg;
import com.endertech.minecraft.forge.messages.ForgeNetMsgHandler;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.init.Materials;
import com.endertech.minecraft.mods.adpother.items.VacuumBag;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class VacuumTube
extends DamageableItem {
    public static final FloatBounds SUCK_INTERVAL_BOUNDS_IN_SEC = FloatBounds.from((Float)Float.valueOf(0.25f), (Float)Float.valueOf(1.0f));
    protected final GameTime suckInterval;
    protected final float speed;
    protected final boolean canSuckIntoInventory;

    public VacuumTube(ForgeMod mod, UnitConfig config, Materials material) {
        super(mod, config, material.func_176610_l(), CreativeTabs.field_78040_i, material.durability, UnitId.from((String)material.getDictName()));
        this.speed = ForgeConfig.getFloat((ForgeConfig)this.getConfig(), (String)this.getUnitCategory(), (String)"speed", (float)material.speed, (FloatBounds)ForgeBounds.FACTOR.getFloatBounds(), (String)"Defines operating speed for the vacuum cleaner.");
        this.suckInterval = GameTime.seconds((float)SUCK_INTERVAL_BOUNDS_IN_SEC.approxDown(this.speed).floatValue());
        this.canSuckIntoInventory = ForgeConfig.getBool((ForgeConfig)this.getConfig(), (String)this.getUnitCategory(), (String)"canSuckIntoInventory", (boolean)false, (String)"Defines the ability to suck pollution into a player's inventory");
        this.addCraftingRecipe("001 320 540", 1, new String[]{material.getBlockDictName(), "ingotIron", "stone_button", "comparator", "repeater"});
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        return super.func_77654_b(stack, world, entityLiving);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase living, int count) {
        BlockPos pos;
        IBlockState state;
        RayTraceResult mouseOver;
        World world = living.func_130014_f_();
        if (this.isClientSide(world) && living instanceof EntityPlayer && this.suckInterval.pastIn(world) && (mouseOver = Minecraft.func_71410_x().field_71476_x) != null && mouseOver.field_72313_a == RayTraceResult.Type.BLOCK && (state = world.func_180495_p(pos = mouseOver.func_178782_a())).func_177230_c() instanceof Pollutant) {
            ExhaustMsg message = new ExhaustMsg(pos, (EntityPlayer)living);
            this.getMod().getConnection().sendToServer((IMessage)message);
            living.func_184185_a(SoundEvents.field_187524_aN, 0.1f, this.speed);
        }
        super.onUsingTick(stack, living, count);
    }

    public static boolean exhaust(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack activeStack = player.func_184607_cu();
        if (state.func_177230_c() instanceof Pollutant && activeStack.func_77973_b() instanceof VacuumTube) {
            VacuumBag bag;
            ItemStack stack;
            Pollutant pollutant = (Pollutant)state.func_177230_c();
            VacuumTube tube = (VacuumTube)activeStack.func_77973_b();
            boolean pumped = false;
            Iterator iterator = ForgeEntity.getEquipmentOn((Entity)player).iterator();
            while (!(!iterator.hasNext() || (stack = (ItemStack)iterator.next()).func_77973_b() instanceof VacuumBag && (pumped = (bag = (VacuumBag)stack.func_77973_b()).fill(stack, pollutant, 1) > 0))) {
            }
            if (!pumped && tube.canSuckIntoInventory) {
                ItemStack suckedStack = new ItemStack((Block)pollutant);
                pumped = player.field_71071_by.func_70441_a(suckedStack);
            }
            if (!pumped) {
                BlockPos toPos = player.func_180425_c();
                boolean bl = pumped = pollutant.pump(world, toPos) || pollutant.pump(world, toPos.func_177984_a());
            }
            if (pumped && pollutant.spend(world, pos)) {
                return true;
            }
        }
        return false;
    }

    public GameTime getSuckInterval() {
        return this.suckInterval;
    }

    public static class ExhaustMsg
    extends ForgeNetMsg {
        public BlockPos pos;
        public int id;

        public ExhaustMsg() {
        }

        public ExhaustMsg(BlockPos pos, EntityPlayer player) {
            this.pos = pos;
            this.id = player.func_145782_y();
        }

        public static class Handler
        extends ForgeNetMsgHandler<ExhaustMsg> {
            public IMessage onMessage(ExhaustMsg message, MessageContext ctx) {
                this.addScheduledTask(ctx, () -> {
                    World world = this.getWorld(ctx);
                    Entity entity = this.findEntity(ctx, message.id);
                    if (world != null && entity instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)entity;
                        VacuumTube.exhaust(world, message.pos, player);
                    }
                });
                return null;
            }
        }
    }
}

