/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.messages.ForgeNetMsg;
import com.endertech.minecraft.forge.messages.ForgeNetMsgHandler;
import com.endertech.minecraft.mods.adpother.Main;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.blocks.PollutedWater;
import com.endertech.minecraft.mods.adpother.pollution.PointPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.ObjectUtils;

public class EntityPollution
extends PointPollution {
    protected Entity entity;
    private boolean explosionRisk;

    public EntityPollution(Entity entity) {
        super(entity.func_130014_f_(), entity.func_174824_e(1.0f));
        this.entity = entity;
    }

    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public void update() {
        this.world = this.entity.func_130014_f_();
        this.position = this.entity.func_174824_e(1.0f);
        this.ttl = CommonTime.Interval.seconds((double)FloatBounds.from((Float)Float.valueOf(1.0f), (Float)Float.valueOf(4.0f)).randomBetween().floatValue());
        super.update();
    }

    public Optional<Pollutant<?>> getDominantPollutant(Predicate<Pollutant<?>> filter) {
        Percentage largestInfluence = Percentage.ZERO;
        Pollutant dominant = null;
        for (Pollutant pollutant : Main.getPollutants().getAll()) {
            Percentage influence;
            if (!filter.test(pollutant) || (influence = this.getInfluenceOf(pollutant)).compareTo(largestInfluence) <= 0) continue;
            largestInfluence = influence;
            dominant = pollutant;
        }
        return Optional.ofNullable(dominant);
    }

    public boolean isDirectContactWith(Pollutant<?> pollutant) {
        if (pollutant.isSamePollutant(this.state)) {
            return true;
        }
        boolean isPollutedWater = PollutedWater.isPollutedWith(pollutant, this.world, this.getBlockPos(), this.state);
        return isPollutedWater && this.entity.func_70055_a(this.state.func_185904_a());
    }

    public int getDamageFrom(Pollutant<?> pollutant) {
        Percentage influence = this.getInfluenceOf(pollutant);
        int damage = MathHelper.func_76141_d((float)(influence.toFraction() * (float)pollutant.getPollutionCapacity()));
        if (this.isDirectContactWith(pollutant)) {
            damage = Math.max(damage, 1);
        }
        return damage;
    }

    public Stream<Pollutant<?>> getPollutants() {
        return this.getInfos().map(info -> info.getPollutant());
    }

    public Percentage getInfluenceOf(Pollutant<?> pollutant) {
        Percentage influence = this.getInfoFor(pollutant).map(info -> info.getPercentageIn(this.biome)).orElse(Percentage.ZERO);
        if (this.isDirectContactWith(pollutant)) {
            int amount = pollutant.getCarriedPollutionAmount(this.state);
            Percentage directInfluence = Percentage.from((int)amount, (int)pollutant.getPollutionCapacity());
            int air = this.entity.func_70086_ai();
            float airFactor = ForgeBounds.ENTITY_AIR.getIntBounds().approxFactor(Integer.valueOf(air));
            Percentage airDeficite = Percentage.from((float)(1.0f - airFactor));
            return (Percentage)ObjectUtils.max((Comparable[])new Percentage[]{influence, directInfluence, airDeficite});
        }
        return influence;
    }

    public boolean hasExplosionRisk() {
        return this.explosionRisk;
    }

    public void setExplosionRisk(boolean explosionRisk) {
        this.explosionRisk = explosionRisk;
    }

    @Override
    public void readFrom(NBTTagCompound compound) {
        super.readFrom(compound);
        this.setExplosionRisk(compound.func_74767_n("explosionRisk"));
    }

    @Override
    public void writeTo(NBTTagCompound compound) {
        super.writeTo(compound);
        compound.func_74757_a("explosionRisk", this.hasExplosionRisk());
    }

    public static class NetMsg
    extends ForgeNetMsg {
        public int entityId;
        public NBTTagCompound compound;

        public NetMsg() {
        }

        public NetMsg(EntityPollution pollution) {
            this.entityId = pollution.entity.func_145782_y();
            this.compound = new NBTTagCompound();
            pollution.writeTo(this.compound);
        }

        public static class Handler
        extends ForgeNetMsgHandler<NetMsg> {
            public IMessage onMessage(NetMsg message, MessageContext ctx) {
                World world = this.getWorld(ctx);
                if (world != null) {
                    this.addScheduledTask(ctx, () -> {
                        Entity entity = world.func_73045_a(message.entityId);
                        if (entity != null) {
                            EntityPollution pollution = WorldData.getEntityPollution(entity);
                            pollution.readFrom(message.compound);
                            pollution.update();
                        }
                    });
                }
                return null;
            }
        }
    }
}

