/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.sources;

import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.api.IEmitter;
import com.endertech.minecraft.forge.blocks.BlockState;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.ForgeEmitter;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.emissions.Emissions;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import java.util.Set;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;

public class Emitter
extends SourceBase
implements IEmitter {
    private final ForgeEmitter emitter;

    public Emitter(UnitConfig config, UnitId id, KeyValuePair identityTag, boolean isEntity, String activeStateTag, boolean useDroppedItemMeta, String[] relatedBlocks, Emissions emissions) {
        super(config, id, emissions);
        this.emitter = new ForgeEmitter(config, id, identityTag, isEntity, activeStateTag, useDroppedItemMeta, relatedBlocks){

            public String getClassCategory() {
                return Emitter.this.getClassCategory();
            }
        };
    }

    public static boolean isEntity(SourceBase source) {
        return source instanceof Emitter && ((Emitter)source).isEntity();
    }

    public String getClassCategory() {
        return IHaveConfig.getClassCategory(Emitter.class);
    }

    public String getActiveStateTag() {
        return this.emitter.getActiveStateTag();
    }

    public KeyValuePair getIdentityTag() {
        return this.emitter.getIdentityTag();
    }

    public boolean isEntity() {
        return this.emitter.isEntity();
    }

    public boolean useDroppedItemMeta() {
        return this.emitter.useDroppedItemMeta();
    }

    public void onPostInit(FMLPostInitializationEvent event) {
        this.emitter.onPostInit(event);
    }

    public Set<BlockState> getRelatedBlocks() {
        return this.emitter.getRelatedBlocks();
    }

    public boolean hasSeparateRateControl() {
        return false;
    }
}

