/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.api.IWind;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.messages.ForgeNetMsg;
import com.endertech.minecraft.forge.messages.ForgeNetMsgHandler;
import com.endertech.minecraft.forge.world.ForgeWorld;
import javax.annotation.Nullable;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class Wind
implements IWind,
IHaveConfig {
    public static final FloatBounds STRENGTH_BOUNDS = FloatBounds.from(Float.valueOf(0.0f), Float.valueOf(0.3f));
    protected static final FloatBounds STEP_BOUNDS = FloatBounds.from(Float.valueOf(0.0f), Float.valueOf(0.01f));
    protected static final int SCALE = 100;
    public static final Wind NONE;
    public static Wind defaultWind;
    protected final int biomeId;
    protected final FloatBounds strengthBounds;
    protected final float changeProbability;
    protected final float changeStep;
    protected final GameTime changeInterval = GameTime.second();
    protected final GameTime updateInterval = GameTime.quaterSecond();
    protected Vect3d currentMotion = Vect3d.ZERO;
    protected Vect3d targetMotion = Vect3d.ZERO;
    private final ForgeConfig config;

    public Wind(@Nullable ForgeConfig config, int biomeId, float strengthMax, float changeProbability, float changeStep) {
        this.config = config;
        this.biomeId = biomeId;
        strengthMax = (float)ForgeConfig.getInt(config, this.getClassCategory(), "maxStrength", Math.round(strengthMax * 100.0f), IntBounds.from(STRENGTH_BOUNDS.scale(100.0f)), "Defines maximum wind strength.") / 100.0f;
        this.strengthBounds = FloatBounds.from(Float.valueOf(-strengthMax), Float.valueOf(strengthMax));
        this.changeProbability = ForgeConfig.getFloat(config, this.getClassCategory(), "changeProbability", changeProbability * 100.0f, ForgeBounds.PERCENTAGE.getFloatBounds(), "Defines probability of wind strength and direction change in percentage.") / 100.0f;
        this.changeStep = ForgeConfig.getFloat(config, this.getClassCategory(), "changeStep", changeStep * 100.0f, STEP_BOUNDS.scale(100.0f), "Defines how fast the wind changes.") / 100.0f;
        this.randomChangeTargetMotion();
        this.currentMotion = this.targetMotion;
        this.saveConfig();
    }

    public static Wind from(UnitConfig config, int biomeId) {
        return new Wind(config, biomeId, Wind.defaultWind.strengthBounds.getMax().floatValue(), Wind.defaultWind.changeProbability, Wind.defaultWind.changeStep);
    }

    @Override
    public Vect3d getMotion() {
        return this.currentMotion;
    }

    void setCurrentMotion(Vect3d motion) {
        this.currentMotion = motion;
    }

    public Vect3d getTargetMotion() {
        return this.targetMotion;
    }

    protected void randomChangeTargetMotion() {
        this.targetMotion = Vect3d.from(this.strengthBounds.randomBetween().floatValue(), 0.0, this.strengthBounds.randomBetween().floatValue());
    }

    protected double getChangedMotion(double motion, double targetMotion) {
        double delta = targetMotion - motion;
        if (Math.abs(delta) <= (double)Math.abs(this.changeStep)) {
            return targetMotion;
        }
        double changedMotion = motion;
        if (motion < targetMotion) {
            changedMotion += (double)this.changeStep;
        }
        if (motion > targetMotion) {
            changedMotion -= (double)this.changeStep;
        }
        changedMotion = this.strengthBounds.enclose(Float.valueOf((float)changedMotion)).floatValue();
        return changedMotion;
    }

    public void update(World world) {
        if (this == NONE) {
            return;
        }
        if (ForgeWorld.isServerSide(world) && this.changeInterval.pastIn(world) && CommonMath.Random.result(this.changeProbability)) {
            this.randomChangeTargetMotion();
            WindMsg message = new WindMsg(this);
            ForgeMain.instance.getConnection().sendToAll(message);
        }
        if (this.updateInterval.pastIn(world)) {
            double x = this.getChangedMotion(this.getMotion().x, this.getTargetMotion().x);
            double y = 0.0;
            double z = this.getChangedMotion(this.getMotion().z, this.getTargetMotion().z);
            this.currentMotion = Vect3d.from(x, y, z);
        }
    }

    @Override
    @Nullable
    public ForgeConfig getConfig() {
        return this.config;
    }

    public boolean equalsDefault() {
        return this.strengthBounds.equals(Wind.defaultWind.strengthBounds) && this.changeProbability == Wind.defaultWind.changeProbability && this.changeStep == Wind.defaultWind.changeStep;
    }

    static {
        defaultWind = NONE = new Wind(null, 0, 0.0f, 0.0f, 0.0f);
    }

    public static class StaticWind
    implements IWind {
        private final Vect3d motion;

        public StaticWind(Vect3d motion) {
            this.motion = motion;
        }

        public static StaticWind from(float strength, CommonMath.Angle angle) {
            double x = -angle.sin() * (double)strength;
            double z = angle.cos() * (double)strength;
            Vect3d motion = Vect3d.from(x, 0.0, z);
            return new StaticWind(motion);
        }

        @Override
        public Vect3d getMotion() {
            return this.motion;
        }
    }

    public static class WindMsg
    extends ForgeNetMsg {
        public int biomeId;
        public Vect3d targetMotion;
        public boolean isDefaultWind;
        public float strengthMax;
        public float changeProbability;
        public float changeStep;

        public WindMsg() {
        }

        public WindMsg(Wind wind) {
            this.biomeId = wind.biomeId;
            this.targetMotion = wind.targetMotion;
            this.isDefaultWind = wind == defaultWind;
            this.strengthMax = wind.strengthBounds.getMax().floatValue();
            this.changeProbability = wind.changeProbability;
            this.changeStep = wind.changeStep;
        }

        public static class Handler
        extends ForgeNetMsgHandler<WindMsg> {
            public IMessage onMessage(WindMsg message, MessageContext ctx) {
                Wind wind = new Wind(null, message.biomeId, message.strengthMax, message.changeProbability, message.changeStep);
                wind.targetMotion = message.targetMotion;
                wind.setCurrentMotion(message.targetMotion);
                if (message.isDefaultWind) {
                    Vect3d motion = defaultWind.getMotion();
                    wind.setCurrentMotion(motion);
                    defaultWind = wind;
                } else {
                    World world = this.getWorld(ctx);
                    if (world != null) {
                        ForgeWorld.WorldData data = ForgeWorld.getData(world);
                        Wind oldWind = data.biomeWindMap.get(message.biomeId);
                        if (oldWind != null) {
                            wind.setCurrentMotion(oldWind.getMotion());
                        }
                        data.biomeWindMap.put(wind.biomeId, wind);
                    }
                }
                return null;
            }
        }
    }
}

