/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry;

import com.mojang.brigadier.CommandDispatcher;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.particles.ParticleType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Dimension;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryAPI;
import zmaster587.advancedRocketry.api.AdvancedRocketryBiomes;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryEntities;
import zmaster587.advancedRocketry.api.AdvancedRocketryFluids;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.AdvancedRocketryParticleTypes;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.Constants;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.capability.CapabilitySpaceArmor;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.advancedRocketry.block.BlockSeal;
import zmaster587.advancedRocketry.block.BlockSmallPlatePress;
import zmaster587.advancedRocketry.cable.NetworkRegistry;
import zmaster587.advancedRocketry.capability.CapabilityProtectiveArmor;
import zmaster587.advancedRocketry.client.ClientProxy;
import zmaster587.advancedRocketry.command.PlanetCommand;
import zmaster587.advancedRocketry.common.CommonProxy;
import zmaster587.advancedRocketry.compat.Compat;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.enchant.EnchantmentSpaceBreathing;
import zmaster587.advancedRocketry.event.PlanetEventHandler;
import zmaster587.advancedRocketry.integration.CompatibilityMgr;
import zmaster587.advancedRocketry.integration.GalacticCraftHandler;
import zmaster587.advancedRocketry.mission.MissionGasCollection;
import zmaster587.advancedRocketry.mission.MissionOreMining;
import zmaster587.advancedRocketry.network.PacketAirParticle;
import zmaster587.advancedRocketry.network.PacketAsteroidInfo;
import zmaster587.advancedRocketry.network.PacketAtmSync;
import zmaster587.advancedRocketry.network.PacketBiomeIDChange;
import zmaster587.advancedRocketry.network.PacketConfigSync;
import zmaster587.advancedRocketry.network.PacketDimInfo;
import zmaster587.advancedRocketry.network.PacketFluidParticle;
import zmaster587.advancedRocketry.network.PacketInvalidLocationNotify;
import zmaster587.advancedRocketry.network.PacketLaserGun;
import zmaster587.advancedRocketry.network.PacketOxygenState;
import zmaster587.advancedRocketry.network.PacketSatellite;
import zmaster587.advancedRocketry.network.PacketSpaceStationInfo;
import zmaster587.advancedRocketry.network.PacketStationUpdate;
import zmaster587.advancedRocketry.network.PacketStellarInfo;
import zmaster587.advancedRocketry.network.PacketStorageTileUpdate;
import zmaster587.advancedRocketry.recipe.RecipeCentrifuge;
import zmaster587.advancedRocketry.recipe.RecipeChemicalReactor;
import zmaster587.advancedRocketry.recipe.RecipeCrystallizer;
import zmaster587.advancedRocketry.recipe.RecipeCuttingMachine;
import zmaster587.advancedRocketry.recipe.RecipeElectricArcFurnace;
import zmaster587.advancedRocketry.recipe.RecipeElectrolyser;
import zmaster587.advancedRocketry.recipe.RecipeLathe;
import zmaster587.advancedRocketry.recipe.RecipePrecisionAssembler;
import zmaster587.advancedRocketry.recipe.RecipeRollingMachine;
import zmaster587.advancedRocketry.recipe.RecipeSmallPresser;
import zmaster587.advancedRocketry.satellite.SatelliteBiomeChanger;
import zmaster587.advancedRocketry.satellite.SatelliteComposition;
import zmaster587.advancedRocketry.satellite.SatelliteDensity;
import zmaster587.advancedRocketry.satellite.SatelliteEnergy;
import zmaster587.advancedRocketry.satellite.SatelliteMassScanner;
import zmaster587.advancedRocketry.satellite.SatelliteMicrowaveEnergy;
import zmaster587.advancedRocketry.satellite.SatelliteOptical;
import zmaster587.advancedRocketry.satellite.SatelliteOreMapping;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.advancedRocketry.tile.multiblock.TileAreaGravityController;
import zmaster587.advancedRocketry.tile.multiblock.TileAstrobodyDataProcessor;
import zmaster587.advancedRocketry.tile.multiblock.TileAtmosphereTerraformer;
import zmaster587.advancedRocketry.tile.multiblock.TileBeacon;
import zmaster587.advancedRocketry.tile.multiblock.TileBiomeScanner;
import zmaster587.advancedRocketry.tile.multiblock.TileObservatory;
import zmaster587.advancedRocketry.tile.multiblock.TileRailgun;
import zmaster587.advancedRocketry.tile.multiblock.TileSpaceElevator;
import zmaster587.advancedRocketry.tile.multiblock.TileWarpCore;
import zmaster587.advancedRocketry.tile.multiblock.energy.TileBlackHoleGenerator;
import zmaster587.advancedRocketry.tile.multiblock.energy.TileMicrowaveReciever;
import zmaster587.advancedRocketry.tile.multiblock.energy.TileSolarArray;
import zmaster587.advancedRocketry.tile.multiblock.machine.TileCentrifuge;
import zmaster587.advancedRocketry.tile.multiblock.machine.TileChemicalReactor;
import zmaster587.advancedRocketry.tile.multiblock.machine.TileCrystallizer;
import zmaster587.advancedRocketry.tile.multiblock.machine.TileCuttingMachine;
import zmaster587.advancedRocketry.tile.multiblock.machine.TileElectricArcFurnace;
import zmaster587.advancedRocketry.tile.multiblock.machine.TileElectrolyser;
import zmaster587.advancedRocketry.tile.multiblock.machine.TileLathe;
import zmaster587.advancedRocketry.tile.multiblock.machine.TilePrecisionAssembler;
import zmaster587.advancedRocketry.tile.multiblock.machine.TilePrecisionLaserEtcher;
import zmaster587.advancedRocketry.tile.multiblock.machine.TileRollingMachine;
import zmaster587.advancedRocketry.tile.multiblock.orbitallaserdrill.TileOrbitalLaserDrill;
import zmaster587.advancedRocketry.tile.satellite.TileSatelliteBuilder;
import zmaster587.advancedRocketry.util.AsteroidSmall;
import zmaster587.advancedRocketry.util.GravityHandler;
import zmaster587.advancedRocketry.util.OreGenProperties;
import zmaster587.advancedRocketry.util.RecipeHandler;
import zmaster587.advancedRocketry.util.SealableBlockHandler;
import zmaster587.advancedRocketry.util.XMLAsteroidLoader;
import zmaster587.advancedRocketry.util.XMLOreLoader;
import zmaster587.advancedRocketry.world.decoration.MapGenLander;
import zmaster587.advancedRocketry.world.decoration.StructurePieceGeode;
import zmaster587.advancedRocketry.world.gen.ore.OreGen;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.api.LibVulpesItems;
import zmaster587.libVulpes.api.material.AllowedProducts;
import zmaster587.libVulpes.api.material.Material;
import zmaster587.libVulpes.api.material.MaterialRegistry;
import zmaster587.libVulpes.api.material.MixedMaterial;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.block.BlockTile;
import zmaster587.libVulpes.items.ItemProjector;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketItemModifcation;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.InputSyncHandler;
import zmaster587.libVulpes.util.SingleEntry;

@Mod(value="advancedrocketry")
public class AdvancedRocketry {
    public static CommonProxy proxy = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    public static final String version = "@MAJOR@.@MINOR@.@REVIS@@BUILD@";
    public static AdvancedRocketry instance;
    public static final RecipeHandler machineRecipes;
    final String oreGen = "Ore Generation";
    final String ROCKET = "Rockets";
    final String MOD_INTERACTION = "Mod Interaction";
    final String PLANET = "Planet";
    final String ASTEROID = "Asteroid";
    final String BLACK_HOLE = "Black_hole_generator";
    final String GAS_MINING = "GasMining";
    final String PERFORMANCE = "Performance";
    final String CLIENT = "Client";
    public static ModContainer MOD_CONTAINER;
    public static CompatibilityMgr compat;
    public static Logger logger;
    private static final String BIOMECATETORY = "Biomes";
    private boolean resetFromXml;
    public static MaterialRegistry materialRegistry;
    public static HashMap<AllowedProducts, HashSet<String>> modProducts;
    public static ItemGroup tabAdvRocketry;
    public static final DeferredRegister<Block> BLOCKS;
    public static final DeferredRegister<Item> ITEMS;
    public static final DeferredRegister<Fluid> FLUIDS;

    public AdvancedRocketry() {
        MOD_CONTAINER = ModLoadingContext.get().getActiveContainer();
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        FLUIDS.register(modEventBus);
        ARConfiguration.register();
        AdvancedRocketryFluids.init();
        proxy.initDeferredRegistries();
    }

    public void preInit() {
        AdvancedRocketryAPI.atomsphereSealHandler = SealableBlockHandler.INSTANCE;
        ((SealableBlockHandler)AdvancedRocketryAPI.atomsphereSealHandler).loadDefaultData();
        this.resetFromXml = (Boolean)ARConfiguration.getCurrentConfig().resetFromXML.get();
        proxy.loadUILayout(ARConfiguration.getCurrentConfig());
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityProtectiveArmor());
        PacketHandler.INSTANCE.addDiscriminator(PacketDimInfo.class);
        PacketHandler.INSTANCE.addDiscriminator(PacketSatellite.class);
        PacketHandler.INSTANCE.addDiscriminator(PacketStellarInfo.class);
        PacketHandler.INSTANCE.addDiscriminator(PacketItemModifcation.class);
        PacketHandler.INSTANCE.addDiscriminator(PacketOxygenState.class);
        PacketHandler.INSTANCE.addDiscriminator(PacketStationUpdate.class);
        PacketHandler.INSTANCE.addDiscriminator(PacketSpaceStationInfo.class);
        PacketHandler.INSTANCE.addDiscriminator(PacketAtmSync.class);
        PacketHandler.INSTANCE.addDiscriminator(PacketBiomeIDChange.class);
        PacketHandler.INSTANCE.addDiscriminator(PacketStorageTileUpdate.class);
        PacketHandler.INSTANCE.addDiscriminator(PacketLaserGun.class);
        PacketHandler.INSTANCE.addDiscriminator(PacketAsteroidInfo.class);
        PacketHandler.INSTANCE.addDiscriminator(PacketAirParticle.class);
        PacketHandler.INSTANCE.addDiscriminator(PacketInvalidLocationNotify.class);
        PacketHandler.INSTANCE.addDiscriminator(PacketConfigSync.class);
        PacketHandler.INSTANCE.addDiscriminator(PacketFluidParticle.class);
        MinecraftForge.EVENT_BUS.register((Object)this);
        SatelliteRegistry.registerSatellite("optical", SatelliteOptical.class);
        SatelliteRegistry.registerSatellite("density", SatelliteDensity.class);
        SatelliteRegistry.registerSatellite("composition", SatelliteComposition.class);
        SatelliteRegistry.registerSatellite("mass", SatelliteMassScanner.class);
        SatelliteRegistry.registerSatellite("asteroidMiner", MissionOreMining.class);
        SatelliteRegistry.registerSatellite("gasMining", MissionGasCollection.class);
        SatelliteRegistry.registerSatellite("solarEnergy", SatelliteMicrowaveEnergy.class);
        SatelliteRegistry.registerSatellite("oreScanner", SatelliteOreMapping.class);
        SatelliteRegistry.registerSatellite("biomeChanger", SatelliteBiomeChanger.class);
        SatelliteRegistry.registerSatelliteProperty(new ItemStack((IItemProvider)AdvancedRocketryItems.itemSensorOptical, 1), new SatelliteProperties().setSatelliteType(SatelliteRegistry.getKey(SatelliteOptical.class)));
        SatelliteRegistry.registerSatelliteProperty(new ItemStack((IItemProvider)AdvancedRocketryItems.itemSensorComposition, 1), new SatelliteProperties().setSatelliteType(SatelliteRegistry.getKey(SatelliteComposition.class)));
        SatelliteRegistry.registerSatelliteProperty(new ItemStack((IItemProvider)AdvancedRocketryItems.itemSensorMass, 1), new SatelliteProperties().setSatelliteType(SatelliteRegistry.getKey(SatelliteMassScanner.class)));
        SatelliteRegistry.registerSatelliteProperty(new ItemStack((IItemProvider)AdvancedRocketryItems.itemSensorMicrowave, 1), new SatelliteProperties().setSatelliteType(SatelliteRegistry.getKey(SatelliteEnergy.class)));
        SatelliteRegistry.registerSatelliteProperty(new ItemStack((IItemProvider)AdvancedRocketryItems.itemSensorOreMapper, 1), new SatelliteProperties().setSatelliteType(SatelliteRegistry.getKey(SatelliteOreMapping.class)));
        SatelliteRegistry.registerSatelliteProperty(new ItemStack((IItemProvider)AdvancedRocketryItems.itemSensorBiomeChanger, 1), new SatelliteProperties().setSatelliteType(SatelliteRegistry.getKey(SatelliteBiomeChanger.class)));
        SatelliteRegistry.registerSatelliteProperty(new ItemStack((IItemProvider)AdvancedRocketryItems.itemSatellitePowerSourceBasic, 1), new SatelliteProperties().setPowerGeneration(1));
        SatelliteRegistry.registerSatelliteProperty(new ItemStack((IItemProvider)AdvancedRocketryItems.itemSatellitePowerSourceAdvanced, 1), new SatelliteProperties().setPowerGeneration(10));
        SatelliteRegistry.registerSatelliteProperty(new ItemStack((IItemProvider)LibVulpesItems.itemBattery, 1), new SatelliteProperties().setPowerStorage(100));
        SatelliteRegistry.registerSatelliteProperty(new ItemStack((IItemProvider)LibVulpesItems.itemBatteryx2, 1), new SatelliteProperties().setPowerStorage(400));
        SatelliteRegistry.registerSatelliteProperty(new ItemStack((IItemProvider)AdvancedRocketryItems.itemDataUnit, 1), new SatelliteProperties().setMaxData(1000));
        File dir = new File("./config/advRocketry");
        if (!dir.exists()) {
            dir.mkdir();
        }
        LibVulpes.registerRecipeHandler(TileCuttingMachine.class, (String)"./config/advRocketry/CuttingMachine.xml");
        LibVulpes.registerRecipeHandler(TilePrecisionAssembler.class, (String)"./config/advRocketry/PrecisionAssembler.xml");
        LibVulpes.registerRecipeHandler(TileChemicalReactor.class, (String)"./config/advRocketry/ChemicalReactor.xml");
        LibVulpes.registerRecipeHandler(TileCrystallizer.class, (String)"./config/advRocketry/Crystallizer.xml");
        LibVulpes.registerRecipeHandler(TileElectrolyser.class, (String)"./config/advRocketry/Electrolyser.xml");
        LibVulpes.registerRecipeHandler(TileElectricArcFurnace.class, (String)"./config/advRocketry/ElectricArcFurnace.xml");
        LibVulpes.registerRecipeHandler(TileLathe.class, (String)"./config/advRocketry/Lathe.xml");
        LibVulpes.registerRecipeHandler(TileRollingMachine.class, (String)"./config/advRocketry/RollingMachine.xml");
        LibVulpes.registerRecipeHandler(BlockSmallPlatePress.class, (String)"./config/advRocketry/SmallPlatePress.xml");
        LibVulpes.registerRecipeHandler(TileCentrifuge.class, (String)"./config/advRocketry/Centrifuge.xml");
        SpaceObjectManager.getSpaceManager().registerSpaceObjectType("genericObject", SpaceStationObject.class);
        proxy.preinit();
        machineRecipes.registerMachine(TileElectrolyser.class);
        machineRecipes.registerMachine(TileCuttingMachine.class);
        machineRecipes.registerMachine(TileLathe.class);
        machineRecipes.registerMachine(TilePrecisionAssembler.class);
        machineRecipes.registerMachine(TileElectricArcFurnace.class);
        machineRecipes.registerMachine(TileChemicalReactor.class);
        machineRecipes.registerMachine(TileRollingMachine.class);
        machineRecipes.registerMachine(TileCrystallizer.class);
        machineRecipes.registerMachine(TileCentrifuge.class);
        machineRecipes.registerMachine(BlockSmallPlatePress.class);
        machineRecipes.registerMachine(TilePrecisionLaserEtcher.class);
    }

    @SubscribeEvent
    public void registerRecipeTypes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        event.getRegistry().register(RecipeLathe.INSTANCE.setRegistryName("lathe"));
        event.getRegistry().register(RecipeRollingMachine.INSTANCE.setRegistryName("rollingmachine"));
        event.getRegistry().register(RecipeCrystallizer.INSTANCE.setRegistryName("crystallizer"));
        event.getRegistry().register(RecipeSmallPresser.INSTANCE.setRegistryName("smallplate"));
        event.getRegistry().register(RecipeCuttingMachine.INSTANCE.setRegistryName("cuttingmachine"));
        event.getRegistry().register(RecipePrecisionAssembler.INSTANCE.setRegistryName("precisionassembler"));
        event.getRegistry().register(RecipeElectricArcFurnace.INSTANCE.setRegistryName("electricarcfurnace"));
        event.getRegistry().register(RecipeChemicalReactor.INSTANCE.setRegistryName("chemicalreactor"));
        event.getRegistry().register(RecipeCentrifuge.INSTANCE.setRegistryName("centrifuge"));
        event.getRegistry().register(RecipeElectrolyser.INSTANCE.setRegistryName("electrolyser"));
    }

    public void registerRecipes() {
        machineRecipes.registerAllMachineRecipes();
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        AdvancedRocketryEntities.registerEntities(event);
    }

    @SubscribeEvent
    public void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> evt) {
        AdvancedRocketryTileEntityType.registerTileEntities(evt);
    }

    @SubscribeEvent
    public void registerStructures(RegistryEvent.Register<Structure<?>> evt) {
        AdvancedRocketryBiomes.registerStructures(evt);
    }

    @SubscribeEvent
    public void registerCarvers(RegistryEvent.Register<WorldCarver<?>> evt) {
        AdvancedRocketryBiomes.registerCarvers(evt);
    }

    @SubscribeEvent
    public void registerFeature(RegistryEvent.Register<Feature<?>> evt) {
        AdvancedRocketryBiomes.registerFeature(evt);
    }

    @SubscribeEvent
    public void registerBiomes(RegistryEvent.Register<Biome> evt) {
        AdvancedRocketryBiomes.registerBiomes(evt);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void registerEnchants(RegistryEvent.Register<Enchantment> evt) {
        AdvancedRocketryAPI.enchantmentSpaceProtection = (Enchantment)new EnchantmentSpaceBreathing().setRegistryName("spacebreathing");
        evt.getRegistry().register((IForgeRegistryEntry)AdvancedRocketryAPI.enchantmentSpaceProtection);
    }

    @SubscribeEvent
    public void registerParticles(ParticleFactoryRegisterEvent evt) {
        AdvancedRocketryParticleTypes.registerParticles(evt);
    }

    @SubscribeEvent
    public void registerParticles(RegistryEvent.Register<ParticleType<?>> evt) {
        AdvancedRocketryParticleTypes.registerParticles(evt);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void registerItems(RegistryEvent.Register<Item> evt) {
        AdvancedRocketryItems.registerItems(evt);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void registerBlocks(RegistryEvent.Register<Block> evt) {
        AdvancedRocketryBlocks.registerBlocks(evt);
        materialRegistry.registerMaterial(new Material("titaniumaluminide", "pickaxe", 1, 11453150, AllowedProducts.getProductByName((String)"PLATE").getFlagValue() | AllowedProducts.getProductByName((String)"INGOT").getFlagValue() | AllowedProducts.getProductByName((String)"NUGGET").getFlagValue() | AllowedProducts.getProductByName((String)"DUST").getFlagValue() | AllowedProducts.getProductByName((String)"STICK").getFlagValue() | AllowedProducts.getProductByName((String)"BLOCK").getFlagValue() | AllowedProducts.getProductByName((String)"GEAR").getFlagValue() | AllowedProducts.getProductByName((String)"SHEET").getFlagValue(), false));
        materialRegistry.registerMaterial(new Material("titaniumiridium", "pickaxe", 1, 14147556, AllowedProducts.getProductByName((String)"PLATE").getFlagValue() | AllowedProducts.getProductByName((String)"INGOT").getFlagValue() | AllowedProducts.getProductByName((String)"NUGGET").getFlagValue() | AllowedProducts.getProductByName((String)"DUST").getFlagValue() | AllowedProducts.getProductByName((String)"STICK").getFlagValue() | AllowedProducts.getProductByName((String)"BLOCK").getFlagValue() | AllowedProducts.getProductByName((String)"GEAR").getFlagValue() | AllowedProducts.getProductByName((String)"SHEET").getFlagValue(), false));
        materialRegistry.registerOres(LibVulpes.tabLibVulpesOres);
        BlockTags.func_199896_a().func_241834_b(new ResourceLocation("forge", "turfmoon")).func_230235_a_((Object)AdvancedRocketryBlocks.blockMoonTurf);
        BlockTags.func_199896_a().func_241834_b(new ResourceLocation("forge", "turfmoon")).func_230235_a_((Object)AdvancedRocketryBlocks.blockMoonTurfDark);
        BlockTags.func_199896_a().func_241834_b(new ResourceLocation("minecraft", "logs")).func_230235_a_((Object)AdvancedRocketryBlocks.blockAlienWood);
        BlockTags.func_199896_a().func_241834_b(new ResourceLocation("minecraft", "planks")).func_230235_a_((Object)AdvancedRocketryBlocks.blockAlienPlanks);
        BlockTags.func_199896_a().func_241834_b(new ResourceLocation("minecraft", "leaves")).func_230235_a_((Object)AdvancedRocketryBlocks.blockAlienLeaves);
        BlockTags.func_199896_a().func_241834_b(new ResourceLocation("minecraft", "saplings")).func_230235_a_((Object)AdvancedRocketryBlocks.blockAlienSapling);
        BlockTags.func_199896_a().func_241834_b(new ResourceLocation("forge", "concrete")).func_230235_a_((Object)AdvancedRocketryBlocks.blockConcrete);
        BlockTags.func_199896_a().func_241834_b(new ResourceLocation("advancedrocketry", "casingcentrifuge")).func_230235_a_((Object)LibVulpesBlocks.blockAdvStructureBlock);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        proxy.preInitItems();
        proxy.preInitBlocks();
    }

    @SubscribeEvent
    public void load(FMLCommonSetupEvent event) {
        this.preInit();
        proxy.init();
        NetworkRegistry.registerFluidNetwork();
        MaterialRegistry.registerMixedMaterial((MixedMaterial)new MixedMaterial(TileElectricArcFurnace.class, (Object)"orerutile", new ItemStack[]{MaterialRegistry.getMaterialFromName((String)"Titanium").getProduct(AllowedProducts.getProductByName((String)"INGOT"))}));
        LinkedList<BlockMeta> list = new LinkedList<BlockMeta>();
        list.add(new BlockMeta(AdvancedRocketryBlocks.blockDataBus, true));
        TileMultiBlock.addMapping((char)'D', list);
        machineRecipes.registerAllMachineRecipes();
    }

    @SubscribeEvent
    public void postInit(FMLLoadCompleteEvent event) {
        Biome biome;
        this.registerRecipes();
        AtmosphereType.registerAtmosphere();
        OreGen.injectOreGen();
        ARConfiguration.getCurrentConfig();
        List biomeBlackList = (List)ARConfiguration.biomeBlackList.get();
        ARConfiguration.getCurrentConfig();
        List biomeHighPressure = (List)ARConfiguration.biomeHighPressure.get();
        ARConfiguration.getCurrentConfig();
        List biomeSingle = (List)ARConfiguration.biomeSingle.get();
        AdvancedRocketryBiomes.instance.registerBlackListBiome(AdvancedRocketryBiomes.moonBiome);
        AdvancedRocketryBiomes.instance.registerBlackListBiome(AdvancedRocketryBiomes.moonBiomeDark);
        AdvancedRocketryBiomes.instance.registerBlackListBiome(AdvancedRocketryBiomes.hotDryBiome);
        AdvancedRocketryBiomes.instance.registerBlackListBiome(AdvancedRocketryBiomes.spaceBiome);
        AdvancedRocketryBiomes.instance.registerBlackListBiome(AdvancedRocketryBiomes.volcanic);
        for (CharSequence string : biomeBlackList) {
            try {
                biome = AdvancedRocketryBiomes.getBiome((String)string);
                if (biome == null) {
                    logger.warn(String.format("Error blackListing biome  \"%s\", a biome with that ID does not exist!", string));
                    continue;
                }
                AdvancedRocketryBiomes.instance.registerBlackListBiome(biome);
            }
            catch (NumberFormatException e) {
                logger.warn("Error blackListing \"" + string + "\".  It is not a valid number or Biome ResourceLocation");
            }
        }
        if (((Boolean)ARConfiguration.getCurrentConfig().blackListAllVanillaBiomes.get()).booleanValue()) {
            AdvancedRocketryBiomes.instance.blackListVanillaBiomes();
        }
        for (CharSequence string : biomeHighPressure) {
            try {
                biome = AdvancedRocketryBiomes.getBiome((String)string);
                if (biome == null) {
                    logger.warn(String.format("Error registering high pressure biome \"%s\", a biome with that ID does not exist!", string));
                    continue;
                }
                AdvancedRocketryBiomes.instance.registerHighPressureBiome(biome);
            }
            catch (NumberFormatException e) {
                logger.warn("Error registering high pressure biome \"" + string + "\".  It is not a valid number or Biome ResourceLocation");
            }
        }
        for (CharSequence string : biomeSingle) {
            try {
                biome = AdvancedRocketryBiomes.getBiome((String)string);
                if (biome == null) {
                    logger.warn(String.format("Error registering single biome \"%s\", a biome with that ID does not exist!", string));
                    continue;
                }
                AdvancedRocketryBiomes.instance.registerSingleBiome(biome);
            }
            catch (NumberFormatException e) {
                logger.warn("Error registering single biome \"" + string + "\".  It is not a valid number or Biome ResourceLocation");
            }
        }
        CapabilitySpaceArmor.register();
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileElectricArcFurnace(), (BlockTile)AdvancedRocketryBlocks.blockArcFurnace);
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileRollingMachine(), (BlockTile)AdvancedRocketryBlocks.blockRollingMachine);
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileLathe(), (BlockTile)AdvancedRocketryBlocks.blockLathe);
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileCrystallizer(), (BlockTile)AdvancedRocketryBlocks.blockCrystallizer);
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileCuttingMachine(), (BlockTile)AdvancedRocketryBlocks.blockCuttingMachine);
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TilePrecisionAssembler(), (BlockTile)AdvancedRocketryBlocks.blockPrecisionAssembler);
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileElectrolyser(), (BlockTile)AdvancedRocketryBlocks.blockElectrolyser);
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileChemicalReactor(), (BlockTile)AdvancedRocketryBlocks.blockChemicalReactor);
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TilePrecisionLaserEtcher(), (BlockTile)AdvancedRocketryBlocks.blockPrecisionLaserEtcher);
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileObservatory(), (BlockTile)AdvancedRocketryBlocks.blockObservatory);
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileAstrobodyDataProcessor(), (BlockTile)AdvancedRocketryBlocks.blockPlanetAnalyser);
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileCentrifuge(), (BlockTile)AdvancedRocketryBlocks.blockCentrifuge);
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileSatelliteBuilder(), (BlockTile)AdvancedRocketryBlocks.blockSatelliteBuilder);
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileBlackHoleGenerator(), (BlockTile)AdvancedRocketryBlocks.blockBlackHoleGenerator);
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileMicrowaveReciever(), (BlockTile)AdvancedRocketryBlocks.blockMicrowaveReciever);
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileSolarArray(), (BlockTile)AdvancedRocketryBlocks.blockSolarArray);
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileWarpCore(), (BlockTile)AdvancedRocketryBlocks.blockWarpCore);
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileBeacon(), (BlockTile)AdvancedRocketryBlocks.blockBeacon);
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileBiomeScanner(), (BlockTile)AdvancedRocketryBlocks.blockBiomeScanner);
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileRailgun(), (BlockTile)AdvancedRocketryBlocks.blockRailgun);
        ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileSpaceElevator(), (BlockTile)AdvancedRocketryBlocks.blockSpaceElevatorController);
        if (((Boolean)ARConfiguration.getCurrentConfig().enableTerraforming.get()).booleanValue()) {
            ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileAtmosphereTerraformer(), (BlockTile)AdvancedRocketryBlocks.blockAtmosphereTerraformer);
        }
        if (((Boolean)ARConfiguration.getCurrentConfig().enableGravityController.get()).booleanValue()) {
            ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileAreaGravityController(), (BlockTile)AdvancedRocketryBlocks.blockGravityMachine);
        }
        if (((Boolean)ARConfiguration.getCurrentConfig().enableLaserDrill.get()).booleanValue()) {
            ((ItemProjector)LibVulpesItems.itemHoloProjector).registerMachine((TileMultiBlock)new TileOrbitalLaserDrill(), (BlockTile)AdvancedRocketryBlocks.blockSpaceLaser);
        }
        proxy.registerEventHandlers();
        proxy.registerKeyBindings();
        PlanetEventHandler handle = new PlanetEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)handle);
        InputSyncHandler inputSync = new InputSyncHandler();
        MinecraftForge.EVENT_BUS.register((Object)inputSync);
        MinecraftForge.EVENT_BUS.register((Object)new MapGenLander());
        AdvancedRocketryAPI.gravityManager = new GravityHandler();
        if (ModList.get().isLoaded("galacticraftcore") && ((Boolean)ARConfiguration.getCurrentConfig().overrideGCAir.get()).booleanValue()) {
            GalacticCraftHandler eventHandler = new GalacticCraftHandler();
            MinecraftForge.EVENT_BUS.register((Object)eventHandler);
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.register((Object)eventHandler));
        }
        Compat.isSpongeInstalled = ModList.get().isLoaded("sponge");
        MinecraftForge.EVENT_BUS.register((Object)SpaceObjectManager.getSpaceManager());
        boolean mixedMetalCount = false;
        for (MixedMaterial mixedMaterial : MaterialRegistry.getMixedMaterialList()) {
        }
        DimensionManager.getInstance().registerSpaceDimension(ARConfiguration.GetSpaceDimId());
        ARConfiguration.loadPostInit();
        StructurePieceGeode.init();
        ARConfiguration.getCurrentConfig().initiallyKnownPlanets.add(Dimension.field_236053_b_.func_240901_a_());
    }

    public void serverStarted(FMLServerStartedEvent event) {
        for (ResourceLocation dimId : DimensionManager.getInstance().getLoadedDimensions()) {
            DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(dimId);
            if (properties.isNativeDimension || properties.getId() != ARConfiguration.getCurrentConfig().MoonId || ModList.get().isLoaded("galacticraftcore")) continue;
            properties.isNativeDimension = true;
        }
    }

    public void registerCommands(RegisterCommandsEvent event) {
        PlanetCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    public void serverStarting(FMLServerAboutToStartEvent event) {
        File file = new File("./config/advRocketry/asteroidConfig.xml");
        logger.info("Checking for asteroid config at " + file.getAbsolutePath());
        if (!file.exists()) {
            logger.info(file.getAbsolutePath() + " not found, generating");
            try {
                file.createNewFile();
                BufferedWriter stream = new BufferedWriter(new FileWriter(file));
                stream.write("<Asteroids>\n\t<asteroid name=\"Small Asteroid\" distance=\"10\" mass=\"100\" massVariability=\"0.5\" minLevel=\"0\" probability=\"10\" richness=\"0.2\" richnessVariability=\"0.5\">\n\t\t<ore itemStack=\"minecraft:iron_ore\" chance=\"15\" />\n\t\t<ore itemStack=\"minecraft:gold_ore\" chance=\"10\" />\n\t\t<ore itemStack=\"minecraft:redstone_ore\" chance=\"10\" />\n\t</asteroid>\n\t<asteroid name=\"Iridium Enriched asteroid\" distance=\"100\" mass=\"25\" massVariability=\"0.5\" minLevel=\"0\" probability=\"0.75\" richness=\"0.2\" richnessVariability=\"0.3\">\n\t\t<ore itemStack=\"minecraft:iron_ore\" chance=\"25\" />\n\t\t<ore itemStack=\"libvulpes:ore0 10\" chance=\"5\" />\n\t</asteroid>\n</Asteroids>");
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        XMLAsteroidLoader load = new XMLAsteroidLoader();
        try {
            load.loadFile(file);
            for (AsteroidSmall asteroid : load.loadPropertyFile()) {
                ARConfiguration.getCurrentConfig().asteroidTypes.put(asteroid.ID, asteroid);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        file = new File("./config/advRocketry/oreConfig.xml");
        logger.info("Checking for ore config at " + file.getAbsolutePath());
        if (!file.exists()) {
            logger.info(file.getAbsolutePath() + " not found, generating");
            try {
                file.createNewFile();
                BufferedWriter stream = new BufferedWriter(new FileWriter(file));
                stream.write("<OreConfig>\n</OreConfig>");
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            XMLOreLoader oreLoader = new XMLOreLoader();
            try {
                oreLoader.loadFile(file);
                List<SingleEntry<HashedBlockPosition, OreGenProperties>> mapping = oreLoader.loadPropertyFile();
                for (Map.Entry entry : mapping) {
                    int pressure = ((HashedBlockPosition)entry.getKey()).x;
                    short temp = ((HashedBlockPosition)entry.getKey()).y;
                    if (pressure == -1) {
                        if (temp == -1) continue;
                        OreGenProperties.setOresForTemperature(DimensionProperties.Temps.values()[temp], (OreGenProperties)entry.getValue());
                        continue;
                    }
                    if (temp == -1) {
                        if (pressure == -1) continue;
                        OreGenProperties.setOresForPressure(DimensionProperties.AtmosphereTypes.values()[pressure], (OreGenProperties)entry.getValue());
                        continue;
                    }
                    OreGenProperties.setOresForPressureAndTemp(DimensionProperties.AtmosphereTypes.values()[pressure], DimensionProperties.Temps.values()[temp], (OreGenProperties)entry.getValue());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        DimensionManager.getInstance().createAndLoadDimensions(this.resetFromXml);
    }

    public void serverStopped(FMLServerStoppedEvent event) {
        DimensionManager.getInstance().onServerStopped();
        SpaceObjectManager.getSpaceManager().onServerStopped();
        ARConfiguration.getCurrentConfig().MoonId = Constants.INVALID_PLANET;
        ((BlockSeal)AdvancedRocketryBlocks.blockPipeSealer).clearMap();
        if (!((Boolean)ARConfiguration.getCurrentConfig().lockUI.get()).booleanValue()) {
            proxy.saveUILayout(ARConfiguration.getCurrentConfig());
        }
    }

    static {
        machineRecipes = new RecipeHandler();
        compat = new CompatibilityMgr();
        logger = LogManager.getLogger((String)"advancedrocketry");
        materialRegistry = new MaterialRegistry();
        modProducts = new HashMap();
        tabAdvRocketry = new ItemGroup("advancedRocketry"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)AdvancedRocketryItems.itemSatelliteIdChip);
            }
        };
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"advancedrocketry");
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"advancedrocketry");
        FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"advancedrocketry");
    }
}

