/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api;

import java.io.InvalidClassException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.Constants;
import zmaster587.advancedRocketry.api.atmosphere.AtmosphereRegister;
import zmaster587.advancedRocketry.api.fuel.FuelRegistry;
import zmaster587.advancedRocketry.util.AsteroidSmall;
import zmaster587.advancedRocketry.util.SealableBlockHandler;

public class ARConfiguration {
    public static final String configFolder = "advRocketry";
    static final byte MAGIC_CODE = -59;
    static final long MAGIC_CODE_PT2 = 0x2AAAAAAAAABL;
    static final String CATEGORY_WORLD_GENERATION = "World Generation";
    static final String CATEGORY_ROCKET = "Rockets";
    static final String CATEGORY_TERRAFORMING = "Terraforming";
    static final String CATEGORY_PLANET = "Planets";
    static final String CATEGORY_STATION = "Stations";
    static final String CATEGORY_ENERGY = "Energy";
    static final String CATEGORY_LASERDRILL = "Orbital Laser Drill";
    static final String CATEGORY_RESOURCE_MISSION = "Resource Collection Missions";
    static final String CATEGORY_PERFORMANCE = "Performance";
    static final String CATEGORY_CLIENT = "Client";
    static final String CATEGORY_OXYGEN = "Oxygen";
    public static Logger logger = LogManager.getLogger((String)"advancedrocketry");
    static ForgeConfigSpec.ConfigValue<List<? extends String>> sealableBlockWhiteList;
    static ForgeConfigSpec.ConfigValue<List<? extends String>> sealableBlockBlackList;
    static ForgeConfigSpec.ConfigValue<List<? extends String>> breakableTorches;
    static ForgeConfigSpec.ConfigValue<List<? extends String>> blackListRocketBlocksStr;
    static ForgeConfigSpec.ConfigValue<List<? extends String>> harvestableGasses;
    static ForgeConfigSpec.ConfigValue<List<? extends String>> entityList;
    static ForgeConfigSpec.ConfigValue<List<? extends String>> geodeOres;
    static ForgeConfigSpec.ConfigValue<List<? extends String>> blackHoleGeneratorTiming;
    static ForgeConfigSpec.ConfigValue<List<? extends String>> orbitalLaserOres;
    static ForgeConfigSpec.ConfigValue<List<? extends String>> liquidMonopropellant;
    static ForgeConfigSpec.ConfigValue<List<? extends String>> liquidBipropellantFuel;
    static ForgeConfigSpec.ConfigValue<List<? extends String>> liquidBipropellantOxidizer;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> biomeBlackList;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> biomeHighPressure;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> biomeSingle;
    private static ARConfiguration currentConfig;
    private static ARConfiguration diskConfig;
    private static boolean usingServerConfig;
    static List<ForgeConfigSpec.ConfigValue<?>> allConfigValues;
    private static final ForgeConfigSpec commonSpec;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> launchingDestroysBlocks;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Double> suitTankCapacity;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Double> blockTankCapacity;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> crystalliserMaximumGravity;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> vacuumDamageValue;
    @ConfigProperty(needsSync=true, internalType=Integer.class)
    public ForgeConfigSpec.ConfigValue<Integer> orbit;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> resetFromXML;
    @ConfigProperty(needsSync=true)
    public ForgeConfigSpec.ConfigValue<Integer> stationClearanceHeight;
    @ConfigProperty(needsSync=true)
    public ForgeConfigSpec.ConfigValue<Integer> transBodyInjection;
    @ConfigProperty(needsSync=true)
    public ForgeConfigSpec.ConfigValue<Double> asteroidTBIBurnMult;
    @ConfigProperty(needsSync=true)
    public ForgeConfigSpec.ConfigValue<Double> warpTBIBurnMult;
    @ConfigProperty
    public ResourceLocation MoonId = Constants.INVALID_PLANET;
    @ConfigProperty(needsSync=true, internalType=String.class)
    public ForgeConfigSpec.ConfigValue<String> spaceDimId;
    @ConfigProperty(needsSync=true, internalType=Integer.class)
    public ForgeConfigSpec.ConfigValue<Integer> stationSize;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Double> rocketThrustMultiplier;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Double> fuelCapacityMultiplier;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> maxBiomes;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> rocketRequireFuel;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> enableNausea;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> canBeFueledByHand;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> enableOxygen;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Double> buildSpeedMultiplier;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> generateCopper;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> copperPerChunk;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> copperClumpSize;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> generateTin;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> tinPerChunk;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> tinClumpSize;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> generateDilithium;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> dilithiumClumpSize;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> dilithiumPerChunk;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> dilithiumPerChunkMoon;
    public ForgeConfigSpec.ConfigValue<Integer> aluminumPerChunk;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> aluminumClumpSize;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> generateAluminum;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> generateIridium;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> IridiumClumpSize;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> IridiumPerChunk;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> generateRutile;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> rutilePerChunk;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> rutileClumpSize;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> allowMakingItemsForOtherMods;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> scrubberRequiresCartrige;
    @ConfigProperty
    public float EUMult;
    @ConfigProperty
    public float RFMult;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> overrideGCAir;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> fuelPointsPerDilithium;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> electricPlantsSpawnLightning;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> allowSawmillVanillaWood;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> atmosphereHandleBitMask;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> automaticRetroRockets;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> advancedVFX;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> enableLaserDrill;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> spaceSuitOxygenTime;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Double> travelTimeMultiplier;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> maxBiomesPerPlanet;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> enableTerraforming;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Double> gasCollectionMult;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> allowTerraforming;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> terraformingBlockSpeed;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Double> terraformSpeed;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> terraformRequiresFluid;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Double> microwaveRecieverMulitplier;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> blackListAllVanillaBiomes;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Double> asteroidMiningTimeMult;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> canPlayerRespawnInSpace;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> forcePlayerRespawnInSpace;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Double> spaceLaserPowerMult;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<List<? extends String>> laserBlackListDims;
    @ConfigProperty
    public LinkedList<String> standardLaserDrillOres = new LinkedList();
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> laserDrillPlanet;
    @ConfigProperty
    public LinkedList<EntityType> bypassEntity = new LinkedList();
    @ConfigProperty
    public LinkedList<Block> torchBlocks = new LinkedList();
    @ConfigProperty
    public LinkedList<Block> blackListRocketBlocks = new LinkedList();
    @ConfigProperty
    public LinkedList<ResourceLocation> standardGeodeOres = new LinkedList();
    @ConfigProperty(needsSync=true, internalType=ResourceLocation.class)
    public HashSet<ResourceLocation> initiallyKnownPlanets = new HashSet();
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> geodeOresBlackList;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> laserDrillOresBlackList;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> lockUI;
    @ConfigProperty(needsSync=true, keyType=String.class, valueType=AsteroidSmall.class)
    public HashMap<String, AsteroidSmall> asteroidTypes = new HashMap();
    @ConfigProperty
    public HashMap<String, AsteroidSmall> prevAsteroidTypes = new HashMap();
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> oxygenVentSize;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> solarGeneratorMult;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> gravityAffectsFuel;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> lowGravityBoots;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Double> jetPackThrust;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> enableGravityController;
    @ConfigProperty(needsSync=true, internalType=Boolean.class)
    public ForgeConfigSpec.ConfigValue<Boolean> planetsMustBeDiscovered;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> generateGeodes;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> geodeBaseSize;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> geodeVariation;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> terraformliquidRate;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> dropExTorches;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Double> oxygenVentConsumptionMult;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> terraformPlanetSpeed;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> planetDiscoveryChance;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Double> oxygenVentPowerMultiplier;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> skyOverride;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> planetSkyOverride;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> stationSkyOverride;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> allowTerraformNonAR;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> allowZeroGSpacestations;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Float> blackHolePowerMultiplier;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Integer> defaultItemTimeBlackHole;
    @ConfigProperty
    public Map<ItemStack, Integer> blackHoleGeneratorBlocks = new HashMap<ItemStack, Integer>();
    @ConfigProperty
    public String[] lavaCentrifugeOutputs;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> generateVanillaStructures;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> generateCraters;
    @ConfigProperty
    public ForgeConfigSpec.ConfigValue<Boolean> generateVolcanos;
    @ConfigProperty(needsSync=true, internalType=Boolean.class)
    public ForgeConfigSpec.ConfigValue<Boolean> experimentalSpaceFlight;

    public static void register() {
        ARConfiguration.registerConfig(ModConfig.Type.COMMON, commonSpec, "advancedRocketry.toml");
    }

    private static void registerConfig(ModConfig.Type type, ForgeConfigSpec spec, String fileName) {
        AdvancedRocketry.MOD_CONTAINER.addConfig(new ModConfig(type, spec, AdvancedRocketry.MOD_CONTAINER, fileName));
    }

    private ARConfiguration() {
    }

    public ARConfiguration(ForgeConfigSpec.Builder builder) {
        currentConfig = new ARConfiguration();
        String CATEGORY_GENERAL = "General";
        ARConfiguration arConfig = ARConfiguration.getCurrentConfig();
        builder.push("General");
        arConfig.allowMakingItemsForOtherMods = builder.comment("If true, the machines from AdvancedRocketry will produce things like plates/rods for other mods even if Advanced Rocketry itself does not use the material (This can increase load time)").define("makeMaterialsForOtherMods", true);
        arConfig.allowSawmillVanillaWood = builder.comment("Should the cutting machine be able to cut vanilla wood into planks").define("sawMillCutVanillaWood", true);
        arConfig.lowGravityBoots = builder.comment("If true, the boots only protect the player on planets with low gravity").define("lowGravityBoots", false);
        arConfig.jetPackThrust = builder.comment("Amount of force the jetpack provides with respect to gravity").define("jetPackForce", (Object)1.3);
        arConfig.buildSpeedMultiplier = builder.comment("Multiplier for the build speed of the Rocket Builder (0.5 is twice as fast 2 is half as fast").define("buildSpeedMultiplier", (Object)1.0);
        arConfig.blockTankCapacity = builder.comment("Multiplier for the amount of fluid this tank can hold").define("blockTankCapacity", (Object)1.0);
        arConfig.crystalliserMaximumGravity = builder.comment("Maximum gravity the crystallizer can work at. 0 to disable!").define("crystalliserMaximumGravity", (Object)0);
        arConfig.enableGravityController = builder.comment("If false, the gravity controller cannot be built or used").define("enableGravityMachine", true);
        builder.push(CATEGORY_LASERDRILL);
        arConfig.enableLaserDrill = builder.comment("Enables the laser drill machine").define("EnableLaserDrill", true);
        arConfig.spaceLaserPowerMult = builder.comment("Power multiplier for the laser drill machine").define("LaserDrillPowerMultiplier", (Object)1.0);
        LinkedList<String> laserOreList = new LinkedList<String>();
        laserOreList.add("oreIron");
        laserOreList.add("oreGold");
        laserOreList.add("oreCopper");
        laserOreList.add("oreTin");
        laserOreList.add("oreRedstone");
        laserOreList.add("oreDiamond");
        orbitalLaserOres = builder.comment("List of oredictionary names of ores allowed to be mined by the laser drill if surface drilling is disabled.  Ores can be specified by just the oreName:<size> or by <modname>:<blockname>:<meta>:<size> where size is optional").defineList("laserDrillOres", laserOreList, val -> true);
        arConfig.laserDrillOresBlackList = builder.comment("True if the ores in laserDrillOres should be a blacklist, false for a whitelist").define("laserDrillOres_blacklist", false);
        arConfig.laserDrillPlanet = builder.comment("If true, the orbital laser will actually mine blocks on the planet below").define("laserDrillPlanet", false);
        arConfig.laserBlackListDims = builder.comment("Laser drill will not mine these dimension").defineList("spaceLaserDimIdBlackList", new LinkedList(), val -> true);
        builder.push(CATEGORY_TERRAFORMING);
        arConfig.enableTerraforming = builder.comment("Enables terraforming items and blocks").define("EnableTerraforming", true);
        arConfig.allowTerraforming = builder.comment("EXPERIMENTAL: If set to true allows contruction and usage of the terraformer.  This is known to cause strange world generation after successful terraform").define("allowTerraforming", false);
        arConfig.terraformingBlockSpeed = builder.comment("How many blocks have the biome changed per tick.  Large numbers can slow the server down").define("biomeUpdateSpeed", (Object)1);
        arConfig.terraformSpeed = builder.comment("Multplier for atmosphere change speed").define("terraformMult", (Object)1.0);
        arConfig.terraformPlanetSpeed = builder.comment("Max number of blocks allowed to be changed per tick").define("terraformBlockPerTick", (Object)1);
        arConfig.terraformRequiresFluid = builder.define("TerraformerRequiresFluids", true);
        arConfig.terraformliquidRate = builder.comment("how many millibuckets/t are required to keep the terraformer running").define("TerraformerFluidConsumeRate", (Object)40);
        arConfig.allowTerraformNonAR = builder.comment("If true, dimensions not added by AR can be terraformed").define("allowTerraformingNonARWorlds", false);
        builder.push(CATEGORY_OXYGEN);
        arConfig.enableOxygen = builder.comment("If true, allows players being hurt due to lack of oxygen and allows effects from non-standard atmosphere types").define("EnableAtmosphericEffects", true);
        arConfig.scrubberRequiresCartrige = builder.comment("If true, the Oxygen scrubbers require a consumable carbon collection cartridge").define("scrubberRequiresCartrige", true);
        arConfig.vacuumDamageValue = builder.comment("Amount of damage inflicted with each tick on an entity in a vacuum").defineInRange("vacuumDamage", 1, 0, 100);
        arConfig.oxygenVentPowerMultiplier = builder.comment("Power consumption multiplier for the oxygen vent").define("OxygenVentPowerMultiplier", (Object)1.0);
        arConfig.spaceSuitOxygenTime = builder.comment("Maximum time in minutes that the spacesuit's internal buffer can store O2 for").define("spaceSuitO2Buffer", (Object)30);
        arConfig.dropExTorches = builder.comment("If true, breaking an extinguished torch will drop an extinguished torch instead of a vanilla torch").define("dropExtinguishedTorches", false);
        arConfig.overrideGCAir = builder.comment("If true, Galacticcraft's air will be disabled entirely requiring use of Advanced Rocketry's Oxygen system on GC planets").define("OverrideGCAir", true);
        arConfig.oxygenVentConsumptionMult = builder.comment("Multiplier on how much O2 an oxygen vent consumes per tick").define("oxygenVentConsumptionMultiplier", (Object)1.0);
        arConfig.suitTankCapacity = builder.comment("Multiplier for the amount of fluid this tank can hold").define("suitTankMultiplier", (Object)1.0);
        sealableBlockWhiteList = builder.comment("Blocks that are not automatically detected as sealable but should seal.  Format \"Mod:Blockname\"  for example \"minecraft:chest\"").defineList("sealableBlockWhiteList", new LinkedList(), val -> true);
        sealableBlockBlackList = builder.comment("Blocks that are automatically detected as sealable but should not seal.  Format \"Mod:Blockname\"  for example \"minecraft:chest\"").defineList("sealableBlockBlackList", new LinkedList(), val -> true);
        entityList = builder.comment("list entities which should not be affected by atmosphere properties").defineList("entityAtmBypass", new LinkedList(), val -> true);
        breakableTorches = builder.comment("Mod:Blockname  for example \"minecraft:chest\"").define("torchBlocks", new LinkedList(), val -> true);
        builder.push(CATEGORY_STATION);
        arConfig.spaceDimId = builder.comment("Dimension ID to use for space stations, changing this could really break things!").define("spaceStationId", (Object)"advancedrocketry:space");
        arConfig.travelTimeMultiplier = builder.comment("Multiplier for warp travel time").define("warpTravelTime", (Object)1.0);
        arConfig.stationSize = builder.comment("The largest size a space station can be.  Should also be a power of 2 (512)").define("SpaceStationBuildRadius", (Object)1024);
        arConfig.allowZeroGSpacestations = builder.comment("If true, players will be able to completely disable gravity on spacestation.  It's possible to get stuck and require a teleport").define("allowZeroGSpacestations", false);
        arConfig.fuelPointsPerDilithium = builder.comment("How many units of fuel should each Dilithium Crystal give to warp ships").define("pointsPerDilithium", (Object)500);
        builder.push(CATEGORY_RESOURCE_MISSION);
        arConfig.gasCollectionMult = builder.comment("Multiplier for the amount of time gas collection missions take").define("gasMissionMultiplier", (Object)1.0);
        arConfig.asteroidMiningTimeMult = builder.comment("Multiplier changing how long a mining mission takes").define("miningMissionTmeMultiplier", (Object)1.0);
        harvestableGasses = builder.comment("list of fluid names that can be harvested as Gas").defineList("harvestableGasses", new LinkedList(), val -> true);
        builder.push(CATEGORY_ENERGY);
        arConfig.solarGeneratorMult = builder.comment("Amount of power per tick the solar generator should produce").define("solarGeneratorMultiplier", (Object)1);
        arConfig.microwaveRecieverMulitplier = builder.comment("Multiplier for the amount of energy produced by the microwave reciever").define("MicrowaveRecieverMultiplier", (Object)1.0);
        arConfig.blackHolePowerMultiplier = builder.comment("Multiplier for the amount of power per tick the black hole generator should produce").define("blackHoleGeneratorMultiplier", (Object)Float.valueOf(1.0f));
        LinkedList<String> blackHoleGen = new LinkedList<String>();
        blackHoleGen.add("minecraft:stone;1");
        blackHoleGen.add("minecraft:dirt;1");
        blackHoleGen.add("minecraft:netherrack;1");
        blackHoleGen.add("minecraft:cobblestone;1");
        blackHoleGeneratorTiming = builder.comment("minecraft:dirt;1").defineList("blackHoleTimings", blackHoleGen, val -> true);
        arConfig.defaultItemTimeBlackHole = builder.comment("List of blocks and the amount of ticks they can power the black hole generator format: 'modname:block:meta;number_of_ticks'").define("defaultBurnTime", (Object)500);
        builder.push(CATEGORY_PLANET);
        arConfig.maxBiomesPerPlanet = builder.comment("Maximum unique biomes per planet").define("maxBiomesPerPlanet", (Object)5);
        arConfig.resetFromXML = builder.comment("setting this to true will force AR to read from the XML file in the config/advRocketry instead of the local data, intended for use pack developers to ensure updates are pushed through").define("resetPlanetsFromXML", false);
        arConfig.canPlayerRespawnInSpace = builder.comment("If true, players will respawn near beds on planets IF the spawn location is in a breathable atmosphere").define("allowPlanetRespawn", false);
        arConfig.forcePlayerRespawnInSpace = builder.comment("If true, players will respawn near beds on planets REGARDLESS of the spawn location being in a non-breathable atmosphere. Requires 'allowPlanetRespawn' being true.").define("forcePlanetRespawn", false);
        arConfig.planetsMustBeDiscovered = builder.comment("If true, planets must be discovered in the warp controller before being visible").define("planetsMustBeDiscovered", false);
        arConfig.blackListAllVanillaBiomes = builder.comment("Prevents any vanilla biomes from spawning on planets").define("blackListVanillaBiomes", false);
        arConfig.planetDiscoveryChance = builder.comment("Chance of planet discovery in the warp ship monitor is not all planets are initially discovered").define("planetDiscoveryChance", (Object)5);
        builder.push(CATEGORY_CLIENT);
        arConfig.enableNausea = builder.comment("If true, allows players to experience nausea on non-standard atmosphere types").define("EnableAtmosphericNausea", true);
        arConfig.stationSkyOverride = builder.comment("If true, AR will use a custom skybox on space stations").define("StationSkyOverride", true);
        arConfig.planetSkyOverride = builder.comment("If true, AR will use a custom skybox on planets").define("PlanetSkyOverride", true);
        arConfig.skyOverride = builder.define("overworldSkyOverride", true);
        arConfig.advancedVFX = builder.comment("Advanced visual effects").define("advancedVFX", true);
        arConfig.lockUI = builder.comment("If UI is not locked, the middle mouse can be used to drag certain AR UIs around the screen, positions are saved on hitting quit in the menu").define("lockUI", true);
        builder.push(CATEGORY_PERFORMANCE);
        arConfig.atmosphereHandleBitMask = builder.comment("BitMask: 0: no threading, radius based; 1: threading, radius based; 2: no threading volume based; 3: threading volume based").define("atmosphereCalculationMethod", (Object)3);
        arConfig.oxygenVentSize = builder.comment("Radius of the O2 vent.  if atmosphereCalculationMethod is 2 or 3 then max volume is calculated from this radius.  WARNING: larger numbers can lead to lag").define("oxygenVentSize", (Object)32);
        builder.push(CATEGORY_ROCKET);
        arConfig.orbit = builder.comment("How high the rocket has to go before it reaches orbit").defineInRange("OrbitHeight", 1000, 255, Integer.MAX_VALUE);
        LinkedList<String> fuels = new LinkedList<String>();
        fuels.add("advancedrocketry:rocket_fuel;2");
        liquidMonopropellant = builder.comment("List of fluid names for fluids that can be used as rocket monopropellants").defineList("rocketFuels", fuels, val -> true);
        LinkedList<String> bifuels = new LinkedList<String>();
        bifuels.add("advancedrocketry:hydrogen");
        liquidBipropellantFuel = builder.comment("List of fluid names for fluids that can be used as rocket bipropellant fuels").defineList("rocketBipropellants", bifuels, val -> true);
        LinkedList<String> bioxydizers = new LinkedList<String>();
        bioxydizers.add("oxygen");
        liquidBipropellantOxidizer = builder.comment("List of fluid names for fluids that can be used as rocket bipropellant oxidizers").defineList("rocketBipropellants", bioxydizers, val -> true);
        arConfig.automaticRetroRockets = builder.comment("Setting to false will disable the retrorockets that fire automatically on reentry on both player and automated rockets").define("autoRetroRockets", true);
        arConfig.gravityAffectsFuel = builder.comment("If true, planets with higher gravity require more fuel and lower gravity would require less").define("gravityAffectsFuels", true);
        arConfig.experimentalSpaceFlight = builder.comment("If true, rockets will be able to actually fly around space").define("experimentalSpaceFlight", false);
        arConfig.rocketRequireFuel = builder.comment("Set to false if rockets should not require fuel to fly").define("rocketsRequireFuel", true);
        arConfig.canBeFueledByHand = builder.comment("Set to false if rockets should not be able to be fueled by and and will require a fueling station").define("canBeFueledByHand", true);
        arConfig.rocketThrustMultiplier = builder.comment("Multiplier for per-engine thrust").define("thrustMultiplier", (Object)1.0);
        arConfig.fuelCapacityMultiplier = builder.comment("Multiplier for per-tank capacity").define("fuelCapacityMultiplier", (Object)1.0);
        LinkedList<String> blackListRocketBlocksStrList = new LinkedList<String>();
        blackListRocketBlocksStrList.add("minecraft:portal");
        blackListRocketBlocksStrList.add("minecraft:bedrock");
        blackListRocketBlocksStrList.add("minecraft:snow_layer");
        blackListRocketBlocksStrList.add("minecraft:flowing_water");
        blackListRocketBlocksStrList.add("minecraft:lava");
        blackListRocketBlocksStrList.add("minecraft:flowing_lava");
        blackListRocketBlocksStr = builder.comment("Mod:Blockname  for example \"minecraft:chest\"").defineList("rocketBlockBlackList", blackListRocketBlocksStrList, val -> true);
        arConfig.launchingDestroysBlocks = builder.comment("Set to false if rockets should not damage blocks").define("rocketsDamageBlocks", false);
        arConfig.stationClearanceHeight = builder.comment("How high the rocket has to go before it reaches station clearance").defineInRange("stationClearanceHeight", 1000, 255, Integer.MAX_VALUE);
        arConfig.asteroidTBIBurnMult = builder.comment("TBI multiplier for asteroid flights").define("asteroidTBIBurnMult", (Object)1.0);
        arConfig.transBodyInjection = builder.comment("How long transbody injection is before the rocket can exit").define("transBodyInjection", (Object)0);
        arConfig.warpTBIBurnMult = builder.comment("TBI multiplier for warp flights").define("warpTBIBurnMult", (Object)10.0);
        builder.push(CATEGORY_WORLD_GENERATION);
        arConfig.electricPlantsSpawnLightning = builder.comment("Should Electric Mushrooms be able to spawn lightning").define("electricPlantsSpawnLightning", true);
        LinkedList<String> geodeOresList = new LinkedList<String>();
        geodeOresList.add(Blocks.field_150366_p.getRegistryName().toString());
        geodeOresList.add(Blocks.field_150352_o.getRegistryName().toString());
        geodeOresList.add("libvulpes:orecopper");
        geodeOresList.add("libvulpes:oretin");
        geodeOresList.add(Blocks.field_150450_ax.getRegistryName().toString());
        geodeOres = builder.comment("List of block names of blocks (usally ores) allowed to spawn in geodes").defineList("geodeOres", geodeOresList, val -> true);
        arConfig.geodeOresBlackList = builder.comment("True if the ores in geodeOres should be a blacklist").define("geodeOres_blacklist", false);
        arConfig.generateGeodes = builder.comment("If true, then ore-containing geodes are generated on high pressure planets").define("generateGeodes", true);
        arConfig.geodeBaseSize = builder.comment("average size of the geodes").define("geodeBaseSize", (Object)36);
        arConfig.geodeVariation = builder.comment("variation in geode size").define("geodeVariation", (Object)24);
        arConfig.generateCraters = builder.comment("If true, then low pressure planets will have meteor craters.  Note: setting this option to false overrides 'generageCraters' in the planetDefs.xml").define("generateCraters", true);
        arConfig.generateVolcanos = builder.comment("If true, then very hot planets planets will volcanos.  Note: setting this option to false overrides 'generateVolcanos' in the planetDefs.xml").define("generateVolcanos", true);
        arConfig.generateVanillaStructures = builder.comment("Enable to allow structures like villages and mineshafts to generate on planets with a breathable atmosphere.  Note, setting this to false will override 'generateStructures' in the planetDefs.xml").define("generateVanillaStructures", false);
        LinkedList<String> blackListedbiomes = new LinkedList<String>();
        blackListedbiomes.add(Biomes.field_76781_i.func_240901_a_().toString());
        blackListedbiomes.add(Biomes.field_76779_k.func_240901_a_().toString());
        blackListedbiomes.add(Biomes.field_150589_Z.func_240901_a_().toString());
        blackListedbiomes.add(Biomes.field_185440_P.func_240901_a_().toString());
        biomeBlackList = builder.comment("List of Biomes to be blacklisted from spawning as BiomeIds, default is: river, sky, hell, void, alienForest").defineList("BlacklistedBiomes", blackListedbiomes, item -> true);
        LinkedList highPressureBiome = new LinkedList();
        biomeHighPressure = builder.comment("Biomes that only spawn on worlds with pressures over 125, will override blacklist.").defineList("HighPressureBiomes", highPressureBiome, item -> true);
        LinkedList<String> singleBiomes = new LinkedList<String>();
        singleBiomes.add(Biomes.field_76786_s.func_240901_a_().toString());
        singleBiomes.add(Biomes.field_76789_p.func_240901_a_().toString());
        singleBiomes.add(Biomes.field_185429_aa.func_240901_a_().toString());
        singleBiomes.add(Biomes.field_185445_W.func_240901_a_().toString());
        biomeSingle = builder.comment("Some worlds have a chance of spawning single biomes contained in this list.").defineList("SingleBiomes", singleBiomes, item -> true);
        ForgeConfigSpec.BooleanValue masterToggle = builder.define("EnableOreGen", true);
        arConfig.generateCopper = builder.define("GenerateCopper", true);
        arConfig.copperClumpSize = builder.define("CopperPerClump", (Object)6);
        arConfig.copperPerChunk = builder.define("CopperPerChunk", (Object)10);
        arConfig.generateTin = builder.define("GenerateTin", true);
        arConfig.tinClumpSize = builder.define("TinPerClump", (Object)6);
        arConfig.tinPerChunk = builder.define("TinPerChunk", (Object)10);
        arConfig.generateDilithium = builder.define("generateDilithium", true);
        arConfig.dilithiumClumpSize = builder.define("DilithiumPerClump", (Object)16);
        arConfig.dilithiumPerChunk = builder.define("DilithiumPerChunk", (Object)1);
        arConfig.dilithiumPerChunkMoon = builder.define("DilithiumPerChunkLuna", (Object)10);
        arConfig.generateAluminum = builder.define("generateAluminum", true);
        arConfig.aluminumClumpSize = builder.define("AluminumPerClump", (Object)16);
        arConfig.aluminumPerChunk = builder.define("AluminumPerChunk", (Object)1);
        arConfig.generateIridium = builder.define("generateIridium", false);
        arConfig.IridiumClumpSize = builder.define("IridiumPerClump", (Object)16);
        arConfig.IridiumPerChunk = builder.define("IridiumPerChunk", (Object)1);
        arConfig.generateRutile = builder.define("GenerateRutile", true);
        arConfig.rutileClumpSize = builder.define("RutilePerClump", (Object)6);
        arConfig.rutilePerChunk = builder.define("RutilePerChunk", (Object)6);
    }

    public ARConfiguration(ARConfiguration config) {
        Field[] fields = ARConfiguration.class.getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>(fields.length);
        for (Field field : fields) {
            if (!field.isAnnotationPresent(ConfigProperty.class)) continue;
            fieldList.add(field);
        }
        fieldList.sort(new Comparator<Field>(){

            @Override
            public int compare(Field arg0, Field arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        for (Field field : fieldList) {
            try {
                if (field.getClass().isAssignableFrom(List.class)) {
                    List otherList = (List)field.get(config);
                    List list = (List)otherList.getClass().newInstance();
                    list.addAll(otherList);
                    field.set(this, list);
                    continue;
                }
                if (field.getClass().isAssignableFrom(Map.class)) {
                    Map otherMap = (Map)field.get(config);
                    Map map = (Map)otherMap.getClass().newInstance();
                    for (Object key : otherMap.keySet()) {
                        Object value = otherMap.get(key);
                        map.put(key, value);
                    }
                    field.set(this, map);
                    continue;
                }
                field.set(this, field.get(config));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeConfigToNetwork(PacketBuffer out) {
        Field[] fields = ARConfiguration.class.getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>(fields.length);
        for (Field field : fields) {
            if (!field.isAnnotationPresent(ConfigProperty.class) || !field.getAnnotation(ConfigProperty.class).needsSync()) continue;
            fieldList.add(field);
        }
        fieldList.sort(new Comparator<Field>(){

            @Override
            public int compare(Field arg0, Field arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        try {
            for (Field field : fieldList) {
                ConfigProperty props = field.getAnnotation(ConfigProperty.class);
                int hash = field.getName().hashCode();
                out.writeInt(hash);
                try {
                    this.writeDatum(out, field.getType(), field.get(this), props);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvalidClassException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            out.writeByte(-59);
            out.writeLong(0x2AAAAAAAAABL);
        }
    }

    private void writeDatum(PacketBuffer out, Class type, Object value, ConfigProperty property) throws InvalidClassException {
        if (Integer.class.isAssignableFrom(type) || type == Integer.TYPE) {
            out.writeInt(((Integer)value).intValue());
        } else if (ForgeConfigSpec.ConfigValue.class.isAssignableFrom(type)) {
            this.writeDatum(out, ((ForgeConfigSpec.ConfigValue)value).get().getClass(), ((ForgeConfigSpec.ConfigValue)value).get(), property);
        } else if (Float.class.isAssignableFrom(type) || type == Float.TYPE) {
            out.writeFloat(((Float)value).floatValue());
        } else if (Double.class.isAssignableFrom(type) || type == Double.TYPE) {
            out.writeDouble(((Double)value).doubleValue());
        } else if (Boolean.class.isAssignableFrom(type) || type == Boolean.TYPE) {
            out.writeBoolean(((Boolean)value).booleanValue());
        } else if (AsteroidSmall.class.isAssignableFrom(type)) {
            AsteroidSmall asteroid = (AsteroidSmall)value;
            out.func_180714_a(asteroid.ID);
            out.writeInt(asteroid.distance);
            out.writeInt(asteroid.mass);
            out.writeInt(asteroid.minLevel);
            out.writeFloat(asteroid.massVariability);
            out.writeFloat(asteroid.richness);
            out.writeFloat(asteroid.richnessVariability);
            out.writeFloat(asteroid.probability);
            out.writeFloat(asteroid.timeMultiplier);
            out.writeInt(asteroid.stackProbabilites.size());
            for (int i = 0; i < asteroid.stackProbabilites.size(); ++i) {
                out.func_150788_a(asteroid.itemStacks.get(i));
                out.writeFloat(asteroid.stackProbabilites.get(i).floatValue());
            }
        } else if (ResourceLocation.class.isAssignableFrom(type)) {
            out.func_192572_a((ResourceLocation)value);
        } else if (String.class.isAssignableFrom(type)) {
            out.func_180714_a((String)value);
        } else if (List.class.isAssignableFrom(type)) {
            List list = (List)value;
            out.writeShort(list.size());
            for (Object o : list) {
                this.writeDatum(out, property.internalType(), o, property);
            }
        } else if (Set.class.isAssignableFrom(type)) {
            Set list = (Set)value;
            out.writeShort(list.size());
            for (Object o : list) {
                this.writeDatum(out, property.internalType(), o, property);
            }
        } else if (Map.class.isAssignableFrom(type)) {
            Map map = (Map)value;
            out.writeInt(map.size());
            for (Object key : map.keySet()) {
                Object mapValue = map.get(key);
                this.writeDatum(out, property.keyType(), key, property);
                this.writeDatum(out, property.valueType(), mapValue, property);
            }
        } else {
            throw new InvalidClassException("Cannot transmit class type " + type.getName());
        }
    }

    private Object readDatum(PacketBuffer in, Class type, ConfigProperty property) throws InvalidClassException, InstantiationException, IllegalAccessException {
        if (Integer.class.isAssignableFrom(type) || type == Integer.TYPE) {
            return in.readInt();
        }
        if (ForgeConfigSpec.ConfigValue.class.isAssignableFrom(type)) {
            return this.readDatum(in, property.internalType(), property);
        }
        if (Float.class.isAssignableFrom(type) || type == Float.TYPE) {
            return Float.valueOf(in.readFloat());
        }
        if (Double.class.isAssignableFrom(type) || type == Double.TYPE) {
            return in.readDouble();
        }
        if (Boolean.TYPE.isAssignableFrom(type) || type == Boolean.TYPE) {
            return in.readBoolean();
        }
        if (ResourceLocation.class.isAssignableFrom(type)) {
            return in.func_192575_l();
        }
        if (String.class.isAssignableFrom(type)) {
            return in.func_150789_c(256);
        }
        if (AsteroidSmall.class.isAssignableFrom(type)) {
            AsteroidSmall asteroid = new AsteroidSmall();
            asteroid.ID = in.func_150789_c(128);
            asteroid.distance = in.readInt();
            asteroid.mass = in.readInt();
            asteroid.minLevel = in.readInt();
            asteroid.massVariability = in.readFloat();
            asteroid.richness = in.readFloat();
            asteroid.richnessVariability = in.readFloat();
            asteroid.probability = in.readFloat();
            asteroid.timeMultiplier = in.readFloat();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                asteroid.itemStacks.add(in.func_150791_c());
                asteroid.stackProbabilites.add(Float.valueOf(in.readFloat()));
            }
            return asteroid;
        }
        if (List.class.isAssignableFrom(type)) {
            List list = (List)type.newInstance();
            int listsize = in.readShort();
            for (int i = 0; i < listsize; ++i) {
                list.add(this.readDatum(in, property.internalType(), property));
            }
            return list;
        }
        if (Set.class.isAssignableFrom(type)) {
            Set set = (Set)type.newInstance();
            int listsize = in.readShort();
            for (int i = 0; i < listsize; ++i) {
                set.add(this.readDatum(in, property.internalType(), property));
            }
            return set;
        }
        if (Map.class.isAssignableFrom(type)) {
            Map map = (Map)type.newInstance();
            int mapCount = in.readInt();
            for (int i = 0; i < mapCount; ++i) {
                Object key = this.readDatum(in, property.keyType(), property);
                Object value = this.readDatum(in, property.valueType(), property);
                map.put(key, value);
            }
            return map;
        }
        throw new InvalidClassException("Cannot transmit class type " + type.getName());
    }

    public ARConfiguration readConfigFromNetwork(PacketBuffer in) {
        Field[] fields = ARConfiguration.class.getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>(fields.length);
        for (Field field : fields) {
            if (!field.isAnnotationPresent(ConfigProperty.class) || !field.getAnnotation(ConfigProperty.class).needsSync()) continue;
            fieldList.add(field);
        }
        fieldList.sort(new Comparator<Field>(){

            @Override
            public int compare(Field arg0, Field arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        for (Field field : fieldList) {
            ConfigProperty props = field.getAnnotation(ConfigProperty.class);
            int hash = field.getName().hashCode();
            if (hash != in.readInt()) {
                return this;
            }
            try {
                Object data = this.readDatum(in, field.getType(), props);
                field.set(this, data);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvalidClassException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        while (in.readByte() != -59 && in.readLong() == 0x2AAAAAAAAABL) {
        }
        return this;
    }

    public static ARConfiguration getCurrentConfig() {
        if (currentConfig == null) {
            logger.error("Had to generate a new config, this shouldn't happen");
            throw new NullPointerException("Expected config to not be null");
        }
        return currentConfig;
    }

    public static ResourceLocation GetSpaceDimId() {
        return new ResourceLocation((String)ARConfiguration.getCurrentConfig().spaceDimId.get());
    }

    public static void loadConfigFromServer(ARConfiguration config) throws Exception {
        if (usingServerConfig) {
            throw new IllegalStateException("Cannot load server config when already using server config!");
        }
        diskConfig = currentConfig;
        currentConfig = config;
        usingServerConfig = true;
    }

    public static void useClientDiskConfig() {
        if (usingServerConfig) {
            currentConfig = diskConfig;
            usingServerConfig = false;
        }
    }

    public void save() {
        if (!usingServerConfig) {
            for (ForgeConfigSpec.ConfigValue<?> value : allConfigValues) {
                value.save();
            }
        }
    }

    public void addTorchblock(Block newblock) {
        this.torchBlocks.add(newblock);
        ArrayList<String> blocks = new ArrayList<String>(this.torchBlocks.size());
        boolean index = false;
        for (Block block : this.torchBlocks) {
            blocks.add(block.getRegistryName().toString());
        }
        breakableTorches.set(blocks);
        breakableTorches.save();
    }

    public void addSealedBlock(Block newblock) {
        SealableBlockHandler.INSTANCE.addSealableBlock(newblock);
        List<Block> blockList = SealableBlockHandler.INSTANCE.getOverridenSealableBlocks();
        ArrayList<String> blocks = new ArrayList<String>(blockList.size());
        boolean index = false;
        for (Block block : blockList) {
            blocks.add(block.getRegistryName().toString());
        }
        sealableBlockWhiteList.set(blocks);
        sealableBlockWhiteList.save();
        this.save();
    }

    public static void loadPostInit() {
        Block block;
        float multiplier;
        Fluid fluid;
        String[] splitStr;
        ARConfiguration arConfig = ARConfiguration.getCurrentConfig();
        logger.info("Start registering liquid rocket fuels");
        for (String str : (List)liquidMonopropellant.get()) {
            splitStr = str.split(";");
            fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.func_208304_a((String)splitStr[0]));
            multiplier = 1.0f;
            if (splitStr.length > 1) {
                multiplier = Float.parseFloat(splitStr[1]);
            }
            if (fluid != null) {
                logger.info("Registering fluid " + str + " as rocket monopropellant");
                FuelRegistry.instance.registerFuel(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, fluid, multiplier);
                continue;
            }
            logger.warn("Fluid name" + str + " is not a registered fluid!");
        }
        liquidMonopropellant = null;
        for (String str : (List)liquidBipropellantFuel.get()) {
            splitStr = str.split(";");
            fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.func_208304_a((String)splitStr[0]));
            multiplier = 1.0f;
            if (splitStr.length > 1) {
                multiplier = Float.parseFloat(splitStr[1]);
            }
            if (fluid != null) {
                logger.info("Registering fluid " + str + " as rocket bipropellant");
                FuelRegistry.instance.registerFuel(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, fluid, multiplier);
                continue;
            }
            logger.warn("Fluid name" + str + " is not a registered fluid!");
        }
        liquidBipropellantFuel = null;
        for (String str : (List)liquidBipropellantOxidizer.get()) {
            splitStr = str.split(";");
            fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.func_208304_a((String)splitStr[0]));
            multiplier = 1.0f;
            if (splitStr.length > 1) {
                multiplier = Float.parseFloat(splitStr[1]);
            }
            if (fluid != null) {
                logger.info("Registering fluid " + str + " as rocket oxidizer");
                FuelRegistry.instance.registerFuel(FuelRegistry.FuelType.LIQUID_OXIDIZER, fluid, multiplier);
                continue;
            }
            logger.warn("Fluid name" + str + " is not a registered fluid!");
        }
        liquidBipropellantOxidizer = null;
        logger.info("Finished registering liquid rocket fuels");
        logger.info("Start registering sealable blocks (sealableBlockWhiteList)");
        for (String str : (List)sealableBlockWhiteList.get()) {
            block = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.func_208304_a((String)str));
            if (block == null) {
                logger.warn("'" + str + "' is not a valid Block");
                continue;
            }
            SealableBlockHandler.INSTANCE.addSealableBlock(block);
        }
        logger.info("End registering sealable blocks");
        sealableBlockWhiteList = null;
        logger.info("Start registering unsealable blocks (sealableBlockBlackList)");
        for (String str : (List)sealableBlockBlackList.get()) {
            block = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.func_208304_a((String)str));
            if (block == null) {
                logger.warn("'" + str + "' is not a valid Block");
                continue;
            }
            SealableBlockHandler.INSTANCE.addUnsealableBlock(block);
        }
        logger.info("End registering unsealable blocks");
        sealableBlockBlackList = null;
        logger.info("Start registering torch blocks");
        for (String str : (List)breakableTorches.get()) {
            block = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.func_208304_a((String)str));
            if (block == null) {
                logger.warn("'" + str + "' is not a valid Block");
                continue;
            }
            arConfig.torchBlocks.add(block);
        }
        logger.info("End registering torch blocks");
        breakableTorches = null;
        logger.info("Start registering blackhole generator blocks");
        for (String str : (List)blackHoleGeneratorTiming.get()) {
            splitStr = str.split(";");
            String[] blockString = splitStr[0].split(":");
            Item block2 = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(blockString[0], blockString[1]));
            int metaValue = 0;
            if (blockString.length > 2) {
                try {
                    metaValue = Integer.parseInt(blockString[2]);
                }
                catch (NumberFormatException e) {
                    logger.warn("Invalid meta value location for black hole generator: " + splitStr[0] + " using " + blockString[2]);
                }
            }
            int time = 0;
            try {
                time = Integer.parseInt(splitStr[1]);
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid time value for black hole generator: " + str);
            }
            if (block2 == null) {
                logger.warn("'" + splitStr[0] + "' is not a valid Block");
                continue;
            }
            arConfig.blackHoleGeneratorBlocks.put(new ItemStack((IItemProvider)block2, 1), time);
        }
        logger.info("End registering blackhole generator blocks");
        breakableTorches = null;
        logger.info("Start registering rocket blacklist blocks");
        for (String str : (List)blackListRocketBlocksStr.get()) {
            block = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.func_208304_a((String)str));
            if (block == null) {
                logger.warn("'" + str + "' is not a valid Block");
                continue;
            }
            arConfig.blackListRocketBlocks.add(block);
        }
        logger.info("End registering rocket blacklist blocks");
        blackListRocketBlocksStr = null;
        logger.info("Start registering Harvestable Gasses");
        for (String str : (List)harvestableGasses.get()) {
            Fluid fluid2 = (Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.func_208304_a((String)str));
            if (fluid2 == null) {
                logger.warn("'" + str + "' is not a valid Fluid");
                continue;
            }
            AtmosphereRegister.getInstance().registerHarvestableFluid(fluid2);
        }
        logger.info("End registering Harvestable Gasses");
        harvestableGasses = null;
        logger.info("Start registering entity atmosphere bypass");
        arConfig.bypassEntity.add(EntityType.field_200789_c);
        for (String str : (List)entityList.get()) {
            EntityType.func_220327_a((String)str).ifPresent(value -> arConfig.bypassEntity.add((EntityType)value));
            Optional entityType = EntityType.func_220327_a((String)str);
            if (entityType.isPresent()) {
                logger.info("Registering " + str + " for atmosphere bypass");
                EntityType.func_220327_a((String)str).ifPresent(value -> arConfig.bypassEntity.add((EntityType)value));
                continue;
            }
            logger.warn("Cannot find " + str + " while registering entity for atmosphere bypass");
        }
        entityList = null;
        logger.info("End registering entity atmosphere bypass");
        if (!((Boolean)arConfig.geodeOresBlackList.get()).booleanValue()) {
            for (String str : (List)geodeOres.get()) {
                arConfig.standardGeodeOres.add(ResourceLocation.func_208304_a((String)str));
            }
            while (arConfig.standardGeodeOres.remove(null)) {
            }
        }
        if (!((Boolean)arConfig.laserDrillOresBlackList.get()).booleanValue()) {
            for (String str : (List)orbitalLaserOres.get()) {
                arConfig.standardLaserDrillOres.add(str);
            }
            while (arConfig.standardLaserDrillOres.remove(null)) {
            }
        }
        for (ResourceLocation oreName : BlockTags.func_199896_a().func_199908_a()) {
            boolean found;
            if (((Boolean)arConfig.geodeOresBlackList.get()).booleanValue() && oreName.func_110623_a().startsWith("ore")) {
                found = false;
                for (String str : (List)geodeOres.get()) {
                    if (!oreName.equals((Object)str)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    arConfig.standardGeodeOres.add(oreName);
                }
            }
            if (!((Boolean)arConfig.laserDrillOresBlackList.get()).booleanValue() || !oreName.func_110623_a().startsWith("ore")) continue;
            found = false;
            for (String str : (List)orbitalLaserOres.get()) {
                if (!oreName.equals((Object)str)) continue;
                found = true;
                break;
            }
            if (found) continue;
            arConfig.standardLaserDrillOres.add(oreName.toString());
        }
    }

    static {
        usingServerConfig = false;
        allConfigValues = new LinkedList();
        Pair commonConfiguration = new ForgeConfigSpec.Builder().configure(ARConfiguration::new);
        commonSpec = (ForgeConfigSpec)commonConfiguration.getRight();
        ARConfiguration aRConfiguration = (ARConfiguration)commonConfiguration.getLeft();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ConfigProperty {
        public boolean needsSync() default false;

        public Class internalType() default Object.class;

        public Class keyType() default Object.class;

        public Class valueType() default Object.class;
    }
}

