/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api;

import com.mojang.serialization.Codec;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ConfiguredCarvers;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.world.ChunkProviderPlanet;
import zmaster587.advancedRocketry.world.ChunkProviderSpace;
import zmaster587.advancedRocketry.world.CustomPlanetBiomeProvider;
import zmaster587.advancedRocketry.world.decoration.MapGenInvertedPillar;
import zmaster587.advancedRocketry.world.decoration.MapGenSwampTree;
import zmaster587.advancedRocketry.world.decoration.StructureCrater;
import zmaster587.advancedRocketry.world.decoration.StructureGeode;
import zmaster587.advancedRocketry.world.decoration.StructurePieceCrater;
import zmaster587.advancedRocketry.world.decoration.StructurePieceGeode;
import zmaster587.advancedRocketry.world.decoration.StructurePieceVolcano;
import zmaster587.advancedRocketry.world.decoration.StructureVolcano;
import zmaster587.advancedRocketry.world.gen.WorldGenAlienTree;
import zmaster587.advancedRocketry.world.gen.WorldGenCharredTree;
import zmaster587.advancedRocketry.world.gen.WorldGenLargeCrystal;

public class AdvancedRocketryBiomes {
    public static final AdvancedRocketryBiomes instance = new AdvancedRocketryBiomes();
    private List<Biome> registeredBiomes = new ArrayList<Biome>();
    private List<Biome> registeredHighPressureBiomes = new LinkedList<Biome>();
    private List<Biome> registeredSingleBiome;
    private static List<ResourceLocation> blackListedBiomeIds;
    public static IStructurePieceType STRUCTURE_PIECE_CRATER;
    public static IStructurePieceType STRUCTURE_PIECE_VOLCANO;
    public static IStructurePieceType STRUCTURE_PIECE_GEODE;
    public static ConfiguredSurfaceBuilder<SurfaceBuilderConfig> MOON_LUNAR_LIGHT_CONFIG;
    public static ConfiguredSurfaceBuilder<SurfaceBuilderConfig> MOON_LUNAR_DARK_CONFIG;
    public static ConfiguredSurfaceBuilder<SurfaceBuilderConfig> HOTDRY_CONFIG;
    public static ConfiguredSurfaceBuilder<SurfaceBuilderConfig> SPACE_CONFIG;
    public static ConfiguredSurfaceBuilder<SurfaceBuilderConfig> GRAVEL_CONFIG;
    public static ConfiguredSurfaceBuilder<SurfaceBuilderConfig> BASALT_CONFIG;
    public static Structure<ProbabilityConfig> CRATER;
    public static Structure<ProbabilityConfig> VOLCANO;
    public static Structure<ProbabilityConfig> GEODE;
    public static StructureFeature<ProbabilityConfig, ? extends Structure<ProbabilityConfig>> CONFIGURED_CRATER;
    public static StructureFeature<ProbabilityConfig, ? extends Structure<ProbabilityConfig>> CONFIGURED_VOLCANO;
    public static StructureFeature<ProbabilityConfig, ? extends Structure<ProbabilityConfig>> CONFIGURED_GEODE;
    public static WorldCarver<ProbabilityConfig> BIG_TREE;
    public static WorldCarver<ProbabilityConfig> INVERTED_PILLAR;
    public static ConfiguredCarver<ProbabilityConfig> CONFIGURED_BIG_TREE;
    public static ConfiguredCarver<ProbabilityConfig> CONFIGURED_INVERTED_PILLAR;
    public static Feature<NoFeatureConfig> CRYSTAL_FEATURE;
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> ALIEN_TREE;
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> CHARRED_TREE;
    public static ConfiguredFeature<NoFeatureConfig, ?> CRYSTAL_SPIRE;
    private static BiomeGenerationSettings barren;
    private static BiomeGenerationSettings barrenDark;
    private static BiomeGenerationSettings hotDry;
    private static BiomeGenerationSettings genalienForest;
    private static BiomeGenerationSettings spaceBiomeGen;
    private static BiomeGenerationSettings genCharredLand;
    private static BiomeGenerationSettings genCrystalLandscape;
    private static BiomeGenerationSettings genSwamp;
    private static BiomeGenerationSettings genOceanSpires;
    private static BiomeGenerationSettings genVolcanicBasalt;
    private static BiomeGenerationSettings genVolcanicBasaltBarren;
    public static Biome moonBiome;
    public static Biome hotDryBiome;
    public static Biome alienForest;
    public static Biome spaceBiome;
    public static Biome stormLandsBiome;
    public static Biome crystalChasms;
    public static Biome swampDeepBiome;
    public static Biome marsh;
    public static Biome oceanSpires;
    public static Biome moonBiomeDark;
    public static Biome volcanic;
    public static Biome volcanicBarren;

    private static <SC extends ISurfaceBuilderConfig> ConfiguredSurfaceBuilder<SC> registerSurfaceBuilder(String p_244192_0_, ConfiguredSurfaceBuilder<SC> p_244192_1_) {
        return (ConfiguredSurfaceBuilder)WorldGenRegistries.func_243663_a((Registry)WorldGenRegistries.field_243651_c, (String)p_244192_0_, p_244192_1_);
    }

    public static void configureSurfaceBuilders() {
        MOON_LUNAR_LIGHT_CONFIG = AdvancedRocketryBiomes.registerSurfaceBuilder("advancedrocketry:lunargenerationlight", SurfaceBuilder.field_215396_G.func_242929_a((ISurfaceBuilderConfig)new SurfaceBuilderConfig(AdvancedRocketryBlocks.blockMoonTurf.func_176223_P(), AdvancedRocketryBlocks.blockMoonTurf.func_176223_P(), Blocks.field_150351_n.func_176223_P())));
        MOON_LUNAR_DARK_CONFIG = AdvancedRocketryBiomes.registerSurfaceBuilder("lunargenerationdark", SurfaceBuilder.field_215396_G.func_242929_a((ISurfaceBuilderConfig)new SurfaceBuilderConfig(AdvancedRocketryBlocks.blockMoonTurfDark.func_176223_P(), AdvancedRocketryBlocks.blockMoonTurfDark.func_176223_P(), Blocks.field_150351_n.func_176223_P())));
        HOTDRY_CONFIG = AdvancedRocketryBiomes.registerSurfaceBuilder("hotdrygeneration", SurfaceBuilder.field_215396_G.func_242929_a((ISurfaceBuilderConfig)new SurfaceBuilderConfig(AdvancedRocketryBlocks.blockHotTurf.func_176223_P(), AdvancedRocketryBlocks.blockHotTurf.func_176223_P(), Blocks.field_150351_n.func_176223_P())));
        SPACE_CONFIG = AdvancedRocketryBiomes.registerSurfaceBuilder("spacegeneration", SurfaceBuilder.field_215396_G.func_242929_a((ISurfaceBuilderConfig)new SurfaceBuilderConfig(Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P())));
        GRAVEL_CONFIG = AdvancedRocketryBiomes.registerSurfaceBuilder("gravel", SurfaceBuilder.field_215396_G.func_242929_a((ISurfaceBuilderConfig)new SurfaceBuilderConfig(Blocks.field_150351_n.func_176223_P(), Blocks.field_150351_n.func_176223_P(), Blocks.field_150351_n.func_176223_P())));
        BASALT_CONFIG = AdvancedRocketryBiomes.registerSurfaceBuilder("basalt", SurfaceBuilder.field_215396_G.func_242929_a((ISurfaceBuilderConfig)new SurfaceBuilderConfig(AdvancedRocketryBlocks.blockBasalt.func_176223_P(), AdvancedRocketryBlocks.blockBasalt.func_176223_P(), AdvancedRocketryBlocks.blockBasalt.func_176223_P())));
    }

    public static void registerStructures(RegistryEvent.Register<Structure<?>> evt) {
        evt.getRegistry().register(VOLCANO.setRegistryName("volcano"));
        evt.getRegistry().register(CRATER.setRegistryName("crater"));
        evt.getRegistry().register(GEODE.setRegistryName("geode"));
        Structure.field_236365_a_.put((Object)"advancedrocketry:volcano", VOLCANO);
        Structure.field_236365_a_.put((Object)"advancedrocketry:crater", CRATER);
        Structure.field_236365_a_.put((Object)"advancedrocketry:geode", GEODE);
        Field decorationStageField = ObfuscationReflectionHelper.findField(Structure.class, (String)"field_236385_u_");
        decorationStageField.setAccessible(true);
        try {
            Map decoractionStage = (Map)decorationStageField.get(null);
            decoractionStage.put(VOLCANO, GenerationStage.Decoration.LOCAL_MODIFICATIONS);
            decoractionStage.put(CRATER, GenerationStage.Decoration.LOCAL_MODIFICATIONS);
            decoractionStage.put(GEODE, GenerationStage.Decoration.LOCAL_MODIFICATIONS);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        WorldGenRegistries.func_243663_a((Registry)WorldGenRegistries.field_243654_f, (String)"advancedrocketry:volcano", CONFIGURED_VOLCANO);
        WorldGenRegistries.func_243663_a((Registry)WorldGenRegistries.field_243654_f, (String)"advancedrocketry:crater", CONFIGURED_CRATER);
        WorldGenRegistries.func_243663_a((Registry)WorldGenRegistries.field_243654_f, (String)"advancedrocketry:geode", CONFIGURED_GEODE);
    }

    public static void registerCarvers(RegistryEvent.Register<WorldCarver<?>> evt) {
        evt.getRegistry().register(BIG_TREE.setRegistryName("swamp_tree"));
        evt.getRegistry().register(INVERTED_PILLAR.setRegistryName("inverted_pillar"));
    }

    private static <WC extends ICarverConfig> ConfiguredCarver<WC> configureCarver(String p_243773_0_, ConfiguredCarver<WC> p_243773_1_) {
        return (ConfiguredCarver)WorldGenRegistries.func_243663_a((Registry)WorldGenRegistries.field_243652_d, (String)p_243773_0_, p_243773_1_);
    }

    public static void initFeature() {
        CRYSTAL_FEATURE = new WorldGenLargeCrystal((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        ALIEN_TREE = AdvancedRocketryBiomes.registerTree("alientree", Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AdvancedRocketryBlocks.blockAlienWood.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(AdvancedRocketryBlocks.blockAlienLeaves.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new WorldGenAlienTree(4, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_()));
        CHARRED_TREE = AdvancedRocketryBiomes.registerTree("charredtree", Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AdvancedRocketryBlocks.blockCharcoalLog.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_150350_a.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242252_a((int)0), 0), (AbstractTrunkPlacer)new WorldGenCharredTree(4, 2, 0, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_()));
        CRYSTAL_SPIRE = AdvancedRocketryBiomes.registerTree("crystal", CRYSTAL_FEATURE.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e));
    }

    public static void registerFeature(RegistryEvent.Register<Feature<?>> evt) {
        if (CRYSTAL_FEATURE == null) {
            AdvancedRocketryBiomes.initFeature();
        }
        evt.getRegistry().register(CRYSTAL_FEATURE.setRegistryName("largecrystal"));
    }

    private static <FC extends IFeatureConfig> ConfiguredFeature<FC, ?> registerTree(String p_243968_0_, ConfiguredFeature<FC, ?> p_243968_1_) {
        return (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)p_243968_0_, p_243968_1_);
    }

    public static void registerBiomeGenerationSettings() {
        AdvancedRocketryBiomes.configureSurfaceBuilders();
        barren = AdvancedRocketryBiomes.createBuilder(MOON_LUNAR_LIGHT_CONFIG, true).func_242512_a(GenerationStage.Carving.AIR, ConfiguredCarvers.field_243767_a).func_242508_a();
        barrenDark = AdvancedRocketryBiomes.createBuilder(MOON_LUNAR_DARK_CONFIG, true).func_242512_a(GenerationStage.Carving.AIR, ConfiguredCarvers.field_243767_a).func_242508_a();
        hotDry = AdvancedRocketryBiomes.createBuilder(HOTDRY_CONFIG, true).func_242508_a();
        genalienForest = AdvancedRocketryBiomes.createBuilder(ConfiguredSurfaceBuilders.field_244178_j, false).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ALIEN_TREE).func_242508_a();
        spaceBiomeGen = new BiomeGenerationSettings.Builder().func_242517_a(SPACE_CONFIG).func_242508_a();
        genCharredLand = AdvancedRocketryBiomes.createBuilder(ConfiguredSurfaceBuilders.field_244178_j, false).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CHARRED_TREE).func_242508_a();
        genCrystalLandscape = AdvancedRocketryBiomes.createBuilder(ConfiguredSurfaceBuilders.field_244180_l, false).func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, CRYSTAL_SPIRE).func_242508_a();
        BiomeGenerationSettings.Builder swampBuilder = AdvancedRocketryBiomes.createBuilder(ConfiguredSurfaceBuilders.field_244178_j, false).func_242512_a(GenerationStage.Carving.AIR, CONFIGURED_BIG_TREE).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243965_y);
        DefaultBiomeFeatures.func_243702_P((BiomeGenerationSettings.Builder)swampBuilder);
        genSwamp = swampBuilder.func_242508_a();
        genOceanSpires = AdvancedRocketryBiomes.createBuilder(GRAVEL_CONFIG, false).func_242512_a(GenerationStage.Carving.AIR, CONFIGURED_INVERTED_PILLAR).func_242508_a();
        genVolcanicBasalt = AdvancedRocketryBiomes.createBuilder(BASALT_CONFIG, false).func_242516_a(CONFIGURED_VOLCANO).func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CHARRED_TREE).func_242508_a();
        genVolcanicBasaltBarren = AdvancedRocketryBiomes.createBuilder(BASALT_CONFIG, false).func_242516_a(CONFIGURED_VOLCANO).func_242508_a();
    }

    private static BiomeGenerationSettings.Builder createBuilder(ConfiguredSurfaceBuilder<?> surface, boolean space) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder();
        builder = builder.func_242517_a(surface);
        if (!space) {
            DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)builder);
        }
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)builder);
        return builder;
    }

    public static Biome.Builder makeSwamp(boolean p_244236_2_) {
        MobSpawnInfo.Builder mobspawninfo$builder = new MobSpawnInfo.Builder();
        DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)mobspawninfo$builder);
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)mobspawninfo$builder);
        mobspawninfo$builder.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200743_ai, 1, 1, 1));
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244189_u);
        if (!p_244236_2_) {
            biomegenerationsettings$builder.func_242516_a(StructureFeatures.field_244144_j);
        }
        biomegenerationsettings$builder.func_242516_a(StructureFeatures.field_244136_b);
        biomegenerationsettings$builder.func_242516_a(StructureFeatures.field_244136_b);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        if (!p_244236_2_) {
            DefaultBiomeFeatures.func_243723_ag((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        }
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243755_o((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243702_P((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243721_ae((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        if (p_244236_2_) {
            DefaultBiomeFeatures.func_243723_ag((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        } else {
            biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243965_y);
        }
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.SWAMP).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(6388580).func_235248_c_(2302743).func_235239_a_(12638463).func_242539_d(AdvancedRocketryBiomes.getHue(0.8f)).func_242540_e(6975545).func_242537_a(BiomeAmbience.GrassColorModifier.SWAMP).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(mobspawninfo$builder.func_242577_b()).func_242457_a(biomegenerationsettings$builder.func_242508_a());
    }

    private static int getHue(float p_244206_0_) {
        float lvt_1_1_ = p_244206_0_ / 3.0f;
        lvt_1_1_ = MathHelper.func_76131_a((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
    }

    private AdvancedRocketryBiomes() {
        blackListedBiomeIds = new ArrayList<ResourceLocation>();
        this.registeredSingleBiome = new ArrayList<Biome>();
    }

    private static int getSkyColor(float p_244206_0_) {
        float lvt_1_1_ = p_244206_0_ / 3.0f;
        lvt_1_1_ = MathHelper.func_76131_a((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
    }

    public static void registerBiomes(RegistryEvent.Register<Biome> evt) {
        if (CRYSTAL_FEATURE == null) {
            AdvancedRocketryBiomes.initFeature();
        }
        AdvancedRocketryBiomes.registerBiomeGenerationSettings();
        BiomeAmbience noAmbience = new BiomeAmbience.Builder().func_242539_d(AdvancedRocketryBiomes.getSkyColor(0.6f)).func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_235238_a_();
        MobSpawnInfo noMobs = new MobSpawnInfo.Builder().func_242577_b();
        moonBiome = new Biome.Builder().func_205419_a(Biome.Category.NONE).func_205415_a(Biome.RainType.NONE).func_205421_a(1.0f).func_205417_d(0.0f).func_205420_b(0.02f).func_205414_c(0.3f).func_242457_a(barren).func_235097_a_(noAmbience).func_242458_a(noMobs).func_242455_a();
        hotDryBiome = new Biome.Builder().func_205419_a(Biome.Category.NONE).func_205415_a(Biome.RainType.NONE).func_205421_a(1.0f).func_205420_b(0.01f).func_205417_d(0.0f).func_205414_c(0.9f).func_242457_a(hotDry).func_235097_a_(noAmbience).func_242458_a(noMobs).func_242455_a();
        alienForest = new Biome.Builder().func_205419_a(Biome.Category.FOREST).func_205415_a(Biome.RainType.RAIN).func_205421_a(1.0f).func_205417_d(0.0f).func_205420_b(0.2f).func_205414_c(0.6f).func_242457_a(genalienForest).func_235097_a_(new BiomeAmbience.Builder().func_242537_a(BiomeAmbience.GrassColorModifier.DARK_FOREST).func_242539_d(AdvancedRocketryBiomes.getSkyColor(0.6f)).func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_235238_a_()).func_242458_a(noMobs).func_242455_a();
        spaceBiome = new Biome.Builder().func_205419_a(Biome.Category.NONE).func_205417_d(0.0f).func_205415_a(Biome.RainType.NONE).func_205421_a(-2.0f).func_205420_b(0.0f).func_205414_c(1.0f).func_242457_a(spaceBiomeGen).func_235097_a_(noAmbience).func_242458_a(noMobs).func_242455_a();
        stormLandsBiome = new Biome.Builder().func_205419_a(Biome.Category.FOREST).func_205415_a(Biome.RainType.RAIN).func_205414_c(0.6f).func_205417_d(2.0f).func_205421_a(0.25f).func_205420_b(0.1f).func_242457_a(genCharredLand).func_235097_a_(new BiomeAmbience.Builder().func_242537_a(BiomeAmbience.GrassColorModifier.DARK_FOREST).func_242539_d(AdvancedRocketryBiomes.getSkyColor(0.6f)).func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_235238_a_()).func_242458_a(noMobs).func_242455_a();
        crystalChasms = new Biome.Builder().func_205419_a(Biome.Category.PLAINS).func_205415_a(Biome.RainType.SNOW).func_205421_a(0.25f).func_205420_b(0.02f).func_205414_c(0.3f).func_205417_d(1.0f).func_242457_a(genCrystalLandscape).func_235097_a_(new BiomeAmbience.Builder().func_242537_a(BiomeAmbience.GrassColorModifier.DARK_FOREST).func_242539_d(AdvancedRocketryBiomes.getSkyColor(0.6f)).func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_235238_a_()).func_242458_a(noMobs).func_242455_a();
        swampDeepBiome = new Biome.Builder().func_205419_a(Biome.Category.SWAMP).func_205415_a(Biome.RainType.RAIN).func_205421_a(-0.1f).func_242457_a(genSwamp).func_205420_b(0.02f).func_205417_d(0.9f).func_205414_c(0.9f).func_235097_a_(new BiomeAmbience.Builder().func_242537_a(BiomeAmbience.GrassColorModifier.DARK_FOREST).func_242539_d(AdvancedRocketryBiomes.getSkyColor(0.6f)).func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_235238_a_()).func_242458_a(noMobs).func_242455_a();
        marsh = AdvancedRocketryBiomes.makeSwamp(false).func_205419_a(Biome.Category.PLAINS).func_205415_a(Biome.RainType.RAIN).func_205417_d(0.7f).func_205421_a(-0.4f).func_205414_c(0.5f).func_205420_b(0.0f).func_235097_a_(noAmbience).func_242458_a(noMobs).func_242455_a();
        oceanSpires = new Biome.Builder().func_205419_a(Biome.Category.BEACH).func_205415_a(Biome.RainType.RAIN).func_205417_d(0.7f).func_205421_a(-0.5f).func_205414_c(0.5f).func_205420_b(0.0f).func_242457_a(genOceanSpires).func_235097_a_(noAmbience).func_242458_a(noMobs).func_242455_a();
        moonBiomeDark = new Biome.Builder().func_205419_a(Biome.Category.NONE).func_205415_a(Biome.RainType.NONE).func_205421_a(1.0f).func_205417_d(0.0f).func_205420_b(0.02f).func_205414_c(0.3f).func_242457_a(barrenDark).func_235097_a_(noAmbience).func_242458_a(noMobs).func_242455_a();
        volcanic = new Biome.Builder().func_205419_a(Biome.Category.NONE).func_205415_a(Biome.RainType.NONE).func_205421_a(0.0f).func_205417_d(0.0f).func_205420_b(0.09f).func_205414_c(1.0f).func_242457_a(genVolcanicBasalt).func_235097_a_(noAmbience).func_242458_a(noMobs).func_242455_a();
        volcanicBarren = new Biome.Builder().func_205419_a(Biome.Category.NONE).func_205415_a(Biome.RainType.NONE).func_205417_d(0.0f).func_205421_a(0.0f).func_205420_b(0.09f).func_205414_c(1.0f).func_242457_a(genVolcanicBasaltBarren).func_235097_a_(noAmbience).func_242458_a(noMobs).func_242455_a();
        evt.getRegistry().registerAll((IForgeRegistryEntry[])new Biome[]{(Biome)moonBiome.setRegistryName("moon"), (Biome)hotDryBiome.setRegistryName("hotdry"), (Biome)spaceBiome.setRegistryName("space"), (Biome)stormLandsBiome.setRegistryName("stormland"), (Biome)crystalChasms.setRegistryName("crystal_chasm"), (Biome)swampDeepBiome.setRegistryName("deepswamp"), (Biome)marsh.setRegistryName("marsh"), (Biome)oceanSpires.setRegistryName("oceanspires"), (Biome)moonBiomeDark.setRegistryName("moon_dark"), (Biome)volcanic.setRegistryName("volcanic"), (Biome)volcanicBarren.setRegistryName("volcanic_barren")});
    }

    public void registerBlackListBiome(Biome biome) {
        blackListedBiomeIds.add(AdvancedRocketryBiomes.getBiomeResource(biome));
    }

    public List<ResourceLocation> getBlackListedBiomes() {
        return blackListedBiomeIds;
    }

    public void registerHighPressureBiome(Biome biome) {
        this.registeredHighPressureBiomes.add(biome);
        this.registerBlackListBiome(biome);
    }

    public List<Biome> getHighPressureBiomes() {
        return this.registeredHighPressureBiomes;
    }

    public void registerSingleBiome(Biome biome) {
        if (!blackListedBiomeIds.contains(AdvancedRocketryBiomes.getBiomeResource(biome))) {
            this.registeredSingleBiome.add(biome);
        }
    }

    public void blackListVanillaBiomes() {
    }

    public List<Biome> getSingleBiome() {
        return this.registeredSingleBiome;
    }

    public static Biome getBiome(String string) {
        boolean id = false;
        Biome biome = AdvancedRocketryBiomes.getBiomeFromResourceLocation(new ResourceLocation(string));
        return biome;
    }

    public static DimensionProperties.Temps getBiomeTemp(Biome biome) {
        return DimensionProperties.Temps.getTempFromValue((int)(biome.func_225486_c(new BlockPos(0, 100, 0)) * (float)DimensionProperties.Temps.HOT.getTemp()));
    }

    public static Iterator<Biome> getAllBiomes() {
        return AdvancedRocketryBiomes.getForgeRegistry().iterator();
    }

    public static ResourceLocation getBiomeResource(Biome biome) {
        return AdvancedRocketryBiomes.getForgeRegistry().getKey((IForgeRegistryEntry)biome);
    }

    public static Biome getBiomeFromResourceLocation(ResourceLocation key) {
        return (Biome)AdvancedRocketryBiomes.getForgeRegistry().getValue(key);
    }

    public static boolean doesBiomeExist(ResourceLocation key) {
        return AdvancedRocketryBiomes.getForgeRegistry().containsKey(key);
    }

    public static int getBiomeId(Biome key) {
        return AdvancedRocketryBiomes.getBiomeRegistry().func_148757_b((Object)key);
    }

    public static int getBiomeId(ResourceLocation key) {
        return AdvancedRocketryBiomes.getBiomeRegistry().func_148757_b((Object)AdvancedRocketryBiomes.getBiomeFromResourceLocation(key));
    }

    private static IForgeRegistry<Biome> getForgeRegistry() {
        return ForgeRegistries.BIOMES;
    }

    public static Registry<Biome> getBiomeRegistry() {
        return (Registry)DynamicRegistries.func_239770_b_().func_230521_a_(Registry.field_239720_u_).get();
    }

    static {
        Registry.func_218325_a((Registry)Registry.field_239689_aA_, (String)"advancedrocketry:planetary", CustomPlanetBiomeProvider.customPlanetCodec);
        Registry.func_218325_a((Registry)Registry.field_239690_aB_, (String)"advancedrocketry:planetary_noise", ChunkProviderPlanet.planetCodec);
        Registry.func_218325_a((Registry)Registry.field_239690_aB_, (String)"advancedrocketry:space", ChunkProviderSpace.planetCodec);
        STRUCTURE_PIECE_CRATER = (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"craterpiece".toLowerCase(Locale.ROOT), StructurePieceCrater::new);
        STRUCTURE_PIECE_VOLCANO = (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"volcanopiece".toLowerCase(Locale.ROOT), StructurePieceVolcano::new);
        STRUCTURE_PIECE_GEODE = (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"geodePiece".toLowerCase(Locale.ROOT), StructurePieceGeode::new);
        CRATER = new StructureCrater((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_);
        VOLCANO = new StructureVolcano((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_);
        GEODE = new StructureGeode((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_);
        CONFIGURED_CRATER = CRATER.func_236391_a_((IFeatureConfig)new ProbabilityConfig(1.0E-7f));
        CONFIGURED_VOLCANO = VOLCANO.func_236391_a_((IFeatureConfig)new ProbabilityConfig(1.0E-7f));
        CONFIGURED_GEODE = GEODE.func_236391_a_((IFeatureConfig)new ProbabilityConfig(1.0E-7f));
        BIG_TREE = new MapGenSwampTree((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_, 256);
        INVERTED_PILLAR = new MapGenInvertedPillar((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_, 256, Blocks.field_150348_b.func_176223_P(), Blocks.field_150351_n.func_176223_P(), Blocks.field_150346_d.func_176223_P());
        CONFIGURED_BIG_TREE = AdvancedRocketryBiomes.configureCarver("big_tree", BIG_TREE.func_242761_a((ICarverConfig)new ProbabilityConfig(0.02f)));
        CONFIGURED_INVERTED_PILLAR = AdvancedRocketryBiomes.configureCarver("inverted_pillar", INVERTED_PILLAR.func_242761_a((ICarverConfig)new ProbabilityConfig(0.02f)));
    }
}

