/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.RegistryObject;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.block.BlockEnrichedLava;
import zmaster587.advancedRocketry.util.FluidGasGiantGas;
import zmaster587.libVulpes.LibVulpes;

public class AdvancedRocketryFluids {
    public static Fluid fluidOxygen;
    public static Fluid fluidHydrogen;
    public static Fluid fluidRocketFuel;
    public static Fluid fluidNitrogen;
    public static Fluid fluidEnrichedLava;
    private static Set<FluidGasGiantGas> gasses;
    private static final ResourceLocation notFlowing;
    private static final ResourceLocation flowing;
    private static final ResourceLocation lavaNotFlowing;
    private static final ResourceLocation lavaFlowing;
    public static RegistryObject<FlowingFluid> oxygenFlowing;
    public static RegistryObject<FlowingFluid> oxygenStill;
    public static RegistryObject<FlowingFluid> hydrogenFlowing;
    public static RegistryObject<FlowingFluid> hydrogenStill;
    public static RegistryObject<FlowingFluid> rocketFuelFlowing;
    public static RegistryObject<FlowingFluid> rocketFuelStill;
    public static RegistryObject<FlowingFluid> nitrogenFlowing;
    public static RegistryObject<FlowingFluid> nitrogenStill;
    public static RegistryObject<FlowingFluid> enrichedlavaFlowing;
    public static RegistryObject<FlowingFluid> enrichedLavaStill;

    public static void registerGasGiantGas(Fluid gas, int minGravity, int maxGravity, double chance) {
        gasses.add(new FluidGasGiantGas(gas, minGravity, maxGravity, chance));
    }

    public static Set<FluidGasGiantGas> getGasGiantGasses() {
        return gasses;
    }

    public static boolean isGasGiantGasRegistered(ResourceLocation name) {
        for (FluidGasGiantGas gas : AdvancedRocketryFluids.getGasGiantGasses()) {
            if (!name.equals((Object)gas.getFluid().getRegistryName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isGasGiantGasRegistered(Fluid gasToCheck) {
        for (FluidGasGiantGas gas : AdvancedRocketryFluids.getGasGiantGasses()) {
            if (gas.getFluid() != gasToCheck) continue;
            return true;
        }
        return false;
    }

    public static ForgeFlowingFluid.Properties makeOxygenProps() {
        return new ForgeFlowingFluid.Properties(oxygenStill, oxygenFlowing, FluidAttributes.builder((ResourceLocation)notFlowing, (ResourceLocation)flowing).color(-7367495).density(800).viscosity(1500)).bucket(AdvancedRocketryItems.itemBucketOxygen).block(AdvancedRocketryBlocks.blockOxygenFluid);
    }

    public static ForgeFlowingFluid.Properties makeHydrogenProps() {
        return new ForgeFlowingFluid.Properties(hydrogenStill, hydrogenFlowing, FluidAttributes.builder((ResourceLocation)notFlowing, (ResourceLocation)flowing).color(-2375231).density(800).viscosity(1500)).bucket(AdvancedRocketryItems.itemBucketHydrogen).block(AdvancedRocketryBlocks.blockHydrogenFluid);
    }

    public static ForgeFlowingFluid.Properties makeRocketFuelProps() {
        return new ForgeFlowingFluid.Properties(rocketFuelStill, rocketFuelFlowing, FluidAttributes.builder((ResourceLocation)notFlowing, (ResourceLocation)flowing).color(-1714044).density(800).viscosity(1500)).bucket(AdvancedRocketryItems.itemBucketRocketFuel);
    }

    public static ForgeFlowingFluid.Properties makeNitrogenProps() {
        return new ForgeFlowingFluid.Properties(nitrogenStill, nitrogenFlowing, FluidAttributes.builder((ResourceLocation)notFlowing, (ResourceLocation)flowing).color(-6838297).density(800).viscosity(1500)).bucket(AdvancedRocketryItems.itemBucketNitrogen).block(AdvancedRocketryBlocks.blockNitrogenFluid);
    }

    public static ForgeFlowingFluid.Properties makeEnrichedLavaProps() {
        return new ForgeFlowingFluid.Properties(enrichedLavaStill, enrichedlavaFlowing, FluidAttributes.builder((ResourceLocation)lavaNotFlowing, (ResourceLocation)lavaFlowing).color(-1).luminosity(15).density(3000).sound(SoundEvents.field_187633_N, SoundEvents.field_187627_L).viscosity(6000).temperature(3000)).bucket(AdvancedRocketryItems.itemBucketEnrichedLava).block(AdvancedRocketryBlocks.blockEnrichedLavaFluid);
    }

    public static void init() {
        oxygenFlowing = AdvancedRocketry.FLUIDS.register("oxygen_flowing", () -> new ForgeFlowingFluid.Flowing(AdvancedRocketryFluids.makeOxygenProps()));
        oxygenStill = AdvancedRocketry.FLUIDS.register("oxygen", () -> new ForgeFlowingFluid.Source(AdvancedRocketryFluids.makeOxygenProps()));
        hydrogenFlowing = AdvancedRocketry.FLUIDS.register("hydrogen_flowing", () -> new ForgeFlowingFluid.Flowing(AdvancedRocketryFluids.makeHydrogenProps()));
        hydrogenStill = AdvancedRocketry.FLUIDS.register("hydrogen", () -> new ForgeFlowingFluid.Source(AdvancedRocketryFluids.makeHydrogenProps()));
        rocketFuelFlowing = AdvancedRocketry.FLUIDS.register("rocket_fuel_flowing", () -> new ForgeFlowingFluid.Flowing(AdvancedRocketryFluids.makeRocketFuelProps()));
        rocketFuelStill = AdvancedRocketry.FLUIDS.register("rocket_fuel", () -> new ForgeFlowingFluid.Source(AdvancedRocketryFluids.makeRocketFuelProps()));
        nitrogenStill = AdvancedRocketry.FLUIDS.register("nitrogen", () -> new ForgeFlowingFluid.Source(AdvancedRocketryFluids.makeNitrogenProps()));
        nitrogenFlowing = AdvancedRocketry.FLUIDS.register("nitrogen_flowing", () -> new ForgeFlowingFluid.Flowing(AdvancedRocketryFluids.makeNitrogenProps()));
        enrichedLavaStill = AdvancedRocketry.FLUIDS.register("enriched_lava", () -> new ForgeFlowingFluid.Source(AdvancedRocketryFluids.makeEnrichedLavaProps()));
        enrichedlavaFlowing = AdvancedRocketry.FLUIDS.register("enriched_lava_flowing", () -> new ForgeFlowingFluid.Flowing(AdvancedRocketryFluids.makeEnrichedLavaProps()));
        AdvancedRocketryBlocks.blockOxygenFluid = AdvancedRocketry.BLOCKS.register("oxygenfluidblock", () -> new FlowingFluidBlock(oxygenStill, AbstractBlock.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_222380_e()));
        AdvancedRocketryBlocks.blockHydrogenFluid = AdvancedRocketry.BLOCKS.register("hydrogenfluidblock", () -> new FlowingFluidBlock(hydrogenStill, AbstractBlock.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_222380_e()));
        AdvancedRocketryBlocks.blockFuelFluid = AdvancedRocketry.BLOCKS.register("rocketfuelblock", () -> new FlowingFluidBlock(rocketFuelStill, AbstractBlock.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_222380_e()));
        AdvancedRocketryBlocks.blockNitrogenFluid = AdvancedRocketry.BLOCKS.register("nitrogenfluidblock", () -> new FlowingFluidBlock(nitrogenStill, AbstractBlock.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_222380_e()));
        AdvancedRocketryBlocks.blockEnrichedLavaFluid = AdvancedRocketry.BLOCKS.register("enrichedlavablock", () -> new BlockEnrichedLava((Supplier<FlowingFluid>)enrichedLavaStill, AbstractBlock.Properties.func_200945_a((Material)Material.field_151587_i).func_200944_c().func_200942_a().func_200943_b(100.0f).func_222380_e().func_235838_a_(p_235470_0_ -> 14)));
        Item.Properties bucketItem = new Item.Properties().func_200916_a(LibVulpes.tabLibVulpesOres).func_200919_a(Items.field_151133_ar);
        AdvancedRocketryItems.itemBucketRocketFuel = AdvancedRocketry.ITEMS.register("bucketrocketfuel", () -> new BucketItem(rocketFuelStill, bucketItem));
        AdvancedRocketryItems.itemBucketNitrogen = AdvancedRocketry.ITEMS.register("bucketnitrogen", () -> new BucketItem(nitrogenStill, bucketItem));
        AdvancedRocketryItems.itemBucketHydrogen = AdvancedRocketry.ITEMS.register("buckethydrogen", () -> new BucketItem(hydrogenStill, bucketItem));
        AdvancedRocketryItems.itemBucketOxygen = AdvancedRocketry.ITEMS.register("bucketoxygen", () -> new BucketItem(oxygenStill, bucketItem));
        AdvancedRocketryItems.itemBucketEnrichedLava = AdvancedRocketry.ITEMS.register("bucketenrichedlava", () -> new BucketItem(enrichedLavaStill, bucketItem));
    }

    static {
        gasses = new HashSet<FluidGasGiantGas>();
        notFlowing = new ResourceLocation("advancedrocketry:blocks/fluid/oxygen_still");
        flowing = new ResourceLocation("advancedrocketry:blocks/fluid/oxygen_flow");
        lavaNotFlowing = new ResourceLocation("advancedrocketry:blocks/fluid/lava_still");
        lavaFlowing = new ResourceLocation("advancedrocketry:blocks/fluid/lava_flow");
    }
}

