/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api;

import java.util.LinkedList;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryAPI;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.RocketEvent;
import zmaster587.advancedRocketry.api.StatsRocket;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.ZUtils;

public abstract class EntityRocketBase
extends Entity {
    protected LinkedList<IInfrastructure> connectedInfrastructure;
    protected Set<HashedBlockPosition> infrastructureCoords;
    public StatsRocket stats;

    public EntityRocketBase(EntityType<?> type, World world) {
        super(type, world);
    }

    public void func_213323_x_() {
    }

    public abstract int addFuelAmountMonopropellant(int var1);

    public abstract int addFuelAmountBipropellant(int var1);

    public abstract int addFuelAmountOxidizer(int var1);

    public abstract void setFuelRateMonopropellant(int var1);

    public abstract void setFuelRateBipropellant(int var1);

    public abstract void setFuelRateOxidizer(int var1);

    public void unlinkInfrastructure(IInfrastructure tile) {
        this.connectedInfrastructure.remove(tile);
    }

    public void linkInfrastructure(IInfrastructure tile) {
        if (!this.connectedInfrastructure.contains(tile) && tile.linkRocket(this)) {
            this.connectedInfrastructure.add(tile);
        }
    }

    public abstract void prepareLaunch();

    public abstract void launch();

    public abstract int getFuelAmountMonopropellant();

    public abstract int getFuelAmountBipropellant();

    public abstract int getFuelAmountOxidizer();

    public abstract int getFuelCapacityMonopropellant();

    public abstract int getFuelCapacityBipropellant();

    public abstract int getFuelCapacityOxidizer();

    public abstract int getFuelRateMonopropellant();

    public abstract int getFuelRateBipropellant();

    public abstract int getFuelRateOxidizer();

    public String getTextOverlay() {
        return "";
    }

    public abstract StatsRocket getRocketStats();

    public void onOrbitReached() {
        ISpaceObject station;
        MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketReachesOrbitEvent(this));
        if (ARConfiguration.GetSpaceDimId().equals((Object)ZUtils.getDimensionIdentifier((World)this.field_70170_p)) && (station = AdvancedRocketryAPI.spaceObjectManager.getSpaceStationFromBlockCoords(new BlockPos(this.func_213303_ch()))) instanceof ISpaceObject) {
            station.setPadStatus((int)Math.floor(this.func_226277_ct_()), (int)Math.floor(this.func_226281_cx_()), false);
        }
    }

    public void deconstructRocket() {
        MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketDismantleEvent(this));
    }
}

