/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.util.ResourceLocation;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.fuel.FuelRegistry;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.Vector3F;

public class StatsRocket {
    private int thrust = 0;
    private int weight = 0;
    private float drillingPower = 0.0f;
    private ResourceLocation fuelFluid = null;
    private ResourceLocation oxidizerFluid = null;
    public int orbitHeight;
    public float injectionBurnLenghtMult;
    private int fuelMonopropellant = 0;
    private int fuelNuclear;
    private int fuelBipropellant = 0;
    private int fuelOxidizer = 0;
    private int fuelIon;
    private int fuelWarp;
    private int fuelImpulse;
    private int fuelCapacityMonopropellant;
    private int fuelCapacityBipropellant;
    private int fuelCapacityOxidizer;
    private int fuelCapacityNuclear;
    private int fuelCapacityIon;
    private int fuelCapacityWarp;
    private int fuelCapacityImpulse;
    private int fuelRateMonopropellant = 0;
    private int fuelRateBipropellant = 0;
    private int fuelRateOxidizer = 0;
    private int fuelRateNuclear;
    private int fuelRateIon;
    private int fuelRateWarp;
    private int fuelRateImpulse;
    private float fuelBaseRateMonopropellant;
    private float fuelBaseRateBipropellant;
    private float fuelBaseRateOxidizer;
    private float fuelBaseRateNuclear;
    private float fuelBaseRateIon;
    private float fuelBaseRateWarp;
    private float fuelBaseRateImpulse;
    HashedBlockPosition pilotSeatPos;
    private final List<HashedBlockPosition> passengerSeats = new ArrayList<HashedBlockPosition>();
    private List<Vector3F<Float>> engineLoc;
    private static final String TAGNAME = "rocketStats";
    private HashMap<String, Object> statTags;
    private static final int INVALID_SEAT = Integer.MIN_VALUE;

    public StatsRocket() {
        this.orbitHeight = (Integer)ARConfiguration.getCurrentConfig().orbit.get();
        this.injectionBurnLenghtMult = 1.0f;
        this.pilotSeatPos = new HashedBlockPosition(0, 0, 0);
        this.pilotSeatPos.x = Integer.MIN_VALUE;
        this.engineLoc = new ArrayList<Vector3F<Float>>();
        this.statTags = new HashMap();
    }

    public int getSeatX() {
        return this.pilotSeatPos.x;
    }

    public int getSeatY() {
        return this.pilotSeatPos.y;
    }

    public int getSeatZ() {
        return this.pilotSeatPos.z;
    }

    public HashedBlockPosition getPassengerSeat(int index) {
        return this.passengerSeats.get(index);
    }

    public int getNumPassengerSeats() {
        return this.passengerSeats.size();
    }

    public int getThrust() {
        return (int)((double)this.thrust * (Double)ARConfiguration.getCurrentConfig().rocketThrustMultiplier.get());
    }

    public int getWeight() {
        return this.weight;
    }

    public ResourceLocation getFuelFluid() {
        return this.fuelFluid;
    }

    public ResourceLocation getOxidizerFluid() {
        return this.oxidizerFluid;
    }

    public float getDrillingPower() {
        return this.drillingPower;
    }

    public void setDrillingPower(float power) {
        this.drillingPower = power;
    }

    public float getAcceleration(float gravitationalMultiplier) {
        return ((float)this.getThrust() - (float)this.weight * ((Boolean)ARConfiguration.getCurrentConfig().gravityAffectsFuel.get() != false ? gravitationalMultiplier : 1.0f)) / 10000.0f;
    }

    public List<Vector3F<Float>> getEngineLocations() {
        return this.engineLoc;
    }

    public void setThrust(int thrust) {
        this.thrust = thrust;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public void setFuelFluid(ResourceLocation fuelFluid) {
        this.fuelFluid = fuelFluid;
    }

    public void setOxidizerFluid(ResourceLocation oxidizerFluid) {
        this.oxidizerFluid = oxidizerFluid;
    }

    public void setSeatLocation(int x, int y, int z) {
        this.pilotSeatPos.x = x;
        this.pilotSeatPos.y = (short)y;
        this.pilotSeatPos.z = z;
    }

    public void addPassengerSeat(int x, int y, int z) {
        if (!this.hasSeat()) {
            this.setSeatLocation(x, y, z);
        }
        this.passengerSeats.add(new HashedBlockPosition(x, y, z));
    }

    public void addEngineLocation(float x, float y, float z) {
        this.engineLoc.add((Vector3F<Float>)new Vector3F((Object)Float.valueOf(x), (Object)Float.valueOf(y), (Object)Float.valueOf(z)));
    }

    public void clearEngineLocations() {
        this.engineLoc.clear();
    }

    public StatsRocket copy() {
        StatsRocket stat = new StatsRocket();
        stat.thrust = this.thrust;
        stat.weight = this.weight;
        stat.fuelFluid = this.fuelFluid;
        stat.oxidizerFluid = this.oxidizerFluid;
        stat.drillingPower = this.drillingPower;
        for (FuelRegistry.FuelType type : FuelRegistry.FuelType.values()) {
            stat.setFuelAmount(type, this.getFuelAmount(type));
            stat.setFuelRate(type, this.getFuelRate(type));
            stat.setFuelCapacity(type, this.getFuelCapacity(type));
            stat.setBaseFuelRate(type, this.getBaseFuelRate(type));
        }
        stat.pilotSeatPos = new HashedBlockPosition(this.pilotSeatPos.x, (int)this.pilotSeatPos.y, this.pilotSeatPos.z);
        stat.passengerSeats.addAll(this.passengerSeats);
        stat.engineLoc = new ArrayList<Vector3F<Float>>(this.engineLoc);
        stat.statTags = new HashMap<String, Object>(this.statTags);
        return stat;
    }

    public int getFuelAmount(FuelRegistry.FuelType type) {
        switch (type) {
            case WARP: {
                return this.fuelWarp;
            }
            case IMPULSE: {
                return this.fuelImpulse;
            }
            case ION: {
                return this.fuelIon;
            }
            case LIQUID_MONOPROPELLANT: {
                return this.fuelMonopropellant;
            }
            case LIQUID_BIPROPELLANT: {
                return this.fuelBipropellant;
            }
            case LIQUID_OXIDIZER: {
                return this.fuelOxidizer;
            }
            case NUCLEAR: {
                return this.fuelNuclear;
            }
        }
        return 0;
    }

    public int getFuelCapacity(FuelRegistry.FuelType type) {
        switch (type) {
            case WARP: {
                return this.fuelCapacityWarp;
            }
            case IMPULSE: {
                return this.fuelCapacityImpulse;
            }
            case ION: {
                return this.fuelCapacityIon;
            }
            case LIQUID_MONOPROPELLANT: {
                return this.fuelCapacityMonopropellant;
            }
            case LIQUID_BIPROPELLANT: {
                return this.fuelCapacityBipropellant;
            }
            case LIQUID_OXIDIZER: {
                return this.fuelCapacityOxidizer;
            }
            case NUCLEAR: {
                return this.fuelCapacityNuclear;
            }
        }
        return 0;
    }

    public int getFuelRate(FuelRegistry.FuelType type) {
        if (!((Boolean)ARConfiguration.getCurrentConfig().rocketRequireFuel.get()).booleanValue()) {
            return 0;
        }
        switch (type) {
            case WARP: {
                return this.fuelRateWarp;
            }
            case IMPULSE: {
                return this.fuelRateImpulse;
            }
            case ION: {
                return this.fuelRateIon;
            }
            case LIQUID_MONOPROPELLANT: {
                return this.fuelRateMonopropellant;
            }
            case LIQUID_BIPROPELLANT: {
                return this.fuelRateBipropellant;
            }
            case LIQUID_OXIDIZER: {
                return this.fuelRateOxidizer;
            }
            case NUCLEAR: {
                return this.fuelRateNuclear;
            }
        }
        return 0;
    }

    public float getBaseFuelRate(FuelRegistry.FuelType type) {
        if (!((Boolean)ARConfiguration.getCurrentConfig().rocketRequireFuel.get()).booleanValue()) {
            return 0.0f;
        }
        switch (type) {
            case WARP: {
                return this.fuelBaseRateWarp;
            }
            case IMPULSE: {
                return this.fuelBaseRateImpulse;
            }
            case ION: {
                return this.fuelBaseRateIon;
            }
            case LIQUID_MONOPROPELLANT: {
                return this.fuelBaseRateMonopropellant;
            }
            case LIQUID_BIPROPELLANT: {
                return this.fuelBaseRateBipropellant;
            }
            case LIQUID_OXIDIZER: {
                return this.fuelBaseRateOxidizer;
            }
            case NUCLEAR: {
                return this.fuelBaseRateNuclear;
            }
        }
        return 0.0f;
    }

    public void setFuelAmount(FuelRegistry.FuelType type, int amt) {
        switch (type) {
            case WARP: {
                this.fuelWarp = amt;
                break;
            }
            case IMPULSE: {
                this.fuelImpulse = amt;
                break;
            }
            case ION: {
                this.fuelIon = amt;
                break;
            }
            case LIQUID_MONOPROPELLANT: {
                this.fuelMonopropellant = amt;
                break;
            }
            case LIQUID_BIPROPELLANT: {
                this.fuelBipropellant = amt;
                break;
            }
            case LIQUID_OXIDIZER: {
                this.fuelOxidizer = amt;
                break;
            }
            case NUCLEAR: {
                this.fuelNuclear = amt;
            }
        }
    }

    public void setFuelRate(FuelRegistry.FuelType type, int rate) {
        switch (type) {
            case WARP: {
                this.fuelRateWarp = rate;
                break;
            }
            case IMPULSE: {
                this.fuelRateImpulse = rate;
                break;
            }
            case ION: {
                this.fuelRateIon = rate;
                break;
            }
            case LIQUID_MONOPROPELLANT: {
                this.fuelRateMonopropellant = rate;
                break;
            }
            case LIQUID_BIPROPELLANT: {
                this.fuelRateBipropellant = rate;
                break;
            }
            case LIQUID_OXIDIZER: {
                this.fuelRateOxidizer = rate;
                break;
            }
            case NUCLEAR: {
                this.fuelRateNuclear = rate;
            }
        }
    }

    public void setBaseFuelRate(FuelRegistry.FuelType type, float rate) {
        switch (type) {
            case WARP: {
                this.fuelBaseRateWarp = rate;
                break;
            }
            case IMPULSE: {
                this.fuelBaseRateImpulse = rate;
                break;
            }
            case ION: {
                this.fuelBaseRateIon = rate;
                break;
            }
            case LIQUID_MONOPROPELLANT: {
                this.fuelBaseRateMonopropellant = rate;
                break;
            }
            case LIQUID_BIPROPELLANT: {
                this.fuelBaseRateBipropellant = rate;
                break;
            }
            case LIQUID_OXIDIZER: {
                this.fuelBaseRateOxidizer = rate;
                break;
            }
            case NUCLEAR: {
                this.fuelBaseRateNuclear = rate;
            }
        }
    }

    public void setFuelCapacity(FuelRegistry.FuelType type, int amt) {
        switch (type) {
            case WARP: {
                this.fuelCapacityWarp = amt;
                break;
            }
            case IMPULSE: {
                this.fuelCapacityImpulse = amt;
                break;
            }
            case ION: {
                this.fuelCapacityIon = amt;
                break;
            }
            case LIQUID_MONOPROPELLANT: {
                this.fuelCapacityMonopropellant = amt;
                break;
            }
            case LIQUID_BIPROPELLANT: {
                this.fuelCapacityBipropellant = amt;
                break;
            }
            case LIQUID_OXIDIZER: {
                this.fuelCapacityOxidizer = amt;
                break;
            }
            case NUCLEAR: {
                this.fuelCapacityNuclear = amt;
            }
        }
    }

    public int addFuelAmount(FuelRegistry.FuelType type, int amt) {
        switch (type) {
            case WARP: {
                this.fuelWarp += amt;
                return this.fuelWarp;
            }
            case IMPULSE: {
                this.fuelImpulse += amt;
                return this.fuelImpulse;
            }
            case ION: {
                this.fuelIon += amt;
                return this.fuelIon;
            }
            case LIQUID_MONOPROPELLANT: {
                int maxAddMono = this.fuelCapacityMonopropellant - this.fuelMonopropellant;
                int amountToAddMono = Math.min(amt, maxAddMono);
                this.fuelMonopropellant += amountToAddMono;
                return amountToAddMono;
            }
            case LIQUID_BIPROPELLANT: {
                int maxAddBi = this.fuelCapacityBipropellant - this.fuelBipropellant;
                int amountToAddBi = Math.min(amt, maxAddBi);
                this.fuelBipropellant += amountToAddBi;
                return amountToAddBi;
            }
            case LIQUID_OXIDIZER: {
                int maxAddOxi = this.fuelCapacityOxidizer - this.fuelOxidizer;
                int amountToAddOxi = Math.min(amt, maxAddOxi);
                this.fuelOxidizer += amountToAddOxi;
                return amountToAddOxi;
            }
            case NUCLEAR: {
                this.fuelNuclear += amt;
                return this.fuelNuclear;
            }
        }
        return 0;
    }

    public boolean hasSeat() {
        return this.pilotSeatPos.x != Integer.MIN_VALUE;
    }

    public void reset() {
        this.thrust = 0;
        this.weight = 0;
        this.fuelFluid = null;
        this.oxidizerFluid = null;
        this.drillingPower = 0.0f;
        for (FuelRegistry.FuelType type : FuelRegistry.FuelType.values()) {
            this.setFuelAmount(type, 0);
            this.setFuelRate(type, 0);
            this.setFuelCapacity(type, 0);
        }
        this.fuelMonopropellant = 0;
        this.fuelBipropellant = 0;
        this.fuelOxidizer = 0;
        this.pilotSeatPos.x = Integer.MIN_VALUE;
        this.clearEngineLocations();
        this.passengerSeats.clear();
        this.statTags.clear();
    }

    public void setStatTag(String str, float value) {
        this.statTags.put(str, new Float(value));
    }

    public void setStatTag(String str, int value) {
        this.statTags.put(str, new Integer(value));
    }

    public Object getStatTag(String str) {
        Object obj = this.statTags.get(str);
        return obj == null ? Integer.valueOf(0) : obj;
    }

    public static StatsRocket createFromNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b(TAGNAME)) {
            CompoundNBT stats = nbt.func_74775_l(TAGNAME);
            StatsRocket statsRocket = new StatsRocket();
            statsRocket.readFromNBT(stats);
            return statsRocket;
        }
        return new StatsRocket();
    }

    public void writeToNBT(CompoundNBT nbt) {
        HashedBlockPosition vec;
        int[] locs;
        CompoundNBT stats = new CompoundNBT();
        stats.func_74768_a("thrust", this.thrust);
        stats.func_74768_a("weight", this.weight);
        if (this.fuelFluid != null) {
            stats.func_74778_a("fuelFluid", this.fuelFluid.toString());
        }
        if (this.oxidizerFluid != null) {
            stats.func_74778_a("oxidizerFluid", this.oxidizerFluid.toString());
        }
        stats.func_74776_a("drillingPower", this.drillingPower);
        stats.func_74768_a("fuelMonopropellant", this.fuelMonopropellant);
        stats.func_74768_a("fuelBipropellant", this.fuelBipropellant);
        stats.func_74768_a("fuelOxidizer", this.fuelOxidizer);
        stats.func_74768_a("fuelImpulse", this.fuelImpulse);
        stats.func_74768_a("fuelIon", this.fuelIon);
        stats.func_74768_a("fuelNuclear", this.fuelNuclear);
        stats.func_74768_a("fuelWarp", this.fuelWarp);
        stats.func_74768_a("fuelCapacityMonopropellant", this.fuelCapacityMonopropellant);
        stats.func_74768_a("fuelCapacityBipropellant", this.fuelCapacityBipropellant);
        stats.func_74768_a("fuelCapacityOxidizer", this.fuelCapacityOxidizer);
        stats.func_74768_a("fuelCapacityImpulse", this.fuelCapacityImpulse);
        stats.func_74768_a("fuelCapacityIon", this.fuelCapacityIon);
        stats.func_74768_a("fuelCapacityNuclear", this.fuelCapacityNuclear);
        stats.func_74768_a("fuelCapacityWarp", this.fuelCapacityWarp);
        stats.func_74768_a("fuelRateMonopropellant", this.fuelRateMonopropellant);
        stats.func_74768_a("fuelRateBipropellant", this.fuelRateBipropellant);
        stats.func_74768_a("fuelRateOxidizer", this.fuelRateOxidizer);
        stats.func_74768_a("fuelRateImpulse", this.fuelRateImpulse);
        stats.func_74768_a("fuelRateIon", this.fuelRateIon);
        stats.func_74768_a("fuelRateNuclear", this.fuelRateNuclear);
        stats.func_74768_a("fuelRateWarp", this.fuelRateWarp);
        stats.func_74776_a("fuelBaseRateMonopropellant", this.fuelBaseRateMonopropellant);
        stats.func_74776_a("fuelBaseRateBipropellant", this.fuelBaseRateBipropellant);
        stats.func_74776_a("fuelBaseRateOxidizer", this.fuelBaseRateOxidizer);
        stats.func_74776_a("fuelBaseRateImpulse", this.fuelBaseRateImpulse);
        stats.func_74776_a("fuelBaseRateIon", this.fuelBaseRateIon);
        stats.func_74776_a("fuelBaseRateNuclear", this.fuelBaseRateNuclear);
        stats.func_74776_a("fuelBaseRateWarp", this.fuelBaseRateWarp);
        CompoundNBT dynStats = new CompoundNBT();
        for (String key : this.statTags.keySet()) {
            Object obj = this.statTags.get(key);
            if (obj instanceof Float) {
                dynStats.func_74776_a(key, ((Float)obj).floatValue());
                continue;
            }
            if (!(obj instanceof Integer)) continue;
            dynStats.func_74768_a(key, ((Integer)obj).intValue());
        }
        if (!dynStats.isEmpty()) {
            stats.func_218657_a("dynStats", (INBT)dynStats);
        }
        stats.func_74768_a("playerXPos", this.pilotSeatPos.x);
        stats.func_74768_a("playerYPos", (int)this.pilotSeatPos.y);
        stats.func_74768_a("playerZPos", this.pilotSeatPos.z);
        if (!this.engineLoc.isEmpty()) {
            locs = new int[this.engineLoc.size() * 3];
            int i = 0;
            while (i / 3 < this.engineLoc.size()) {
                vec = this.engineLoc.get(i / 3);
                locs[i] = ((Float)vec.x).intValue();
                locs[i + 1] = ((Float)vec.y).intValue();
                locs[i + 2] = ((Float)vec.z).intValue();
                i += 3;
            }
            stats.func_74783_a("engineLoc", locs);
        }
        if (!this.passengerSeats.isEmpty()) {
            locs = new int[this.passengerSeats.size() * 3];
            int i = 0;
            while (i / 3 < this.passengerSeats.size()) {
                vec = this.passengerSeats.get(i / 3);
                locs[i] = vec.x;
                locs[i + 1] = vec.y;
                locs[i + 2] = vec.z;
                i += 3;
            }
            stats.func_74783_a("passengerSeats", locs);
        }
        nbt.func_218657_a(TAGNAME, (INBT)stats);
    }

    public void readFromNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b(TAGNAME)) {
            int[] locations;
            CompoundNBT stats = nbt.func_74775_l(TAGNAME);
            this.thrust = stats.func_74762_e("thrust");
            this.weight = stats.func_74762_e("weight");
            this.fuelFluid = nbt.func_74764_b("fuelFluid") ? ResourceLocation.func_208304_a((String)stats.func_74779_i("fuelFluid")) : null;
            this.oxidizerFluid = nbt.func_74764_b("oxidizerFluid") ? ResourceLocation.func_208304_a((String)stats.func_74779_i("oxidizerFluid")) : null;
            this.drillingPower = stats.func_74760_g("drillingPower");
            this.fuelMonopropellant = stats.func_74762_e("fuelMonopropellant");
            this.fuelBipropellant = stats.func_74762_e("fuelBipropellant");
            this.fuelOxidizer = stats.func_74762_e("fuelOxidizer");
            this.fuelImpulse = stats.func_74762_e("fuelImpulse");
            this.fuelIon = stats.func_74762_e("fuelIon");
            this.fuelNuclear = stats.func_74762_e("fuelNuclear");
            this.fuelWarp = stats.func_74762_e("fuelWarp");
            this.fuelCapacityMonopropellant = stats.func_74762_e("fuelCapacityMonopropellant");
            this.fuelCapacityBipropellant = stats.func_74762_e("fuelCapacityBipropellant");
            this.fuelCapacityOxidizer = stats.func_74762_e("fuelCapacityOxidizer");
            this.fuelCapacityImpulse = stats.func_74762_e("fuelCapacityImpulse");
            this.fuelCapacityIon = stats.func_74762_e("fuelCapacityIon");
            this.fuelCapacityNuclear = stats.func_74762_e("fuelCapacityNuclear");
            this.fuelCapacityWarp = stats.func_74762_e("fuelCapacityWarp");
            this.fuelRateMonopropellant = stats.func_74762_e("fuelRateMonopropellant");
            this.fuelRateBipropellant = stats.func_74762_e("fuelRateBipropellant");
            this.fuelRateOxidizer = stats.func_74762_e("fuelRateOxidizer");
            this.fuelRateImpulse = stats.func_74762_e("fuelRateImpulse");
            this.fuelRateIon = stats.func_74762_e("fuelRateIon");
            this.fuelRateNuclear = stats.func_74762_e("fuelRateNuclear");
            this.fuelRateWarp = stats.func_74762_e("fuelRateWarp");
            this.fuelBaseRateMonopropellant = stats.func_74762_e("fuelBaseRateMonopropellant");
            this.fuelBaseRateBipropellant = stats.func_74762_e("fuelBaseRateBipropellant");
            this.fuelBaseRateOxidizer = stats.func_74762_e("fuelBaseRateOxidizer");
            this.fuelBaseRateImpulse = stats.func_74762_e("fuelBaseRateImpulse");
            this.fuelBaseRateIon = stats.func_74762_e("fuelBaseRateIon");
            this.fuelBaseRateNuclear = stats.func_74762_e("fuelBaseRateNuclear");
            this.fuelBaseRateWarp = stats.func_74762_e("fuelBaseRateWarp");
            if (stats.func_74764_b("dynStats")) {
                CompoundNBT dynStats = stats.func_74775_l("dynStats");
                for (Object key : dynStats.func_150296_c()) {
                    INBT obj = dynStats.func_74781_a((String)key);
                    if (obj instanceof FloatNBT) {
                        this.setStatTag((String)key, dynStats.func_74760_g((String)key));
                        continue;
                    }
                    if (!(obj instanceof IntNBT)) continue;
                    this.setStatTag((String)key, dynStats.func_74762_e((String)key));
                }
            }
            this.pilotSeatPos.x = stats.func_74762_e("playerXPos");
            this.pilotSeatPos.y = (short)stats.func_74762_e("playerYPos");
            this.pilotSeatPos.z = stats.func_74762_e("playerZPos");
            if (stats.func_74764_b("engineLoc")) {
                locations = stats.func_74759_k("engineLoc");
                for (int i = 0; i < locations.length; i += 3) {
                    this.addEngineLocation(locations[i], locations[i + 1], locations[i + 2]);
                }
            }
            if (stats.func_74764_b("passengerSeats")) {
                locations = stats.func_74759_k("passengerSeats");
                for (int i = 0; i < locations.length; i += 3) {
                    this.addPassengerSeat(locations[i], locations[i + 1], locations[i + 2]);
                }
            }
        }
    }
}

