/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api.atmosphere;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.fluid.Fluid;
import zmaster587.advancedRocketry.api.IAtmosphere;

public class AtmosphereRegister {
    private static final AtmosphereRegister instance = new AtmosphereRegister();
    Map<String, IAtmosphere> atmosphereRegistration = new HashMap<String, IAtmosphere>();
    List<Fluid> harvestableAtmosphere;
    List<IAtmosphere> atmosphereList = new LinkedList<IAtmosphere>();

    private AtmosphereRegister() {
        this.harvestableAtmosphere = new LinkedList<Fluid>();
    }

    public static final AtmosphereRegister getInstance() {
        return instance;
    }

    public void registerAtmosphere(IAtmosphere atmosphere) {
        this.atmosphereRegistration.put(atmosphere.getUnlocalizedName(), atmosphere);
        this.atmosphereList.add(atmosphere);
    }

    public IAtmosphere getAtmosphere(String identifier) {
        IAtmosphere atm = this.atmosphereRegistration.get(identifier);
        return atm == null ? this.getAtmosphere("air") : atm;
    }

    public void registerHarvestableFluid(Fluid fluid) {
        this.harvestableAtmosphere.add(fluid);
    }

    public List<Fluid> getHarvestableGasses() {
        return this.harvestableAtmosphere;
    }

    public List<IAtmosphere> getAtmosphereList() {
        return this.atmosphereList;
    }
}

