/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api.dimension.solar;

import java.util.List;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;

public class Planet {
    private int dimId;
    private StellarBody star;
    private List<Planet> moons;
    private List<SatelliteBase> satellites;
    private List<SatelliteBase> tickingSatellites;
    private double orbit;

    public Planet(StellarBody star, int dimId) {
        this.star = star;
    }

    public void addMoon(Planet moon) {
        this.moons.add(moon);
    }

    public void addSatellite(SatelliteBase satellite) {
        this.satellites.add(satellite);
        if (satellite.canTick()) {
            this.tickingSatellites.add(satellite);
        }
    }

    public boolean removeSatellite(SatelliteBase satellite) {
        if (satellite.canTick()) {
            this.tickingSatellites.remove(satellite);
        }
        return this.satellites.remove(satellite);
    }

    public List<SatelliteBase> getSatellites() {
        return this.satellites;
    }

    public void tick() {
        for (SatelliteBase satellite : this.tickingSatellites) {
            satellite.tickEntity();
        }
    }

    public StellarBody getStar() {
        return this.star;
    }

    public int getDimensionId() {
        return this.dimId;
    }

    public List<Planet> getMoons() {
        return this.moons;
    }
}

