/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api.fuel;

import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;

public class FuelRegistry {
    public static final FuelRegistry instance = new FuelRegistry();

    public boolean registerFuel(FuelType type, Fluid fluid, float multiplier) {
        fuelEntry entry = new fuelEntry(fluid, multiplier);
        return type.addFuel(entry);
    }

    public boolean registerFuel(FuelType type, ItemStack item, float multiplier) {
        fuelEntry entry = new fuelEntry(item, multiplier);
        return type.addFuel(entry);
    }

    public boolean isFuel(FuelType type, ItemStack stack) {
        return this.isFuel(type, (Object)stack);
    }

    public boolean isFuel(FuelType type, Fluid fluid) {
        return this.isFuel(type, (Object)fluid);
    }

    private boolean isFuel(FuelType type, Object obj) {
        return type.isFuel(obj);
    }

    public float getMultiplier(FuelType type, ItemStack stack) {
        return this.getMultiplier(type, (Object)stack);
    }

    public float getMultiplier(FuelType type, Fluid fluid) {
        return this.getMultiplier(type, (Object)fluid);
    }

    private float getMultiplier(FuelType type, Object obj) {
        fuelEntry fuel = type.getFuel(obj);
        if (fuel == null) {
            return 0.0f;
        }
        return fuel.multiplier;
    }

    private class fuelEntry {
        private Object fuel;
        private FuelType type;
        private float multiplier;

        public fuelEntry(Object fuel, float multiplier) {
            this.fuel = fuel;
            this.multiplier = multiplier;
        }

        public boolean fuelMatches(Object obj) {
            if (this.fuel.getClass() != obj.getClass()) {
                return false;
            }
            if (this.fuel instanceof ItemStack) {
                return ItemStack.func_77989_b((ItemStack)((ItemStack)this.fuel), (ItemStack)((ItemStack)obj));
            }
            if (this.fuel instanceof Fluid) {
                return this.fuel.equals(obj);
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (obj != null) {
                if (obj instanceof fuelEntry) {
                    fuelEntry cmp = (fuelEntry)obj;
                    return this.fuelMatches(cmp.fuel) && cmp.type == cmp.type;
                }
                return super.equals(obj);
            }
            return false;
        }
    }

    public static enum FuelType {
        LIQUID_MONOPROPELLANT,
        LIQUID_BIPROPELLANT,
        LIQUID_OXIDIZER,
        NUCLEAR,
        ION,
        WARP,
        IMPULSE;

        final HashSet<fuelEntry> fuels = new HashSet();

        public boolean addFuel(fuelEntry entry) {
            entry.type = this;
            return !this.fuels.add(entry);
        }

        public boolean isFuel(ItemStack stack) {
            return this.isFuel((Object)stack);
        }

        public boolean isFuel(Fluid stack) {
            return this.isFuel((Object)stack);
        }

        private boolean isFuel(Object obj) {
            Iterator<fuelEntry> currFuel = this.fuels.iterator();
            while (currFuel.hasNext()) {
                if (currFuel.next().fuel != obj) continue;
                return true;
            }
            return false;
        }

        public fuelEntry getFuel(ItemStack stack) {
            return this.getFuel((Object)stack);
        }

        public fuelEntry getFuel(Fluid fluid) {
            return this.getFuel((Object)fluid);
        }

        private fuelEntry getFuel(Object obj) {
            for (fuelEntry entry : this.fuels) {
                if (!entry.fuelMatches(obj)) continue;
                return entry;
            }
            return null;
        }
    }
}

